﻿<?php
//Main entry point for the crawler
// usage:
// /cygdrive/c/xampp/php/php.exe cli_runner.php demo/sample_stream
// for facebook:
/*
  cd /cygdrive/c/xampp/htdocs/allInOneWeb/tools/cowitter/ && /cygdrive/c/xampp/php/php.exe cli_runner.php get_facebook_data egypt-1 file page comment beara txt
  cd /cygdrive/c/xampp/htdocs/allInOneWeb/tools/cowitter/ && /cygdrive/c/xampp/php/php.exe cli_runner.php get_facebook_data jordan-1+2 file page comment yisov txt
 */
require __DIR__ . '/cli_filter_application.php';
// require __DIR__ . '/../fb_crawler/fb_crwaler.php';
require __DIR__ . '/../remote_db/RemoteDataBases.php';

if ($argc < 2) {
    die("Please provide requested operation, e.g. demo");
}

switch ($argv[1]) {
    case 'demo':
        echo "demo\n";
        filter_app('statuses/sample', 'demo_handler_function');
        break;
    case 'sample_stream':
        echo "tweets from the free sample stream\n";
        filter_app('statuses/sample', 'stream_handler_function_all');
        break;
    case 'sample_stream_ar'://check!
        echo "tweets from the free sample stream in arabic\n";
        filter_app('statuses/sample', 'stream_handler_function_ar');
        break;
    case 'follow_list':
        echo "following user list\n";
        follow_app();
        break;
    case 'filter_stream':
        echo "tweets from the stream filtered by keywords\n";
        if ($argc < 3) {
            die("Please provide file of filter in json format");
        }
        //set stream handler timeout to arg #3 (minutes)
        if ($argc > 3) {
            global $streamHandlerTimeout;
            $streamHandlerTimeout = new DateTime();
            $streamHandlerTimeout->add(new DateInterval('PT' . $argv[3] . "M"));
        }
        filter_app_advance('statuses/filter', 'stream_handler_function_all', $argv[2]);
        break;
    case 'filter_stream_db':
        echo "tweets from the stream filtered by keywords\n";
        if ($argc < 3) {
            die("Please provide file of filter in json format");
        }
        //set stream handler timeout to arg #3 (minutes)
        if ($argc > 3) {
            global $streamHandlerTimeout;
            $streamHandlerTimeout = new DateTime();
            $streamHandlerTimeout->add(new DateInterval('PT' . $argv[3] . "M"));
        }
        filter_app_advance('statuses/filter', 'stream_handler_function_all_db', $argv[2]);
        break;
        
    case 'filter_stream_db_twitter':
        echo "filter_stream_db_new: tweets from the stream filtered by keywords\n";
//         filter_app_advance_db('statuses/filter', 'stream_handler_function_all_db');
        require_once 'twitter_v2.php';
        $response = Felix\TwitterStream\filter_app_core_db_v2($argv[2]);
        break;
        
    case 'get_followers':
        echo "get all followers of the users given as a list\n";
        if ($argc < 3) {
            die("Please provide a file of users in json format");
        }
        get_followers_app($argv[2]);
        break;
        
    case 'filter_and_parse':
        echo "Do not call directly if working on crawler stream!";
        echo "Please use ./run_filterandparse.bsh " . $cli_SINK_FILE . " in a separate window instead.\n";
        echo "Filter the json folder, parse the data and upload the relevant tweets\n";
        if ($argc < 3) {
            die("Please provide a file of filters in json format");
        }
        if ($argc < 4) {
            echo "No target json folder selected, we'll use the default\n";
        }
        filter_and_parse_app($argv[2], $argv[3], ($argc == 5) ? $argv[4] : NULL);

        break;
        
    case 'filter_and_parse_db':
        echo "Filter the json data from the db, parse the data and upload the relevant tweets\n";      
        filter_and_parse_app_db();
        break;
        
    case 'filter_and_parse_db_ui':
        echo "Via User call - Filter the json data from the db, parse the data and upload the relevant tweets\n";
        filter_and_parse_app_db_ui();
        break;
        
    case 'dump_filtered_raw_tweets':
        $minid_str = ($argc == 3) ? "with min id $argv[2]\n" : "without minimum id\n";
        echo "Dumping raw tweets $minid_str to sub-folder dump-$ivProjectName\n";
        dump_all_filtered_raw_tweets($argv[2] ?? 0);
        break;
    case 'dump_all_raw_tweets':
        echo "Dumping all raw tweets to sub-folder dump-$ivProjectName\n";
        dump_all_raw_tweets();
        break;
    case 'get_facebook_data':
        echo "\nGet data from Facebook API for each item (e.g. Facebook page url) in given list.\n";
        // we start from a list of pages/users/groups/posts or similar
        // we end up with their respective posts/comments or similar 
        get_fb_data($argv);
        break;
    case 'get_facebook_data_auto':
        // cd /cygdrive/c/xampp/htdocs/allInOneWeb/tools/cowitter/ && 
        // /cygdrive/c/xampp/php/php.exe cli_runner.php get_facebook_data_auto spain file page comment redalert txt "05:00 am"
        echo "Start of facebook auto crawler \n";
        get_fb_data_auto($argv);
        break;
    case 'analyze_facebook_data_auto':
        // cd /cygdrive/c/xampp/htdocs/allInOneWeb/tools/cowitter/ && 
        // /cygdrive/c/xampp/php/php.exe cli_runner.php analyze_facebook_data_auto redalert "07:00 am"
        echo "Start of facebook data analyzing/upload";
        analyze_facebook_data_auto($argv);
        break;
    case 'webHoseApp':
        echo "webHoseApp running\n";
        if ($argc < 3) {
            die("Please provide source folder and destination folder!");
        }
        $source_file = $argv[2];
        $days = $argv[3];
        echo "Working on webhose - source file: $source_file\n";
        echo "Fetching $days days ago \n";
        
        webHose_Action($source_file, $days);
        break;
    case 'read_from_remote_db':
        echo "Reading from remote db\n";
        if ($argc < 4) {
            die("Please provide server-type, server-name, database, user and password (user and pwd might be optional)");
        }
        $type = $argv[2];
        $srv_name = $argv[3];
        $db_srv = $argv[4];
        $user = $argv[5] ?? null;
        $pwd = $argv[6] ?? null;

        echo "Type: $type, Server Name: $srv_name, Data Base Name: $db_srv\n";
        if (!empty($user)) {
            echo "User: '$user'";
        }
        //creates new instance
        $new_crawler = new RemoteDataBases($type, $srv_name, $db_srv, $user, $pwd);
        $new_crawler->read_from_remote_db($db_srv);
        break;
    default:
        die("Unknown argument:" . $argv[1]);
}
