<?php

/**
 * Description of tableTree
 *
 * @author hilit
 */
require_once 'sqlUtils.php';

class TableTree {

    private $tree; //in future we will implement full tree of concepts like in content manger
    private $parentTable_dbname = "parent_tables";
    private $subTable_dbname = "sub_tables";

    public function __construct($connection) {
        $textFieldType = "VARCHAR(100)";

        if (!TablesInformation::isTableExists($connection, $this->get_parentTable_dbname())) {
            $this->createParentTables($connection, $textFieldType, false);
        }
        if (!TablesInformation::isTableExists($this->get_subTable_dbname())) {
            $this->createSubTables($connection, $textFieldType, false);
        }
    }

    public function get_parentTable_dbname() {
        return $this->parentTable_dbname;
    }

    public function get_subTable_dbname() {
        return $this->subTable_dbname;
    }

    /*
     * this function gets list of concept from background when doc is uploads
     * in the future we need to connect intuscan directly to get all concept tree
     */

    public static function insertParentTables($msqli, $subClass2classes) {
        if(count($subClass2classes)==0){
            write_to_log("INFO", "insertParentTables on empty input subClass2classes"); 
            return false;
        }
        $query = "INSERT IGNORE INTO parent_tables (concept_name,parent_name) VALUES ";
        foreach ($subClass2classes as $concept => $parents) {
            for ($i = 0; $i < count($parents); $i++) {
                $query .= "('$concept','$parents[$i]'),";
            }
        }
        $lquery = substr($query, 0, -1);
        return sqlQuery($msqli, $lquery);
    }

    /*
     * this function gets list of concept from background when doc is uploads
     * in the future we need to connect intuscan directly to get all concept tree
     */

    public static function insertSubTables($msqli, $class2subClasses) {
        if(count($class2subClasses)==0){
            write_to_log("INFO", "insertSubTables on empty input class2subClasses"); 
            return false;
        }
        $query = "INSERT IGNORE INTO sub_tables (concept_name,sub_concept_name) VALUES ";
        foreach ($class2subClasses as $concept => $sub_concepts) {
            for ($i = 0; $i < count($sub_concepts); $i++) {
                $query .= "('$concept','$sub_concepts[$i]'),";
            }
        }
        $lquery = substr($query, 0, -1);
        return sqlQuery($msqli, $lquery);
    }

    public static function createTreeTables($connection, $clean) {
        $textFieldType = "VARCHAR(100)";
        $isMemSQL = sqlGetConnectionDetails()["isMemSQL"];
        $referDeclr = $isMemSQL ? " REFERENCE " : "";

        self::createParentTables($connection, $textFieldType, $clean, $referDeclr);
        self::createSubTables($connection, $textFieldType, $clean, $referDeclr);
    }

    public static function createParentTables($connection, $textFieldType, $clean, $referDeclr) {
        if ($clean) {
            $res = sqlQuery($connection, "DROP TABLE IF EXISTS parent_tables");
        }
        sqlQuery($connection, "CREATE $referDeclr TABLE IF NOT EXISTS parent_tables (
                            id INT NOT NULL AUTO_INCREMENT,
                            concept_name $textFieldType,
                            parent_name $textFieldType,
                            PRIMARY KEY (id),
                            UNIQUE (concept_name,parent_name))");
    }

    public static function createSubTables($connection, $textFieldType, $clean, $referDeclr) {
        if ($clean) {
            $res = sqlQuery($connection, "DROP TABLE IF EXISTS sub_tables");
        }
        sqlQuery($connection, "CREATE $referDeclr TABLE IF NOT EXISTS sub_tables (
                            id INT NOT NULL AUTO_INCREMENT,
                            concept_name $textFieldType,
                            sub_concept_name $textFieldType,
                            PRIMARY KEY (id),
                            UNIQUE (concept_name,sub_concept_name))");
    }

}
