<?php

if(!isset($_SESSION)) session_start();
include_once("config.php");
include("loginCheckPoint.php");
include_once("authorizations.php");
require_once("demosettings.php");
//include_once("C:/xampp/htdocs/iventitymatcherhtm/bsw/utils.php");


$userdetails = fetchUserDetails($_SESSION['username']);
global $AUTH;
$userAuth = $AUTH["'" . $userdetails['Group_ID']. "'"];
	
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<link rel="icon" type="image/png" href="images/favicon.png" />
	<title>IntuScan Station</title>
    <link class="include" rel="stylesheet" type="text/css" href="dist/jquery.jqplot.min.css" />
    <link href="style.css" rel="stylesheet" type="text/css" />
    <!--[if lt IE 9]><script language="javascript" type="text/javascript" src="dist/excanvas.js"></script><![endif]-->
    <script class="include" type="text/javascript" src="dist/jquery.min.js"></script>
    <script class="include" type="text/javascript" src="dist/jquery.jqplot.min.js"></script>
    <script class="include" type="text/javascript" src="dist/plugins/jqplot.canvasTextRenderer.min.js"></script>
    <script class="include" type="text/javascript" src="dist/plugins/jqplot.canvasAxisLabelRenderer.min.js"></script>
    <script type="text/javascript" src="dist/plugins/jqplot.dateAxisRenderer.min.js"></script>
    <script type="text/javascript" src="dist/plugins/jqplot.highlighter.min.js"></script>
    <script type="text/javascript" src="dist/plugins/jqplot.enhancedLegendRenderer.min.js"></script>
    <script type="text/javascript" src="dist/plugins/jqplot.pieRenderer.min.js"></script>
	<script type="text/javascript" src="dist/plugins/jqplot.donutRenderer.min.js"></script>
    <style>
        .chart { height:400px; width:700px; }
    </style>
</head>
<body>
<div class="main">
 <div class="top-banner" style="display:<?php echo $topBannerDisplay?>">
	 <a href="javascript:gotoPage('home', {})"><img src="images/intuscan-img.png" style="border:0;"/></a>
	 <p style="padding:0 10px 10px 10px; float:right;"><b>version 1</b></p>
	 <p style="padding:0 10px 10px 10px; float:right;">Hi, <?php echo $_SESSION["username"] ?></p>
	 <p style="padding:0 10px 10px 10px; float:right;"><a style="color:red;" href="javascript:gotoPage('logoff', {})">logoff</a></p>
 </div>
  <div class="header" style="display:<?php echo $topBannerDisplay?>">
    
    <div class="header_block">
     
      <div class="clr"></div>
      <?php
      	include('general-toolbar.php'); 
      ?>
      <div class="clr"></div>
    </div>
    <div class="clr"></div>
  </div>
  <div id="loadingDiv"></div>
  <div class="content">
  		<center>
  			<table cellspacing="0" cellpadding="0">
  				<tbody>
  					<tr>
		  				<td class="first">
			  				<div>
						  		<select style="width: 180px;" name="GraphSelect" id="GraphSelect" onchange="changeGraph()"> 
						  			<optgroup label="General information">		
										<option value="general" selected="selected">General entities</option>
										<option value="languages">Languages</option>	
										<!--  <option value="format">File Format</option> -->
										<option value="threat_rating">Priority</option>
										<option value="PoliticalOrientation">Political Orientation</option>
										<option value="ReligiousAffiliation">Religious Affiliation</option>
										<option value="DatesGraph">Prominence/Sentiment by Date</option>
									</optgroup> 	
									<optgroup label="Prominence by entity">
										<option value="person_object">Person</option>
										<option value="place_object">Location</option>
										<option value="event">Event</option>
										<option value="organizational_identity">Organization</option>
									</optgroup>			
								</select>
							</div>
						</td>
						<td class="second">
							<div id="topEntities" style="display: none; float: right; ">
								<h4 style="margin-top: 0px;"><b>Please enter number of top entities to display ( 1-15 )</b></h4>
									<center>
										<button id="btnSubmit" type="button" onclick="changeGraph()">Submit</button>
							  			<input 	id="slices" value="10" style="width:50px" type="number" min="1" max="15" onkeypress='return event.charCode >= 48 && event.charCode <= 57'
											onkeydown="if (event.keyCode == 13) changeGraph()">
									</center>		
							</div>
						</td>
					</tr>
				</tbody>
			</table>	
		<div id="chartDivId" style="margin-top:20px; margin-left:20px; width:900px; height:600px;"></div>		
      	</center>	
      <div class="sidebar">
        
      </div>
      <div class="clr"></div>
  </div>
  	<div class="footer">
	
  </div>
</div>

</body>
<style>
	.first {border:1px solid #ffffff;}
	.second {border:1px solid #ffffff;}
</style>
<script type="text/javascript">

$(document).ready(changeGraph());

var showDataLabels = true;
var deSlices = 10;

$("#GraphSelect").change(function(){
	if($("#GraphSelect option:selected").val() == "person_object"){
		showLoading(true);
	}else if($("#GraphSelect option:selected").val() == "place_object"){
		showLoading(true);
	}else if($("#GraphSelect option:selected").val() == "event"){
		showLoading(true);
	}else if($("#GraphSelect option:selected").val() == "organizational_identity"){
		showLoading(true);
	}else
		$("#topEntities").css('display' , "none");
		
});
	function changeGraph(){

		if (document.getElementById("GraphSelect").value === "languages"){
			getDataFromOptions({langs: "allLangs"});
			showDataLabels = true;
		}else if (document.getElementById("GraphSelect").value === "general"){
			getDataFromOptions({tabs: JSON.stringify(["person_object","organizational_identity","date","place_object"])});
			showDataLabels = true;
		}else if (document.getElementById("GraphSelect").value === "threat_rating"){
			getDataFromOptions({risks: JSON.stringify(["High", "Medium", "Low", "None"])});
			showDataLabels = true;
		}else if (document.getElementById("GraphSelect").value === "PoliticalOrientation"){
			getDataFromOptions({orients: "political"});
			showDataLabels = true;
		}else if (document.getElementById("GraphSelect").value === "ReligiousAffiliation"){
			getDataFromOptions({religious: "religious"});
			showDataLabels = true;
		}else if (document.getElementById("GraphSelect").value === "DatesGraph"){
			gotoDatesGraphsPage();
			showDataLabels = true;
		}else if (document.getElementById("GraphSelect").value === "person_object"){
			showDataLabels = false;
			getPromFromEng("person_object", getNumberOfSlices());
		}else if (document.getElementById("GraphSelect").value === "place_object"){
			showDataLabels = false;
			getPromFromEng("place_object", getNumberOfSlices());
		}else if (document.getElementById("GraphSelect").value === "event"){
			showDataLabels = false;
			getPromFromEng("event", getNumberOfSlices());
		}else if (document.getElementById("GraphSelect").value === "organizational_identity"){
			showDataLabels = false;
			getPromFromEng("organizational_identity", getNumberOfSlices());
		}else
			drawGeneralChart();
	}
	
	function getNumberOfSlices(){
		return $("#slices").val();
	}

	function gotoDatesGraphsPage(){
		window.location.href = "proSentPage.php";
	}
	
	function getPromFromEng(table, number){
		
		if(getNumberOfSlices() < 1) 
			var number = 10;
		if(getNumberOfSlices() > 15){ 
			var number = 15;
			$("#slices").val(15);
		}
		$.getJSON("StatisticPageEng.php", {"table":table, "slices":number}, function(data){
			hideLoading(true);
			removeChildNodes();
			//console.log(data.amount);
			renderPie(data.amount, data.title);
		});
	}

	function getDataFromOptions(mData){
		showLoading(false);
		$.ajax({
			   type: "POST",
			   data: mData,
			   traditional: true,
			   url: "StatisticPageEng.php",
			   success: function(msg){
				hideLoading(false);
				var obj = JSON.parse(msg);
				 removeChildNodes();
				 //console.log(obj.amount);
			     renderPie(obj.amount, obj.title);
			   }
			});
	}

	function removeChildNodes(){
		var div = document.getElementById('chartDivId');
		while(div.hasChildNodes()) {
		    div.removeChild(div.firstChild);
		}
	}

	function renderPie(values, mTitle){

		var data = [values];
		var options = {
			    title:{
		    			 text: mTitle,
		    			 fontSize: 30,
		    			 fontFamily: 'Georgia'
		    	},
			    seriesDefaults: {
			      renderer: jQuery.jqplot.PieRenderer,
			      rendererOptions: {
			          showDataLabels: showDataLabels
			          //dataLabels: 'label'
			        }
			    },		                  
			    legend: {
				     show:true,
				     location: 'e',
				     fontSize: 15
				 //    rendererOptions: {numberColumns: col} // Adding more columns
			      }    
			  };	   
		  $.jqplot('chartDivId', data, options);
			  $("#chartDivId").bind('jqplotDataHighlight', function(ev, seriesIndex, pointIndex, data) {
		            var $this = $(this);                

					if(data[0].includes("*")){
						$this.attr('title', "Aggregated " + data[0]);	
					}else{
		            	$this.attr('title', data[0]);
					}                               
		  });
		  $("#chartDivId").bind('jqplotDataUnhighlight', function(ev, seriesIndex, pointIndex, data) {
		            var $this = $(this);                

		            $this.attr('title',""); 
		  });
		  $('.jqplot-data-label').css("color","white");  
	}

    $('#chartDivId').bind('jqplotDataClick', 
            function (ev, seriesIndex, pointIndex, data) {
                var res = data[0].split(" (");
                var entity = res[0];
                //entity = entity.replace('*','');
				var label = document.getElementById("GraphSelect").value;
				var value = entity.split("(")[0];

				if(value !== "None"){
					
	                if(document.getElementById("GraphSelect").value === "person_object")
	            		gotoPage("searchResults", {"searchPerson": entity});
	                else if (document.getElementById("GraphSelect").value === "place_object")
	                	gotoPage("searchResults", {"searchPlaces": entity});
	        		else if (document.getElementById("GraphSelect").value === "event")
	        			gotoPage("searchResults", {"searchEvents": entity});
	        		else if (document.getElementById("GraphSelect").value === "organizational_identity")
	        			gotoPage("searchResults", {"searchOrganization": entity});
	        		else if (document.getElementById("GraphSelect").value === "threat_rating"){
	        				gotoPage("searchResults", {"searchLable": ";"+label+"="+value});
	        		}else if (document.getElementById("GraphSelect").value === "languages")
	        			gotoPage("searchResults", {"searchLable": ";"+label+"="+value});
	        		else if (document.getElementById("GraphSelect").value === "PoliticalOrientation"){
	        				gotoPage("searchResults", {"searchLable": ";ideological_stream="+value});
	        		}else if (document.getElementById("GraphSelect").value === "ReligiousAffiliation"){
	        				gotoPage("searchResults", {"searchLable": ";islamic_sect="+value});
	        		}else
	            		console.log("No data was found");
				}else{
					window.alert("Currently not available");
				}
	});

function showLoading(isEntities){
	$("#loadingDiv").html("<p align=center><img src='images/loader.gif'/></p><p align=center><b>Please wait</b></p>").show();
	$("#chartDivId").hide();
	$("#GraphSelect").hide();
	if(isEntities){
		$("#topEntities").css('display' , "none");
	}
}

function hideLoading(isEntities){
	$("#loadingDiv").hide();
	$("#chartDivId").show();
	$("#GraphSelect").show();
	if(isEntities){
		$("#topEntities").css('display' , "block");
	}	
}	
</script>