<?php


require_once 'sqlUtils.php';
require_once 'allConceptsData.php';


class Settings {

    private $mysqli = null;
    private $username = "";
    private $actions_map = array(
        //visual settings
        "getDashboardLanguages" => array("settings"=> "visual", "section"=> "dashboard_languages"),   
        "getDateFormats" => array("settings"=> "visual", "section"=> "date_format"),
        "getFonts" => array("settings"=> "visual", "section"=> "font"),
        "getFontSizes" => array("settings"=> "visual", "section"=> "font_size"),  
        "getThemes" => array("settings"=> "visual", "section"=> "theme"),
        
        //be settings
        "getPermissions" => array("settings"=> "be", "section"=> "system_settings", "sub_section"=>"permissions"),
        
        //ui settings
        "getTableFields" => array("settings"=> "ui", "section"=>"table_columns"),
        "setTableFields" => array("settings"=> "ui", "section"=>"table_columns"),
        "getFlavors" => array("settings"=> "ui", "section"=>"flavors"),
        "setFlavors" => array("settings"=> "ui", "section"=>"flavors"),
        "getDefaultFilters" => array("settings"=> "ui", "section"=>"default_filters"),
        "getKeyStats" => array("settings"=> "ui", "section"=>"key_stats_default_fields"),
        "setKeyStats" => array("settings"=> "ui", "section"=>"key_stats_default_fields"),
        "getLanguages" => array("settings"=> "ui", "section"=> "languages")

    );

    public function __construct($mysqli, $username) {
        $this->mysqli = $mysqli;
        $this->username = $username;
 
    }
    
    /**
     * getSettings main Function
     * @param unknown $key
     * @return NULL|unknown|mixed
     */
    public function getSettings($settings = null, $section = null, $sub_section = null) {
        //assign section subsection if needed
        if(array_key_exists($section, $this->actions_map)){
            $settings = $this->actions_map[$section]["settings"]; 
            $section_tmp = $this->actions_map[$section]["section"];
            $sub_section = $this->actions_map[$section]["sub_section"] ?? null;
            $section = $section_tmp;
        }
        
        switch ($settings){
            case "ui":
                $settings_col = "ui_settings";
                break;
            case "visual":
                $settings_col = "visual_settings";
                break;
            default:
                $settings_col = "settings";
                break;
        }
     
        
        $results = null;
        //A - return ALL json settings - if empty key
        if(empty($section)){
            $query ="SELECT $settings_col AS settings FROM user_settings WHERE username ='". $this->username ."' AND $settings_col IS NOT NULL";
        }
        //if key is set
        else{
            switch (strtolower($section)) {
                //B - special case - allConceptsArr - get all Data from table
                case 'allconceptsarr':
                    return $this->getAllConceptsArr();
                case 'flavors':
                    return $this->getFlavors($_REQUEST["concepts"] ?? null);
                case 'groups':
                    return $this->getGroups();
                default:
                  
                    $query = empty($sub_section) ? "SELECT $settings_col->\"$.".$section."\"  AS settings from user_settings WHERE username ='". $this->username ."' AND $settings_col IS NOT NULL" :
                    "SELECT $settings_col->\"$.".$section.".".$sub_section."\"  AS settings from user_settings WHERE username ='". $this->username ."' AND $settings_col IS NOT NULL";
            }
        }
        
        $res = sqlQuery($this->mysqli, $query);
        $row = $res->fetch_object();
        
        $results = json_decode($row->settings);
        if(is_string($results)){
            $results = trim($results,'"');
        }
        return $results;
    }
    
    /**
     * fetch allConceptsArr From Databaes
     * @param unknown $mysqli
     * @return array
     */
    public function getAllConceptsArr($flat = false){
        $allconceptsArrDB = [];
        $sql = "SELECT * from allconceptsarr";
        $res = sqlQuery($this->mysqli, $sql);
        if ($res && $res->num_rows){
            while($obj = $res->fetch_object()){
                $flavor = $obj->flavor;
                $data = json_decode($obj->data,true);
                if($flat){
                    foreach($data as $concept=>$caption){
                        if(!in_array(strtolower($concept), $allconceptsArrDB)){
                            $allconceptsArrDB[] = strtolower(str_replace('-', '_', $concept));
                            
                        }
                    }
                }
                else{
                    $allconceptsArrDB[$flavor] = $data;
                }
            }
        }
        return $allconceptsArrDB;
    }

    /**
     * concepts - for the allConcept Editor (adds the concepts to the flavor)
     * @param unknown $concepts
     * @return string[]|boolean[]|unknown[]|mixed[]|array[]|NULL[]
     */    
    public function getFlavors($attachConcepts = false){
        $value = $attachConcepts ? " * " : " flavor";
        $query ="SELECT $value  from allconceptsarr";
        $res = sqlQuery($this->mysqli, $query);
        $id = 0;
        if(empty($res)){
            return array("error" => "issue fetching getAllConceptsArr ");
        }
        while($row = $res->fetch_object()){
            $element = ["id"=> $id++, "name" => $row->flavor];
            
            if($attachConcepts){
                $tmp_group = ["concepts"=>[], "name"=>$row->flavor, "selected"=>true];
                $concepts_arr = json_decode($row->data, true);
                foreach($concepts_arr as $concept_key=>$concept_val){
                    $tmp_group["concepts"][] = ["name"=>$concept_key, "value"=>$concept_val, "selected"=>true];
                }
                $element["conceptsGroups"][] = $tmp_group;            
            }
            
            $results[] = $element;
        }
        
        return $results;
    }
    
    /**
     * get the groups from the group table
     * @return string[]|unknown
     */
    function getGroups(){
            $query ="SELECT *  from groups_table";
            $res = sqlQuery($this->mysqli, $query);
            if(empty($res)){
                return array("error" => "issue fetching groups ");
            }
            while($row = $res->fetch_object()){
                $results[] = array("name" => $row->name, "permissions" => json_decode($row->permissions,true));
//                 $results[] = json_decode($row->permissions, true);
            }
            
            return $results;
        
    }
    
    /**
     * setSettings main function
     * @param unknown $key
     * @return string[]
     */
    public function setSettings($settings, $section, $sub_section = null) {
        //assign section subsection if needed
        if(array_key_exists($sub_section, $this->actions_map)){
            $section = $this->actions_map[$sub_section]["section"];
            $sub_section = $this->actions_map[$sub_section]["sub_section"] ?? null;
        }

        switch ($settings){
            case "ui":
                $settings_col = "ui_settings";
                break;
            case "visual":
                $settings_col = "visual_settings";
                break;
            default:
                $settings_col = "settings";
                break;
        }
        
        $requestPayload =file_get_contents('php://input');
//         $requestPayload = "[{\"field\":\"docId\",\"header\":\"ID No.\",\"checked\":false},{\"field\":\"filename\",\"header\":\"File Name\",\"checked\":false},{\"field\":\"date_field\",\"header\":\"Date\",\"checked\":false},{\"field\":\"languages\",\"header\":\"Languages\",\"checked\":false},{\"field\":\"document_topic\",\"header\":\"Topic\",\"checked\":false},{\"field\":\"counted_theatre\",\"header\":\"Theatre\",\"checked\":false},{\"field\":\"subject_field\",\"header\":\"Subject\",\"checked\":false},{\"field\":\"from_field\",\"header\":\"Email Sender\",\"checked\":false},{\"field\":\"to_field\",\"header\":\"Email Recipient\",\"checked\":false},{\"field\":\"user_notes\",\"header\":\"Comments\",\"checked\":false},{\"field\":\"redacted\",\"header\":\"Redacted\",\"checked\":false},{\"field\":\"reviewed\",\"header\":\"Reviewed\",\"checked\":false},{\"field\":\"anti\",\"header\":\"Negative Sentiment\",\"checked\":false},{\"field\":\"pro\",\"header\":\"Positive Sentiment\",\"checked\":false},{\"field\":\"emotion\",\"header\":\"emotion\",\"checked\":false},{\"field\":\"threat_rating\",\"header\":\"Threat Rating\",\"checked\":false},{\"field\":\"file_type\",\"header\":\"Document Type\",\"checked\":false},{\"field\":\"filetags\",\"header\":\"Tags\",\"checked\":true},{\"field\":\"ideological_stream\",\"header\":\"Ideological Stream\",\"checked\":false},{\"field\":\"islamic_sect\",\"header\":\"Islamic Sector\",\"checked\":false},{\"field\":\"batch\",\"header\":\"Batch\",\"checked\":false},{\"field\":\"file_creation_date\",\"header\":\"File Creation Date\",\"checked\":true},{\"field\":\"file_last_accessed_date\",\"header\":\"Last Accessed\",\"checked\":false},{\"field\":\"file_last_modified_date\",\"header\":\"Last Modified\",\"checked\":false},{\"field\":\"scan_time\",\"header\":\"Scan Time\",\"checked\":false},{\"field\":\"file_size\",\"header\":\"File Size\",\"checked\":false},{\"field\":\"line_count\",\"header\":\"# Lines\",\"checked\":false},{\"field\":\"token_count\",\"header\":\"# Words\",\"checked\":false},{\"field\":\"score\",\"header\":\"Relevance\",\"checked\":false},{\"field\":\"username\",\"header\":\"User\",\"checked\":false}]";
//             $requestPayload = "{\"font\":[{\"name\":\"Ariel\",\"checked\":false},{\"name\":\"Times New Roman\",\"checked\":false},{\"name\":\"Gotham\",\"checked\":true}],\"theme\":[{\"name\":\"light\",\"checked\":false},{\"name\":\"dark\",\"checked\":true}],\"font_size\":[{\"name\":\"small\",\"checked\":false},{\"name\":\"medium\",\"checked\":false},{\"name\":\"large\",\"checked\":true}],\"date_format\":[{\"code\":\"UK\",\"name\":\"United Kingdom\",\"checked\":false},{\"code\":\"EU\",\"name\":\"European\",\"checked\":false},{\"code\":\"US\",\"name\":\"United States\",\"checked\":true}],\"dashboard_languages\":[{\"code\":\"latin\",\"name\":\"Latin Based (including English, French, Spanish, Indonesian, Czech, Romanian, Dutch, German)\",\"checked\":false},{\"code\":\"arabic\",\"name\":\"Arabic (including Farsi, Urdu)\",\"checked\":false},{\"code\":\"russian\",\"name\":\"Russian (all Cyrillic based languages)\",\"checked\":true},{\"code\":\"hindi\",\"name\":\"Hindi (all Devanagari based script)\",\"checked\":false}]}";
        switch (strtolower($section)) {
            //A - special case - allConceptsArr
            case 'allconceptsarr':
                return $this->updateAllConceptsArr($requestPayload);
            //B - special case - groups  
            case 'groups':
                $groups = json_decode($requestPayload, true);
                return $this->update_groups($groups);
             
            case null:
                $data = $this->mysqli->real_escape_string($requestPayload);
                $sql =  "UPDATE user_settings SET $settings_col =\"$data\"";
                break;
            //D - default with key - get field out of Settings 
            default:
                $arr = json_decode($requestPayload, true);
               
                $arr_str = $this->array_to_json_string($arr);
                
                if(is_array($arr[0])){
                    $sql = empty($sub_section) ? "UPDATE user_settings SET $settings_col = JSON_SET($settings_col, '$.".$section."', JSON_ARRAY($arr_str)) WHERE username=\"$this->username\""
                    :
                    "UPDATE user_settings SET $settings_col = JSON_SET(settings, \"$.".$section.".".$sub_section."\", JSON_ARRAY($arr_str)) WHERE username=\"$this->username\"";
                    
                }
                else{
                    $sql = empty($sub_section) ? "UPDATE user_settings SET $settings_col = JSON_SET($settings_col, '$.".$section."', JSON_OBJECT($arr_str)) WHERE username=\"$this->username\""
                    :
                    "UPDATE user_settings SET $settings_col = JSON_SET($settings_col, \"$.".$section.".".$sub_section."\", JSON_OBJECT($arr_str)) WHERE username=\"$this->username\""; 
                }
                
                
        }        
        
        $res = sqlQuery($this->mysqli, $sql);     
        if(empty($res)){
            return array('Error'=>'settings was not updated!');
        }
        return array('success'=>'settings successfully updated!');
    }
    
    public function array_to_json_string($arr){
        $res = "";
        foreach($arr as $key=>$val){
            if(is_array($val)){
                $val_json = json_encode($val, true);
                
                $str = "JSON_OBJECT(";
                foreach($val as $k=>$v){
                    if(is_bool($v)){
                        $v = $v ? 'true' : 'false';
                        $str .= "'$k', $v,";
                        
                    }
                    else{
                        $v = is_array($v) ? "JSON_OBJECT(".json_encode($v, true).")" : $v;
                        $str .= "'$k', '$v',";
                        
                    }                   
                }
                $str = rtrim($str, ',');
                $str .= ")";
                $val = $str;
            }
            else{
                $val = "'$key', '$val'";
            }
            $res .= "$val,";
        }
        return rtrim($res, ',');
    }
    
    function to_JSON_OBJECT($a)
    {
        $json = json_encode($a, JSON_PRETTY_PRINT);
        
        // split into lines
        $lines = explode("\n", $json);
        foreach ($lines as $key => $line) {
            // remove space
            $line = ltrim($line);
            
            // add a space to all lines that end with a comma
            $length = strlen($line);
            if ($line[$length - 1] === ',') {
                $line = $line . ' ';
            }
            
            // update line
            $lines[$key] = $line;
        }
        
        // build back to string
        return implode('', $lines);
    }
    
    public function update_groups($groups){
        foreach($groups as $group){
            $exists = false;
            $name = $group["name"];
            $permissions = json_encode($group["permissions"],true);
            //check if exists
            $sql_exists = "SELECT name FROM groups_table WHERE name=\"$name\" LIMIT 1";
            $res = sqlQuery($this->mysqli, $sql_exists);
            if(!empty($res->fetch_object())){
                $exists = true;
            }
            
            $sql = $exists ? "UPDATE groups_table SET permissions='$permissions' WHERE name= \"$name\"" : 
                                "INSERT INTO groups_table (name,permissions) VALUES('$name','$permissions')"; 
            $res = sqlQuery($this->mysqli, $sql);
            
            
        }
        return array("success"=> "updated groups permissions");
    }
    
    
    public function array_flatten($array) {
        
        $return = array();
        foreach ($array as $key => $value) {
            if (is_array($value)){ 
                $return = array_merge($return, $this->array_flatten($value));
            }
            else {
                $return[$key] = $value;
            }
        }
        return $return;
        
    }
    /**
     * updates the allConceptsarr table with the new data from the UI
     * @param unknown $data
     * @return string[]
     */
    public function updateAllConceptsArr($data){
        $data_arr = json_decode($data, true);
        foreach($data_arr as $flavor=>$json){
            $json_str = json_encode($json, true);
            $json_str = $this->mysqli->real_escape_string($json_str);
            
            $query = "INSERT INTO allconceptsarr (flavor,data) VALUES (\"$flavor\",\"$json_str\")
                ON DUPLICATE KEY UPDATE   data=\"$json_str\"";
            $res = sqlQuery($this->mysqli, $query);
           
            
        }     
        if(empty($res)){
            return  array('error'=>'all concepts arr didnt updated successfully');
        }
        return array('success'=>'all concepts arr  successfully updated!');
    }
    
    
    public function getActiveFlavor(){
        $sql = "SELECT flavor FROM user_settings WHERE username=\"$this->username\"";
        $res = sqlQuery($this->mysqli, $sql);
        
        if(empty($res)){
            return  array('error'=>'fetching user flavor error');
        }
        $row = $res->fetch_object();
        return $row->flavor;
    }
    
    public function setActiveFlavor(){
        $requestPayload =file_get_contents('php://input');
        $data = json_decode($requestPayload, true);
        $flavor_set = $data["name"];

        $sql = "UPDATE user_settings SET flavor = \"$flavor_set\" WHERE username=\"$this->username\"";
        $res = sqlQuery($this->mysqli, $sql);
        
        if(empty($res)){
                return  array('error'=>'Couldnt update flavor');
            }
        return array('success'=>'Flavor successfully updated!');

        
    }
    
    public function getSystemSettings(){
        $results = [];
        $sql = "SELECT * FROM system_settings";
        $res = sqlQuery($this->mysqli, $sql);
        while($row = $res->fetch_object()){
            $results[] = $row;
        }

        return $results;
    }
    
    public function getCrawlerSettingsAndStatus(){
        $crawler_settings = $filter_settings = $status = [];
        $sql = "SELECT * FROM crawler_settings";
        $res = sqlQuery($this->mysqli, $sql);
        while($row = $res->fetch_object()){
            if(property_exists($row, "isRunning")){
                $row->isRunning = intval($row->isRunning);
            }
            $crawler_settings = $row;
        }
        
        $sql = "SELECT * FROM filter_settings";
        $res = sqlQuery($this->mysqli, $sql);
        while($row = $res->fetch_object()){
            if(property_exists($row, "isRunning")){
                $row->isRunning = intval($row->isRunning);
            }
            $filter_settings = $row;
        }
        
        $streamConn = NULL;       
        createStreamConnection($streamConn);
        $sql = "SELECT MAX(id) AS max FROM raw_stream_data";//"select count(raw_stream_data.id) as crawler_id,filter_file_id.filter_id as filter_id from filter_file_id,raw_stream_data";
        $res = sqlQuery($streamConn, $sql);
        $row = $res->fetch_object();
        $status["crawler_id"] = empty($row) ? 0 : $row->max;
        
        $sql = "SELECT (filter_id) AS filter_id FROM filter_file_id";//"select count(raw_stream_data.id) as crawler_id,filter_file_id.filter_id as filter_id from filter_file_id,raw_stream_data";
        $res = sqlQuery($streamConn, $sql);    
        $row = $res->fetch_object();
        $status["filter_id"] = empty($row) ? 0 : $row->filter_id;  
        return ["settings"=>[$crawler_settings, $filter_settings], "status"=>$status];
    }
    
    public function setCrawlerSettings($data){   
        //update values to DB
        foreach($data as $element){
            if($element["prop"] == 'crawler'){
                if($element['locations'] == 'NaN,NaN,NaN,NaN' || $element['locations'] == "0,0,0,0"){
                    $element['locations'] = null;
                }
                $sql = "UPDATE crawler_settings SET track= '$element[track]', locations='$element[locations]',follow='$element[follow]', languages='$element[languages]'";
            }
            else{
                $min_rules = !empty($element['min_rules']) ? $element['min_rules'] : 0;
                $sql = "UPDATE filter_settings SET min_rules=$min_rules , country_code='$element[country_code]',
                languages='$element[languages]'";           
            }
            $res = sqlQuery($this->mysqli, $sql);
        }
        return ["success"=>"Update settings"];
    }
    
    function isJson($string) {
        json_decode($string);
        return json_last_error() === JSON_ERROR_NONE;
    }
    
    function validateJSON(string $json): bool {
        try {
            $test = json_decode($json, null, JSON_THROW_ON_ERROR);
            return true;
        } catch  (Exception $e) {
            return false;
        }
    }
    
    public function setSystemSettings($data){
        //first we gonna validate the ips - before update any value in the DB
        foreach($data as $element){
            if($element['type']=='ip'){
                if (!filter_var($element['value'], FILTER_VALIDATE_IP)) {
                    return ["error"=>"invalid ip value for $element[label]"];
                }
            }
        }
        
        //update values to DB
        foreach($data as $element){ 
            $sql = "UPDATE system_settings SET value='".$element["value"]."' WHERE prop=\"".$element["prop"]."\"";
            $res = sqlQuery($this->mysqli, $sql);
        }
        return ["success"=>"Update settings"];
    }
    
    public function getAlertSettings(){
        $results = [];
        $sql = "SELECT * FROM alerts_settings";
        $res = sqlQuery($this->mysqli, $sql);
        while($row = $res->fetch_object()){
            
            $results[] = $row;
        }
        
        return $results;
    }
    

    public function setAlertSettings($data){    
        //update values to DB
        foreach($data as $element){
            if($element['prop'] == 'searchKeywords'){
                $element['value'] = trim($element['value'], "'");
            }
            $element['value'] = empty(trim($element['value'])) ? " '' " : "'$element[value]'";
            $sql = "UPDATE alerts_settings SET value=$element[value] WHERE prop=\"".$element["prop"]."\"";
            $res = sqlQuery($this->mysqli, $sql);
        }
        return ["success"=>"Update alert settings"];
    }
    
    public function getFileReportSettings(){
        $results = [];
        $sql = "SELECT * FROM file_report_settings";
        $res = sqlQuery($this->mysqli, $sql);
        while($obj = $res->fetch_object()){
            if(!array_key_exists($obj->category, $results)){
                $results[$obj->category] = ['present'=>empty($obj->present) ? 0 : 1, 'values'=>[]];
            }
            $results[$obj->category]['values'][] = ['label'=>$obj->domain, 'present'=>empty($obj->present) ? 0 : 1];
            
        }
       return $results;
    }
    
    public function getReportSettings(){
        $results = [];
        $sql = "SELECT savedSearch,concepts,metadata,days FROM report_settings WHERE username='$this->username'";
        $res = sqlQuery($this->mysqli, $sql); 
        $obj = $res->fetch_object();
        if(!empty($obj)){
            $savedSearches = explode(",", $obj->savedSearch);
            $savedSearches_arr = [];
            if(!empty($savedSearches)){
                foreach($savedSearches as $ssid){
                    $savedSearch = getSavedSearchFromId($this->mysqli, $ssid);
                    if(empty($savedSearch)){
                        continue;
                    }
                    $savedSearches_arr[] = ["savedSearch"=>$savedSearch, "id" => $ssid];
                }
            }
            $results["savedSearches"] = $savedSearches_arr;
            
            $concepts = explode(",", $obj->concepts);
            $concepts_arr = [];
            if(!empty($concepts)){
                foreach($concepts as $concept_id){
                    $concept = getConceptFromId($this->mysqli, $concept_id);
                    if(empty($concept)){
                        continue;
                    }
                    $concepts_arr[] = ["concept"=>$concept, "id" => $concept_id];
                }
            }
            $results["concepts"] = $concepts_arr;
            
            $metadata = explode(",", $obj->metadata);
            $metadata_arr = [];
            if(!empty($metadata)){              
                foreach($metadata as $md){
                    if(empty($md)){
                        continue;
                    }
                    $metadata_arr[] = ["label"=>$md];
                }
            }
            $results["metadata"] = $metadata_arr;
            
            $results["days"] = $obj->days;
        }
       return $results;
    }
    
    public function setFileReportsettings($data){
        foreach($data as $category=>$vals){
            $present = empty($vals['present']) ? 0 : 1;
            $sql = "UPDATE file_report_settings SET present=$present WHERE category =\"$category\"";
            $res = sqlQuery($this->mysqli, $sql);
        }
        return true;
        
    }
    
    public function setReportSettings($data){
        //update values to DB
        
        $savedSearches = implode(",", $data['savedSearches'] ?? []);
        $concepts = implode(",", $data['concepts'] ?? []);
        $metadata = implode(",", $data['metadata'] ?? []);
        $days = $data['days'] ?? -1;
        
        $sql = "SELECT username FROM report_settings WHERE username=\"$this->username\"";
        $res = sqlQuery($this->mysqli, $sql);
        $obj = $res->fetch_object();
    
        $sql = !empty($obj) ? 
        "UPDATE report_settings SET concepts = \"$concepts\", metadata = \"$metadata\", 
                    savedSearch=\"$savedSearches\", days=$days
                 WHERE username=\"$this->username\"" :
         "INSERT INTO report_settings (savedSearch, concepts, metadata, days, username) 
         VALUES(\"$savedSearches\", \"$concepts\", \"$metadata\", $days, \"$this->username\")";
        $res = sqlQuery($this->mysqli, $sql);
        
        return ["success"=>"Update report_settings settings"];
    }
    
    public function setSettingsConceptInstaces($data){
        
        if(!empty($data)){
            //first get current value
            $sql = "SELECT value FROM alerts_settings  WHERE prop='concepts_instances'";
            
            $res = sqlQuery($this->mysqli, $sql);
            $obj = $res->fetch_object();
            $curr_json = $obj->value;
            $curr_arr = (json_decode($curr_json, true));
            
            //update values to DB
            $concept = $data["concept"];
            $instances = $data["instances"];
            
            if(!array_key_exists($concept, $curr_arr)){
                $curr_arr[$concept] = $instances;
            }
            else{
                foreach($instances as $instance){
                    $key =  array_search($instance['label'], array_column($curr_arr[$concept], 'label'));
                    if(empty($key) && $key !== 0 ){
                        $curr_arr[$concept][] = $instance;
                    }
                }
            }
            
            $data_json = (json_encode($curr_arr, true)); 
            $data_json = $this->mysqli->real_escape_string($data_json);
            $data_json = "'$data_json'";
        }
        else{
            //clear
            $data_json = "NULL";
        }
        
        $sql = "UPDATE alerts_settings SET value= $data_json WHERE prop='concepts_instances'";
        $res = sqlQuery($this->mysqli, $sql);
        
        return ["success"=>"Update alert settings"];
    }
}

