function generateMetadataUri (docId, dataRequested, maxChildDirs, dirDivider, metadataPath, zipName, zipDivider, zipExtension){
  if (!Number.isInteger(docId) || docId <= 0){
	return "";
  }
  var pathsObj = {
	digestJson: "d",
	menuColorStyle: "m",
	newText: "n",
	report: "r",
	textDir: "t",
	slotsData: "s",
	emotions: "e"
  };
  if (typeof dataRequested !== "string" || typeof pathsObj[dataRequested] !== "string"){
	return "";
  }
  if (typeof maxChildDirs !== "number"){
	maxChildDirs = 10000;
  }
  if (typeof dirDivider !== "string"){
	dirDivider = "/";
  }
  if (typeof metadataPath !== "string"){
	metadataPath = "metadata";
  }
  if (typeof zipName !== "string"){
	zipName = "Background";
  }
  if (typeof zipDivider !== "string"){
	zipDivider = "_";
  }
  if (typeof zipExtension !== "string"){
	zipExtension = "html.gz";
  }
  // parent directory is the numbers in the 10,000 column (and up)
  // (i.e. it is 0 for numbers below 10,000):
  // take the integer remainder after division by 10,000
  var parentDir = Math.floor(docId / maxChildDirs);
  // child directory is the 'modulo' - numbers in the first 4 columns 
  // (i.e. it is between 1 and 9999):
  // take the integer remainder after division by 10,000
  var childDir = docId % maxChildDirs;
  // e.g. (for 12345) "meta-data/12312312/3123" as follows:     
  //                   meta-data          /         1            /         2345              
  var dirPath = metadataPath + dirDivider + parentDir + dirDivider + childDir;
  // e.g. (for digestJson of file 12345) "Background_d_2345.gzip" as follows:     
  //             Background     _               d                     _         2345    .        gzip 
  var filePath = zipName + zipDivider + pathsObj[dataRequested] + zipDivider + docId + "." + zipExtension;
  // e.g.      meta-data/1/2345     /     Background_d_2345.gzip
  var fullPath = dirPath + dirDivider + filePath;
  return fullPath;
}