<?php

error_reporting(E_ERROR | E_PARSE | E_CORE_ERROR | E_COMPILE_ERROR);
require_once("userCake/models/settings.php");

define('UTF8_BOM', chr(0xEF) . chr(0xBB) . chr(0xBF));
define('IS_CLI', PHP_SAPI === 'cli');

$useIntuscanServer = true;

ini_set('memory_limit', '-1');
set_time_limit(20000);


$folderSeparator = DIRECTORY_SEPARATOR;
if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
	$COPY_COMMAND = "copy";
else
	$COPY_COMMAND = "cp";

//log level
const IVLOG_PERFORMACE = 0;
const IVLOG_TRACE = 1;
const IVLOG_INFO = 2;
const IVLOG_WARN = 3;
const IVLOG_ERROR = 4;
$logLevel = IVLOG_INFO;
$keepLogFileDays=7;

$defaultDashboradNames = array(
    "Organisations" => array("table" => "organizational_identity", "searchField" => "searchOrganization", "slices" => 20, "sort_by" => 0, "display_type" => 0),
    "Events" => array("table" => "event", "searchField" => "searchEvents", "slices" => 20, "sort_by" => 0, "display_type" => 0),
    "Places" => array("table" => "place_object", "searchField" => "searchPlaces", "slices" => 20, "sort_by" => 0, "display_type" => 0),
    "Persons" => array("table" => "person_object", "searchField" => "searchPerson", "slices" => 20, "sort_by" => 0, "display_type" => 0),
    "Languages" => array("table" => "languages", "searchField" => "languages", "slices" => 20, "sort_by" => 0, "display_type" => 0),
    "Topics" => array("table" => "document_topic", "searchField" => "document_topic", "slices" => 20, "sort_by" => 0, "display_type" => 0),
    "Abstract idea" => array("table" =>"abstract_idea_entity", "searchField" => "abstract_idea_entity", "slices" =>20, "sort_by" => 0, "display_type" => 0),
    "Non Animated Object" => array("table" =>"non_animated_object", "searchField" => "non_animated_object", "slices" =>20, "sort_by" => 0, "display_type" => 0),
    "System Status" => array(),
    "key_stats" => array()
);

$details_panels = array(
    'Persons' =>  array("visibility" => 1, "collapsed" => 0, "panelSize" => 2, "panelHeight" => 1,  "entity" => "person_object", "chartType" => 'wordList', 'selectedSortBy' => 'amount', "maxItems" => 20, "legend" => 0, "sort" => 1),
    'Organisations' =>  array("visibility" => 1, "collapsed" => 0, "panelSize" => 2, "panelHeight" => 1,  "entity" => "organizational_identity", "chartType" => 'wordList', 'selectedSortBy' => 'amount', "maxItems" => 20, "legend" => 0, "sort" => 1),
    'Events' =>  array("visibility" => 1, "collapsed" => 0, "panelSize" => 2, "panelHeight" => 1,  "entity" => "event", "chartType" => 'wordList', 'selectedSortBy' => 'amount', "maxItems" => 20, "legend" => 0, "sort" => 1),
    'Topics' =>  array("visibility" => 1, "collapsed" => 0, "panelSize" => 2, "panelHeight" => 1,  "entity" => "document_topic", "chartType" => 'wordList', 'selectedSortBy' => 'amount', "maxItems" => 20, "legend" => 1, "sort" => 1),
    'Abstract idea' =>  array("visibility" => 1, "collapsed" => 0, "panelSize" => 2, "panelHeight" => 1,  "entity" => "abstract_idea_entity", "chartType" => 'wordList', 'selectedSortBy' => 'amount', "maxItems" => 20, "legend" => 1, "sort" => 1),
    'Languages' =>  array("visibility" => 1, "collapsed" => 0, "panelSize" => 2, "panelHeight" => 1,  "entity" => "Languages", "chartType" => 'wordList', 'selectedSortBy' => 'amount', "maxItems" => 40, "legend" => 1, "sort" => 1),
    'Places' =>  array("visibility" => 1, "collapsed" => 0, "panelSize" => 2, "panelHeight" => 1,  "entity" => "place_object", "chartType" => 'map', 'selectedSortBy' => 'amount', "maxItems" => 20, "legend" => 1, "sort" => 2   ),
    'Non Animated Object' =>  array("visibility" => 0, "collapsed" => 0, "panelSize" => 2, "panelHeight" => 1,  "entity" => "non_animated_object", "chartType" => 'wordList', 'selectedSortBy' => 'amount', "maxItems" => 20, "legend" => 1, "sort" => 2   ),
    
);

//emotion graph
// 0 - basic
// 1 - token
// 2 - concept
$emotion_model = 1;


//variable that set up the metadata set into the DB and not to filesystem - false for V1 sites, true (on config.php) for AAA for v2 ui
$metadataDB = false;

//System Status set default to true
$addSystemStatus=true;

// Use the override language of tweeter
$isLangOverride = true;

//assosciative array for mapping languages
$lang_map =["AR"=>"Arabic",
    "FR"=>"French",
    "ES"=>"Spanish",
    "EN"=>"English",
    "HE"=>"Hebrew",
    "RU"=>"Russian",
    "UR"=>"Urdu",
    "FA"=>"Farsi",
    "ID"=>"Indonesian",
    "IN"=>"Indonesian",
    "HI"=>"Hindi",
    "CS"=>"Czech",
    "CA"=>"Spanish",
    "NL"=> "Dutch",
    "PT" => "Portuguese",
    "UK"=> "Russian",
    "BE" => "Russian",
    "AF" => "Dutch",
    "NL" => "Dutch"
];


//restricted tables for concepts search 
$restrictedTables = array("person_object" => "person_object","place_object" => "place_object",
    "organizational_identity" => "organizational_identity");

//restricted instances from rdf (configure it in config.php)
$restrictedInstances = array("person_object" => [],"place_object" => [],
    "organizational_identity" => []);


//fixed columns for table
$fixed_tables_cols = ['docId','name','ontName','ontUrl','docKey','username','occurrences','orgText','type'];
//$fixed_tables_cols = ['docId','name','ontName','ontUrl','docKey','anti','pro','username','occurrences','positive','negative','orgText','type'];

if (empty($CURRENT_SOURCE_FOLDER))
$CURRENT_SOURCE_FOLDER = dirname($_SERVER["SCRIPT_FILENAME"]); //avoid using __FILE__ as it resolves symbolic links which we might not want to resolve
if (empty($CURRENT_SOURCE_FOLDER) || $CURRENT_SOURCE_FOLDER == "." ||
		strcasecmp(realpath($CURRENT_SOURCE_FOLDER), __DIR__) != 0)
{
	//if no source folder (e.g. running relative script via CLI) - try windows current directory (which might contain the original symbolic link)
	if (strcasecmp(realpath(getcwd()), __DIR__) == 0) //strangely enough __DIR__ returns C:\... while realpath returns c:\...
	{
		$CURRENT_SOURCE_FOLDER = getcwd();
		if ($CURRENT_SOURCE_FOLDER != __DIR__)
		$initializationErrors = "cwd: $CURRENT_SOURCE_FOLDER, diir: " . __DIR__;
	}
	else
	{
		$initializationErrors = "Possible symbolic link issue, path might not be resolve correctly: CURRENT_SOURCE_FOLDER is set to _ _ DIR _ _ (" . __DIR__ . " as getcwd returned: " . getcwd() . ", while SCRIPT_FILENAME is: " . $_SERVER["SCRIPT_FILENAME"];
		$CURRENT_SOURCE_FOLDER = __DIR__;
	}
}


//extra fileds
//$extraFieldsPath = NULL;
//extra columns (table name => display name)
$extraColumns = array();

//number of unique users
$numberOfUsersTablesName = "file_author";

//restricted domain-topic
$restrictedTopicArr = array("Cyber" => "Cyber","Hacking" => "Hacking");

// Optional additional entity types for use in the entity manager.
// Each extra type forms one of the elements in the following array,
// where the key of each element will be displayed in the UI
// and the value must correspond to the respective table name in the database.
$extraEntityTypesArray =  array(
//	"terrorism_topic" => "Terrorism Topic", // i.e. [the table name] => [the displayed name]
	//"funny_topic" => "Funny Topic" // i.e. [the table name] => [the displayed name]
);

$intuScanBinPath = getenv("INTUVIEW_HOME") . "/IntuScan/bin";
$javaPath = "$intuScanBinPath/java/bin/server";
$tikaJarPath = "$intuScanBinPath/tika-app-1.8.jar";
$wkHtmlToPdfPath = "$intuScanBinPath/wkhtmltopdf.exe";

//libreOffice conf
$sofficePath['win'] = "C:/Program Files/LibreOffice 5/program";
$sofficePath['win_86'] = "C:/Program Files (x86)/LibreOffice 5/program";
$sofficePath['lin'] = "/usr/lib/libreoffice/program";

//image magick path (for converting PNG to TIF)
$imageMagickPath = "C:/Program Files/imageMagick-6.9.3-Q16";

//text database
$SOLR_SERVER_HOSTNAME  = ""; //will be set to default after including config
$SOLR_SERVER_USERNAME  = "";
$SOLR_SERVER_PASSWORD  = "";
$SOLR_SERVER_PORT      = "8983";
if (is_dir("G:/solr-5.4.1/bin")) {
	$SOLR_HOME = "G:/solr-5.4.1/bin";
} elseif (is_dir("D:/solr-5.4.1/bin")) {
	$SOLR_HOME = "D:/solr-5.4.1/bin";
} elseif (is_dir("C:/solr-5.4.1/bin")){
	$SOLR_HOME = "C:/solr-5.4.1/bin";
}
elseif (is_dir("/opt/solr")){
    $SOLR_HOME = "/opt/solr";
}

$SOLR_MAX_COMMIT_DELAY = 300000; //5 minutes
$SOLR_TXT_FIELD = "content_txt";
$useSolr = false;

//a map between a db name and its host/user/pwd/db/port - may be useful when $textDataBase should use a different server
//$connectionOverrides = array($textDataBase => array("host" => "", "user" => "", "pwd" => "", "db" => "", "port" => ""));
$connectionOverrides = array();
$separateTextQuery = false; //set to true if $textDataBase is found on a different server

$allInOneIp = "127.0.0.1";
$intuscanHost = "127.0.0.1";
$intuscanPort = 6000;

$rdfstoreHost = "127.0.0.1";
$rdfstorePort = 2020;
$isUseRdfStore = false;

$rdfstoreCmHost = "127.0.0.1";
$rdfstoreCmPort = 8080;

$isDemo = false;
$isLegal = false;
$oneSearchQuery = true;

$limitResult = 10000;
$pieResult = 500;

$skipDuplicate = false;
//require_once 'OSSpecific.php';
//$osName = OSSpecific::getOsName();

//to analayze folder with the doc server service change to true.
//$isFolderService = true;

//to generate file lists in temp folderset to true:
$shouldListFiles = false;
//should append hacking words to bottom of txt files (e.g. H4CK -> HACK)
$shouldAppendHackingWords = false;

//treat all files as emails (false by default)
$allFilesEmails = false;

//for not displaying top banner set in config.php: $topBannerDisplay = "none";
$topBannerDisplay = "";

$jwtKey = "nui9h&i90Y*()uyh";

//policy of search queries
const TEMP_VIEWS = 1;
const SUB_SELECTS = 2;
$searchPolicy = SUB_SELECTS;

//setting isMemSQL to true would generally entail:
//> setting connectionOverrides, separateTextQuery or useSolr and isFolderService
$isMemSQL = false;
$conceptTablesAsColumnstore = false;

$doStoreResultFile = false; //if false than delete the response from intuscan

$includeMetaInParseText = false; //parseTextAndMetadata.php will produce text documents without meta fields
if (!isset($logFNsuffix))
	$logFNsuffix = "";//getmypid();//Thread::getCurrentThreadId();
$hideConceptInstances = array();

$asyncwithCmd = true;
$shouldDumpDbg = false;
$shouldInsertPhrases = false; //for word count

//array of instances/fields we wish to hide from Doc_view and analytics list
//you can override in config.php and add a value for them, that way they wont be hidden
$hideFields = array(
    "user language" => "",
    "File Type file" => "",
    "Twitter country code" => "",
    "User Translator Type" => "",
    "Filter by location" => "",
    "Filter by country_code" => "",
    "user language" => "",
    "filter_passed_rule_location" => "",
    "filter_passed_rule_time_zone" => "",
    "Filter by country_code" => "",
    "filter_passed_rule_country_code" => "",
    "t_parent_id" => "",
    "topic" => "",
    "lang" => "",
    "user_lang" => "",
    "user_translator_type" => "",
    "place_country_code" => "",
    "user_id_str" => "",
    "domain" => "",
    "t_id" => "",
    "user_utc_offset"=>"",
    "user_geo_enabled"=>"",
    "retweeted_id"=>"",
    "user_created_at"=>""

);
$truncate_sql = 53;

$stress_test = 0; // for testing "heavy DB" in getPIE etc 

//for getKbInstanceSlots
$lang_override_arr =  ["english","french","spanish"];//,hebrew
// //default filters for the concept cloud
// $default_filters = array("abstract_idea_economic_entity",
//     "abstract_idea_entity",
//     "abstract_idea_political_conflict",
//     "abstract_idea_political_entity",
//     "abstract_idea_scientific_entity",
//     "abstract_idea_social_entity",
//     "abstract_idea_theological_entity",
//     "academic_institution",
//     "economic_object",
//     "economy_expression",
//     "education_expression",
//     "energy_object",
//     "energy_source",
//     "environment_expression",
//     "ethnicity",
//     "event",
//     "governance_expression",
//     "historic_group",
//     "place_object",
//     "international_relations_expression",
//     "law_enforcement_topic",
//     "medical_expression",
//     "named_entity_group",
//     "national_economy_expression",
//     "organizational_identity",
//     "person_object",
//     "social_media_applications",
//     "sport_event_type",
//     "violent_action"
// );
$subjectEntitiesBackground = ["abstract_idea_entity"]; //for getIntuviewInfo output

//customer overrides (by default this file shouldn't exist)
include_once "config.php";
//most config files will include: require_once 'clusterConfig.php';

//should be set by clusterConfig.php 
if (empty($projectLocalFolder))
	$projectLocalFolder = "$CURRENT_SOURCE_FOLDER/ivLocalProjects/$db_name";
	
$databaseHost = $db_host;
$databaseUser = $db_user;
$databasePass = $db_pass;
$databaseName = $db_name;
if (empty($textDataBase))
	$textDataBase = $databaseName . "_text";

if (empty($SOLR_SERVER_HOSTNAME))
	$SOLR_SERVER_HOSTNAME = "127.0.0.1";

// if (!isset($intuscanArray)) $intuscanArray = array("$intuscanHost:$intuscanPort");
if (empty($entityMatcher)) $entityMatcher = $intuscanHost;
if (empty($entityMatcherPort)) $entityMatcherPort = 6001;
if (empty($intuscanWordHost)) $intuscanWordHost = $intuscanHost;
if (empty($intuscanWordPort)) $intuscanWordPort = $intuscanPort;
if (empty($folderServiceHost)) $folderServiceHost = "127.0.0.1";
if (empty($folderServicePort)) $folderServicePort = "8300";

//tmp folders should reside in a project-specific folder (for reusing source folder by symbolic links of multiple projects, for example),
//but they cannot reside on the shared folder, for supporting cluster scenario - where a project's shared folder is common to multiple machines, which distribute the temp files processing and share the final results
if (empty($xml_results_path)) $xml_results_path = $projectLocalFolder . "/tmp_results";
if (empty($TEMP_FOLDER)) $TEMP_FOLDER = "$projectLocalFolder/tmp";

if (empty($sharedFolder)) $sharedFolder = $projectLocalFolder;

if (empty($UI_FOLDER)) $UI_FOLDER = "$sharedFolder/ui_components";

$info_log_file = "$TEMP_FOLDER/INFO_log$logFNsuffix.txt";
$warrning_log_file = "$TEMP_FOLDER/WARNING_log$logFNsuffix.txt";
$error_log_file = "$TEMP_FOLDER/ERROR_log$logFNsuffix.txt";
$trace_log_file = "$TEMP_FOLDER/TRACE_log$logFNsuffix.txt";
$perfomence_log_file = "$TEMP_FOLDER/PERMORMENCE_log$logFNsuffix.txt";
$audit_log_file = "$TEMP_FOLDER/AUDIT_log.txt";

if (empty($uploadedFilesPath)) $uploadedFilesPath = realpath($sharedFolder . "/uploaded_files");
if (empty($UPLOADS_PATH)) $UPLOADS_PATH = "$projectLocalFolder/uploads";
if (empty($metadata_path)) $metadata_path = $CURRENT_SOURCE_FOLDER."/metadata";
if (empty($redactedDocsPath)) $redactedDocsPath = $sharedFolder . "/redacted_docs";

//docserver arguments - default windows
$docserverPath = addslashes($uploadedFilesPath);
$docserverxmlpath = $xml_results_path;
$docserversourcefolder = $CURRENT_SOURCE_FOLDER;

if (empty($PHP_FOLDER))
{
	//try to calculate php.exe folder. Usually: C:\xampp\php\
	$PHP_FOLDER = dirname(PHP_BINARY) . $folderSeparator;
	//when running in browser PHP_BINARY directs to httpd.exe, while we try to calc the folder of php.exe
	if (!empty($_SERVER["PHPRC"]))
		$PHP_FOLDER = substr($PHP_FOLDER, 0, 2) . $_SERVER["PHPRC"] . $folderSeparator;
}

//SolR options
if(empty($SolRoptions))
	{
		if( empty($SOLR_COLLECTION) )
			$SOLR_COLLECTION = $db_name;
		$SolRoptions = array
					(
						'hostname' => $SOLR_SERVER_HOSTNAME,
						'port'     => $SOLR_SERVER_PORT,
						'path'     => "solr/" . $SOLR_COLLECTION
					);
	}



//Add domain and topic seperate 
// NOTICE - If you delete it you need to change background.php file
$extraColumns["topic"] = "Topics";
$extraColumns["domain"] = "Domains";
$extraColumns["phrases"] = "Phrases"; //for word count

$old_DB=false;
date_default_timezone_set('Asia/Jerusalem');

$ethnicities_json_location = "./files/ethnicities.json";

$predictive_search_type = 'idf';

$hide_saved_search = array('(analytics)', '(trends)','(Predictive Search)');

//For new UI - tag group of system tags (as - uploaded) that is used internal and not for user tagging
$system_tags = array("system");

//make sure they are updated as in intuscan 13/7/19
//make sure all are in lowercase
$supported_formats =
array("txt",
"doc",
"xls",
"xlsx",
"docx",
"rtf",
"html",
"htm",
"mht",
"pdf",
"ppt",
"pptx",
"tiff",
"tif",
"eml",
"emlx",
"aif.xml",
"json",
"unsupported format", //for indication of those files only in table
 "jpg","jpeg","png","gif","msg","bmp", //from pst many files
 "zip","p7m","emz","dwg","vcf","rar","ods","MOV","mp4","odt","7z","dat","csv","pptm","xlsb","wmz","m4a","3gp","ics" //extra from london.. find better way one day
    
);

//use this variable for the Last Search name (never with "Last search" explict)
$lastSearchNameDefault = "Last search";

//$allConceptsTable - the name of the table that contain allConceptsArr data (view derive from it)
$allConceptsTable = "all_concepts_table";



//exetnsion - for now it use only in shouldConvertToPDF
$ext2fam = array(
    "html" => "htm",
    "htm" => "htm",
    "json" => "json",
    "txt" => "txt",
    "jpg" => "jpg",
    "jpeg" => "jpeg",
    "JPG" => "jpg",
    "JPEG" => "jpeg",
    "docx" => "doc",
    "doc" => "doc",
    "pptx" => "ppt",
    "ppt" => "ppt",
    "xlsx" => "xls",
    "xls" => "xls",
    "csv" => "xls",
    "eml" => "txt",
    "split" => "txt",
    "original" => "txt",
    "mht" => "txt",
    "rtf"=> "rtf"
);

$whatsapps_ext = array("split","eml", "original"); //this is for the files we've created for whtatsapp

//tables to ignore on search search_Values (information_v2)
$ignore_tables = array("document_topic",
    "ignoreDuplicates");

//relations from intuscan - to skip on insert to DB
$excluded_relations = array('electronic-mail');

//keywords v2 - include those (not in allconcepts)
$include_get_tables = array("file_author");

//$restrict_entity_info_arr - tables not to show in entity information
$restrict_entity_info_arr = array("searchSentiment");

//export of files limit
$export_limit = 2000;

/**
 * GROUPS
 */
const CAN_MANAGE = 'canManage';
const CAN_ANALYZER_FOLDER = 'canAnalyzeFolder';
const CAN_SHOW_ALL_USER = 'canShowAllUser';
const CAN_DELETE = 'canDelete';
const CAN_SYNC = 'canSync';
const CAN_CONTRIBUTE = 'canContribute';
const CAN_EXPORT = 'canExport';
const CAN_IMPORT = 'canImport';
const CAN_VIEW = 'canView';
//for group results of trends
$group_trend_table = "group_trend";

//limit words (avoid gibrish)
//$limit_words_in_text = 15;

$include_meta_in_text = false;

$manual_update_panels = false;

$default_flavor = "legal";

$inc_calc = true;

$showIslamicKeyData = false;

$hugefiles = false;

$foldersStatusLimit = 500;

$excluded_concepts_sql = ["Mythical-place-object", "Non-contemporary-person", "Astronomic-place-object"];

$possible_identification_replacement = ["Collective-identity-group"];