<?php

/**
 * Description of concept
 * concept is also a table at db
 * @author hilit
 */
class Concept {

    private $concept;
    private $parentTables;
    private $subTables;
    private $mysqli;

    public function __construct($concept, $mysqli) {
        $this->concept = $concept;
        $this->parentTables = self::getParentConcepts($mysqli, $concept);
        $this->subTables = self::getSubConcepts($mysqli, $concept);
        $this->mysqli = $mysqli;
    }

    public function get_concept() {
        return $this->concept;
    }

    public function set_concept($name) {
        $this->concept = $name;
        return true;
    }

    public function get_ParentTables() {
        return $this->parentTables;
    }

    public function set_ParentTables($concept) {
        $this->parentTables = self::getParentConcepts($concept);
        return true;
    }

    public function get_SubTables() {
        return $this->subTables;
    }

    public function set_SubTables($concept) {
        $this->subTables = self::getSubConcepts($mysqli, $concept);
        return true;
    }

    /*
     * get all sub concepts of concept
     */

    public static function getSubConcepts($mysqli, $table) {

        $table = TablesInformation::getConceptPresentName($table);
        $query = "SELECT sub_concept_name from sub_tables where concept_name = '$table'";
        $res = sqlQuery($mysqli, $query);
        $sub_concept_name = [];

        while ($row = $res->fetch_object()) {
            $sub_concept_name[$row->sub_concept_name] = $row->sub_concept_name;
        }
        if ($sub_concept_name != null) {
            return $sub_concept_name;
        } else {
            write_to_log("TRACE", "concept: $table does not have any sub concepts");
            return [];
        }
    }

    /*
     * get all parent concepts of concept
     */

    public static function getParentConcepts($mysqli, $table) {
        $query = "SELECT parent_name from parent_tables where concept_name = '$table'";
        $res = sqlQuery($mysqli, $query);
        $parent_tables = [];
        if ($table != "anti_concept" && $table != "pro_concept" && $res->num_rows != 0) {
            $parent_tables["All"] = "All";
        }
        while ($row = $res->fetch_object()) {
            $parent_tables[$row->parent_name] = $row->parent_name;
        }
        if ($parent_tables != null) {
            return $parent_tables;
        } else {
            write_to_log("TRACE", "concept: $table does not have any parents");
            return [];
        }
    }

}
