<?php	
 	$logFNsuffix = "-backg";
	require_once("demosettings.php");	
	include_once 'write_log.php';
	require_once 'sqlUtils.php';
	require_once 'slotToCaption.php';
	require_once 'globalArr.php';
	require_once 'sparql.php';	
	require_once 'parseUtils.php';
	require_once 'annotations.php';
	require_once 'ngramEng.php';
	require_once 'tableTree.php';
	require_once 'concept.php';
	require_once 'allConceptsData.php';
	require_once 'allConceptArr.php';	
	require_once 'backgroundFunctions.php';
	require_once 'mainEng_funcs.php';
	require_once("userCake/models/config.php");
	
	//==========================================================================================================
	//====================================Beginning of background Run Code======================================
	//==========================================================================================================
	
        //async call to background
       // $async = false;
        if (empty($argv)) {
            $argvstr = filter_input(INPUT_GET, "argv");
            $argv = explode(",",$argvstr);
            $async=true;
        }
	$dcid = $argv[1];	
	
	//for now i place it as always true (since it was working so far)
	$_REQUEST["getmetadata"] = true;// $argv[2] ?? null;
	
// 	$port =(count($argv)>2 ? $argv[2]:null);//not used
    $groupTag =(count($argv)>3 ? $argv[3]:null);
    $tagging =(count($argv)>4 ? $argv[4]:null);
    
	write_to_log("INFO", "background started docId - $dcid");
        write_to_log("TRACE", "$dcid started with arguments - " . json_encode($argv));
	if ((!IS_CLI && !$async) || !$dcid || !is_numeric($dcid))
	{
		write_to_log("ERROR", "background iligeal dcid = $dcid ");
//       		$dcid = 1;
    		return;				
	}	
	write_to_log("TRACE", $dcid . " Background: start");
	$spanDom = new DOMDocument();
	$background_funcs = new BackgroundFunctions($dcid);	
	$mysqli = $background_funcs->getMysqli();
	
	$start_background_time = time();
	
	//====================================background - tagDocument=====================================
	//tags_arr - NEW UI only. if it's exists - multi tagging - else - regular old ui tagging
	$tags_arr = $background_funcs->getTagsArr();
	if(!empty($tags_arr)){
	    require_once 'tags.php';
	    $tag_class = new Tags($background_funcs->getMysqli(), $background_funcs->getUsername());
    	$tags_arr = json_decode($tags_arr,true);
    	foreach($tags_arr as $tag_element){
    	    $group_tag = $tag_element['name'];
    	    foreach($tag_element['children'] as $child_tag){
    	        if($child_tag['checked']){
    	            $tag_class->insertTag($dcid, $child_tag['name'], $group_tag);   	            
    	        }
    	    }  
        }
	}
	else{
	   tagDocument($background_funcs->getMysqli(), $dcid, $tagging, true, $groupTag, $background_funcs->getUsername());
	}
	//====================================background - tagDocument - DONE==============================
	
	//====================================background - getBlobData And More=====================================
	$blob = $background_funcs->getBlobData();
	$xml = new DOMDocument('1.0', 'utf-8');
	$loadRes = $xml->loadXml($blob,LIBXML_PARSEHUGE);
	if(!$loadRes){
	    write_to_log("ERROR", "Background loadRes return false where id=" . $dcid);
	    $blob = mb_convert_encoding($blob, 'UTF-8', 'UTF-8');
// 	    $blob = utf8_encode($blob);
		$loadRes = $xml->loadXml($blob,LIBXML_PARSEHUGE);
		if(!$loadRes){
			write_to_log("ERROR", "Tries to utf8_encode but still failed - I give up");
			return;
		}
	}
	$xpathXml = new DOMXpath($xml);
	
	if (!$xpathXml){
	    write_to_log("ERROR", "background unable to open XML where id=" . $dcid);
	    return;
	}
	$b64 = $xml->getElementsByTagName("Base64")->item(0)->textContent;
	$background_funcs->setText($b64);
	$textNoBOM = getTextNoBOM($background_funcs->getText());
	//====================================background - getBlobData And More- DONE==============================

	//insert phrases to DB
	ngramEng::setNgramsFromDoc($textNoBOM);
    $background_funcs->setTable2valuesPhrases(ngramEng::addPhraseToTableToValue($mysqli,$dcid));
	
     $tripples = $xml->getElementsByTagName("FileTriples")->item(0);
     
	//Insert rdf result to joseky
     $background_funcs->insertRdfResults($tripples);
     
     $span = $tripples->getElementsByTagName("DigestSpan")->item(0);
     $report = $xml->getElementsByTagName("FileReport")->item(0)->textContent;
     $report = str_replace("<center> IntuScan&trade; Analysis Report </center>", "", $report);
     $content = $span->firstChild->wholeText;
     $spanDom->loadXml($content);
     $xpathDom = new DOMXpath($spanDom);
     $background_funcs->setxPathDom($xpathDom);
     $docParams = array();
     $docParams["Languages"] = array();
     $elements = $xpathXml->query("/IVEnvelope/Notification/AnalyzeFile/OutputParameters/FileMetaParameters/structured/slot[@name=\"Languages\"]/list/instance");
     if (!is_null($elements)) {
         foreach ($elements as $delement) {
             $docParams["Languages"][] = $delement->getAttribute("name");
         }
     }
     
     //====================================background - checkDuplicatedRegex ======================================     
     if(!empty($omit_regex)){
         write_to_log("INFO", "checking duplicates with omitted regex");
         $isDuplicate = updateSHA1($background_funcs->getMysqli(), $dcid, null,  $background_funcs->getText(), $omit_regex);
         if ($isDuplicate != false){ 
             updateUniqueDocToDB($background_funcs->getMysqli(), $isDuplicate);
         }else{
             
             insertUniqueDocToDB($background_funcs->getMysqli(), $dcid, null, $background_funcs->getUsername());
             
         }
     }
     //====================================background - checkDuplicatedRegex DONE======================================
     
     //====================================background - handleExtraData ======================================
     $background_funcs->handleExtraData();
     //====================================background - handleExtraData DONE======================================
        
	//====================================background - meta Parameters ======================================
     $background_funcs->metaParamsHandler();
	//====================================background - meta Parameters DONE======================================
	
	//====================================background - update user_status ======================================	
     $background_funcs->updateUserStatus(); 	//update user_status table about file size
	//====================================background - update user_status DONE ======================================
		
	global $allConceptXml;
	if (empty($allConceptXml)){
		$domain = "All_Concept";
	}
	else{
	    $domain = $allConceptXml;
	}
	
	//====================================background - insertMetaParameters ======================================
	$background_funcs->handleDateField();
	$background_funcs->insertMetaParameters();
	//====================================background - insertMetaParameters DONE ======================================	

	$textDir = "ltr";
	if(count($docParams["Languages"])){
		$mainLang = substr($docParams["Languages"][0], stripos($docParams["Languages"][0], "-") + 1, strlen($docParams["Languages"][0]));
		if(strcmp($mainLang, "arabic") == 0 || strcmp($mainLang, "urdu") == 0 || strcmp($mainLang, "farsi") == 0 || strcmp($mainLang, "hebrew") == 0){
			$textDir = "rtl";
		}
	}

	if (!is_null($background_funcs->getMerged_data())) {
	    //====================================background - annotation======================================
	    //gets all the annotation elements
	    $annot_array = $background_funcs->getAnnotElements();
	    $annotElementsSubclasses = $annot_array['annotElementsSubclasses'];
	    $annotElementsSubclassesKey = $annot_array['annotElementsSubclassesKey'];
	    $annotElementsParentClasses = $annot_array['annotElementsParentClasses'];
	    //====================================background -  annotation ======================================
    	
    	
    	//====================================background - digestJson==================================
    	$digestJson = $background_funcs->createDigestJson();
    	//====================================background -  digestJson - END ==========================	
	}		
	else{
		write_to_log("WARNING", $dcid . " - annotation elements is null for domain " . $domain);
	}
	
	
	//====================================background - arrGeneral======================================
	$background_funcs->createArrGeneral();
	//====================================background -  arrGeneral - END ==============================
	
	//====================================background - digestJson2======================================
	$digestJson = $background_funcs->createDigestJson2();
	//====================================background -  digestJson2 - END ==============================
	
	
	//====================================background - createArrWord====================================
	$background_funcs->createArrWord();
	//====================================background -  createArrWord - END ============================
		
	//====================================background - patchHashtags====================================
	$background_funcs->patchHashtags();
	//====================================background - patchHashtags -END====================================
	
	//====================================background - fillSentiment======================================
	$background_funcs->fillSentiment();
	//====================================background -  fillSentiment - END ==============================
	
	//====================================background - table2Values======================================
 	$background_funcs->table2valuesMaker();
	//====================================background -  table2Values - END ==============================

	//====================================background - insertTable2Values======================================
	$background_funcs->insertTable2Values();
	//====================================background -  insertTable2Values - END ==============================
    
	//====================================background - SOLR ======================================
	//Adding a document to the solr index
	
	if($background_funcs->getUseSolr())
	{
	    $background_funcs->addDataToSolr($mysqli);
	    // 	    $background_funcs->addDocToSolr();
	}
	else {
	    $background_funcs->insert_to_text_db($textDataBase);
	}
	//====================================background - SOLR DONE======================================
	
    //====================================background - updateProAntiAgg======================================
    $background_funcs->updateProAntiAgg();
    //====================================background -  updateProAntiAgg - END ==============================

    
    //====================================background - updateProAntiAgg======================================
    $arr_rel = $background_funcs->relationHandler();
    $arr_obj_word = $arr_rel['arr_obj_word'];
    $arr_sub_word = $arr_rel['arr_sub_word'];
    $arr_rel_word = $arr_rel['arr_rel_word'];
    $obj_arr = $arr_rel["obj_arr"];
    $sub_arr = $arr_rel["sub_arr"];
    $rel_arr = $arr_rel["sub_arr"];
    
    
    //====================================background -  updateProAntiAgg - END ==============================

	//====================================background - insert Relations======================================
    $background_funcs->updateBackgroundRelations($rel_arr, $obj_arr, $sub_arr, $arr_obj_word, $arr_sub_word, $arr_rel_word);
	//====================================background - insert Relations - END ======================================
    
	//====================================background - addMenuColors======================================
    $background_funcs->addMenuColors();
	$menuColorStyle = "";
	//====================================background -  addMenuColors - END ======================================
    
	//====================================background - add occurrences======================================
	$background_funcs->addOccurrences($digestJson);
	//====================================background -  add occurrences - END ======================================
	
	//====================================background - sentConvertFunction &&  add emotion======================================
	$background_funcs->sentConvertFunction();
	$background_funcs->getPro_anti_array()->insert_to_DB($dcid);
	$background_funcs->addEmotions();
	//====================================background -  sentConvertFunction - END ==============================
	
	//====================================background - Insert SQL Array ======================================
	$background_funcs->getSql_array()->insert_to_DB($dcid);
	//====================================background - Insert SQL Array DONE======================================
	
	
	//====================================background - saveMetaDataToZip & DB======================================
	
	if($_REQUEST['getmetadata']){
	    $background_funcs->addSubjectEntities();
	    
	}
	$background_funcs->saveMetaDataToDB($textDir, $report, $menuColorStyle);
	
	//====================================background - saveMetaDataToZip DONE======================================
	
	
	//====================================background - update_inc ======================================
    $background_funcs->inc_calc();
	//====================================background - update_inc DONE======================================
	
	//====================================background - 	emails to slotdata =====================================
	$background_funcs->handleEmailsSql();
	//====================================background - emails to slotdata DONE======================================

	global $xml_results_path, $doStoreResultFile;
	//delete _res.xml
	if($doStoreResultFile){
	    $background_funcs->storeResultFile($xml_results_path . DIRECTORY_SEPARATOR ."$dcid" . "_res.xml");
	}
	else{
	    if(getSystemSettingsProp($background_funcs->getMysqli(), "saveRdf")){
	        $background_funcs->storeResultFile($xml_results_path . DIRECTORY_SEPARATOR ."$dcid" . "_res.xml", true);  
	    }
	    
		unlink($xml_results_path . DIRECTORY_SEPARATOR ."$dcid" . "_res.xml");
	}

	//====================================background -insertNameAlt======================================
	$background_funcs->insertNameAlt();
	//====================================background - insertNameAlt DONE================================
	
	//====================================background -insertEmails======================================
	$background_funcs->insertEmails();
	//====================================background - insertEmails DONE================================
	
	//====================================background -updateAndSendNotifications======================================
	$background_funcs->updateAndSendNotifications();
	//====================================background - updateAndSendNotifications DONE================================

	
	//====================================background - FINISHED======================================
//  	$sql = "UPDATE files SET results=\"\" WHERE id=$dcid";			
  	write_to_log("TRACE", $dcid . " Background: finished seconds: " . (time() - $start_background_time));
  	 
	
?>