<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
require_once 'asyncRequst.php';
require_once 'aSynchronousOsRequests.php';
require_once 'OSSpecific.php';

class asyncWithComandLine implements aSynchronousOsRequests {
    
    public static $os = null;
    
    function __construct() {
        self::$os = OSSpecific::getInstance();
    }
   
    function getStatisticAsync($in_process, $username) {
        global $CURRENT_SOURCE_FOLDER;
        if ($in_process == 0) {
            $cmd = OSSpecific::getInstance()->getCmdForStatisticReq($username);
            write_to_log("TRACE", "executing: $cmd");
            executeCommand($CURRENT_SOURCE_FOLDER, $cmd);
        }
    }

    public function calcPie($pieName, $username) {
        global $CURRENT_SOURCE_FOLDER;
        $isAdmin = getUserPermission(CAN_SHOW_ALL_USER) ? 1 : 0;
        $cmd = OSSpecific::getInstance()->getCmdForGetPieReq($username, $pieName, $isAdmin);
        write_to_log("TRACE", "executing: $cmd");
       OSSpecific::getInstance()->exec_run($CURRENT_SOURCE_FOLDER, $cmd, "r");

    }

    function calulatePieWrapper($connection, $trendName, $in_process, $username) {
        global $CURRENT_SOURCE_FOLDER;
        CacheEng::update_process($connection, $username, $trendName, ++$in_process);
        $str = "nada"; // no need for this if its is_dashboard_db
        $isAdmin = getUserPermission(CAN_SHOW_ALL_USER);
        $isAdmin = $isAdmin ? 1 : 0;
        $cmd = OSSpecific::getInstance()->getCmdForTrendReq($username, $trendName, $isAdmin);
        write_to_log("TRACE", "executing: $cmd");
        executeCommand($CURRENT_SOURCE_FOLDER, $cmd, "r");
    }

    function sendDocAsync($PHP_FOLDER, $i, $user, $serverIP, $port, $file_id, $isEmail) {
        global $CURRENT_SOURCE_FOLDER;
        $cmd = OSSpecific::getInstance()->getCmdForSendDocReq($i,$user,$serverIP,$port,$file_id,$isEmail);
        executeCommand($CURRENT_SOURCE_FOLDER,$cmd);
    }

    function backgroundAsync($arr, $getmetadata) {
        global $CURRENT_SOURCE_FOLDER;
        $backgroundProcs = array();
        $cmd = OSSpecific::getInstance()->getCmdForBackgroundReq($arr,$getmetadata);
//         $pipes = array();
//         $backgroundProcs[] = proc_open($cmd, array(
//             array("pipe", "r"),
//             array("pipe", "w"),
//             array("pipe", "w")
//                 ), $pipes);
        
        write_to_log("INFO", "started proc: " . $cmd);
//         return $backgroundProcs;
        return executeCommand($CURRENT_SOURCE_FOLDER, $cmd, "r");     
    }
    
    /**
     * crawlerAsync - call for Twitter crawler async request
     * @param unknown $prop
     * @return number|boolean
     */
    function crawlerAsync($twitterBK) {
        global $CURRENT_SOURCE_FOLDER;
        $cmd = OSSpecific::getInstance()->getCmdForCrawler($twitterBK);
        write_to_log("INFO", "started proc: " . $cmd);
        return executeCommand($CURRENT_SOURCE_FOLDER, $cmd, "r");
    }
    
    /**
     * crawlerAsync - call for Filter async request
     * @param unknown $prop
     * @return number|boolean
     */
    function filterAsync(){
        global $CURRENT_SOURCE_FOLDER;
        $cmd = OSSpecific::getInstance()->getCmdForFilter();
        write_to_log("INFO", "started proc: " . $cmd);
        return executeCommand($CURRENT_SOURCE_FOLDER, $cmd, "r");
    }

    function runPhpPage($pageName, $args, $isBackground) {
        global $CURRENT_SOURCE_FOLDER;
        $cmd = OSSpecific::getInstance()->getCmdForPhpPage($isBackground, $pageName, $args);
        write_to_log("TRACE", "executing php page: $cmd");
        return executeCommand($CURRENT_SOURCE_FOLDER, $cmd, "r");
    }
    
    function runLibraryFunc($php_files, $lib, $func, $params){
        global $CURRENT_SOURCE_FOLDER;
        if(is_array($params)){
         $params = implode(",", $params);
        }

        $cmd="php -r \"". self::orginize_requires($php_files) ."  $lib::$func($params);\"";
        $cmd = OSSpecific::getInstance()->wrapCmd($cmd, true);

        executeCommand($CURRENT_SOURCE_FOLDER, $cmd, "r");
    }
    
    function orginize_requires($php_files){
        if(empty($php_files)){
            return "";
        }
        if(!is_array($php_files)){
            return "require_once '$php_files.php';";
        }
        $require_string = "";
        foreach($php_files as $file){
            $require_string .= "require_once '$file.php'; ";
        }
        return $require_string;
    }

}
