<?php

include_once("demosettings.php");
require_once ("parseUtils.php");
require_once ("globalArr.php");
require_once ("cacheEng.php");
require_once 'sqlGeneratorClass.php';
require_once 'mainEng_funcs.php';

class AnalyticsClass {
   
    private $table;
    private $tableData;
    private $savedSearchName = "";
    private $savedSearchID = -1;
    private $docid; 
    private $mysqli;
    private $username;
    private $isAdmin;
    private $slices;
    
    function __construct($mysqli, $table, $tableData, $username, $slices, $docid = null){
        $this->mysqli = $mysqli;
        $this->table = trim($table ?? "");
        $this->tableData = $tableData;
        $this->slices = $slices;
        $this->username = $username;
        $this->isAdmin = $_REQUEST['isAdmin'] ?? getUserPermission(CAN_SHOW_ALL_USER);
        $this->docid = $docid;
    }
    
    function setSavedSearchName($savedSearchName){
        $this->savedSearchName = $savedSearchName;
    }

    function get_entity_params_arr($v2){
        $arr = array();
        $params_arr = array();
        $arr['Action'] = "searchValues";
        $arr['field'] = "searchSentiment";
        $sentiment_all = getSearchFieldValues($this->mysqli, null, null, $arr, $v2);
        $pro_string = implode(',',array_values($sentiment_all['pro']));
        $anti_string = implode(',',array_values($sentiment_all['anti']));
        $params_arr['pro'][] =  array("regular"=>array("searchSentiment"=>"Positive^$this->table^$this->tableData^^$pro_string"));
        $params_arr['anti'][] =  array("regular"=>array("searchSentiment"=>"Negative^$this->table^$this->tableData^^$anti_string"));
        $params_arr['all'][] = array("smart"=>array($this->tableData => array($this->table => $this->tableData)));
        
        return $params_arr;
    }
    
    public function getSavedSearchName($saved_search_name, $from_trends = false){
        $res = array();
        $res['name'] = $from_trends ? "(trends)$this->table" : "(analytics)$this->table";
            
        if(!empty($this->tableData)){
            $res['name'] .= "->".$this->tableData;
        }

        if(!empty($saved_search_name)){
            $res['saved_search'] = "saved_search: $saved_search_name";           
        }
        return $res;
    }

    function fetch_params_search($saved_search_arr, $extraDataKey2Table, $useSolr, $dropdownArr, $dropdownArrSolr, $skipDuplicate, $orgSolrField, $savedSearch, $isSentiment, $isField, $isTrendType_except_corresponded, $trendTypeJArr,$jsonArr, $v2){
        
        $params = array();
        //drop down array
        if (array_key_exists($this->table, $dropdownArr)) {
            if (!empty($this->tableData) && $useSolr && in_array($orgSolrField, $dropdownArrSolr)){
                $_REQUEST = array("Action"=>"search", "getDuplicate"=>!$skipDuplicate, "inResults"=>"results", "searchFreeText"=>$orgSolrField.':'.$this->tableData, "searchLabel"=>"", "skip_include" => true);
                return;
            }
            else{
                $data = $this->tableData;
                if(empty($this->tableData)){ //means - all was chosen
                    $data = getDropDownData($this->mysqli, $this->table, $v2);
                    $data = (!empty($orgSolrField) && $useSolr && in_array($orgSolrField, $dropdownArrSolr)) ? "*" : implode('^',$data);
                }
                $params[] =  array("regular"=>array("$this->table"=>$data));
            }
        }
  
        //specific enitites pie
        elseif(isEntity($this->table) && !empty($this->tableData)){
            $params = $this->get_entity_params_arr($v2);
        }
        elseif ($this->table == 'searchemails') {         
            $fields = ["searchEmailFrom"=>$jsonArr["subjectName"],"searchEmailTo"=>$jsonArr["objectName"]];       
            foreach($fields as $f=>$v){
                if(!empty($v)){
                    $params[] =  array("regular"=>array("$f"=>$v));
                }
            }
            
        }
        //full entities pie
        elseif ($this->table != "" && !in_array(strtolower($this->table),array("searchemails", "concept","network","searchrelation")) && !$isSentiment && !$isField){
            $params[] =  array("smart"=>array("$this->tableData"=>array($this->table=>$this->tableData)));
        }
        //concepts
        elseif ($this->table == "concept") {
            if(is_array($this->tableData)){
                foreach($this->tableData as $table_inst){
                    $arr = explode(';',$table_inst);
                    if($arr[0] !== "conceptType"){
                        $params[0]['regular']['searchOther'][] = ("$arr[0]=$arr[1]");
                    }
                }
            }
            else{
                $arr = explode(';',$this->tableData);
                //$arr[0] == "conceptType" - checks if is subclass selection and not instances
                $params[] = ($arr[0] == "conceptType")  ?  null : array("regular"=>array("searchOther"=>"$arr[0]=$arr[1]"));
            }
        }
        //relations, corefs and more - except corresponded (no advance search for it)
        elseif($isTrendType_except_corresponded){
            $params = $this->getRelationsParams($this->mysqli, $trendTypeJArr,$jsonArr);    
        }
        
        $savedSearchParam = !empty($savedSearch) ? array("regular"=>array("searchSavesearch"=>$savedSearch)) : null;
        if(!empty($savedSearchParam)){
            if(count($params)>1){
                foreach($params as &$obj){
                    $obj[] = $savedSearchParam;
                }
            }
            else{
                $params[] = $savedSearchParam;
            }
        }
        $saved_search_arr['label'] = json_encode($params, true);
        return $params;
        
    }
    
    function getRelationsParams($trendTypeJArr,$jsonArr){
        $params = array();
        $rel_arr = getRelationsArgs($this->mysqli, $trendTypeJArr,$jsonArr,$this->isAdmin,$this->username);
        $subjectType = $rel_arr['subjectType'];
        $objectType = $rel_arr['objectType'];
       
        if(empty($subjectType) || empty($objectType)){
            $params = $this->getMultiRelationParams($subjectType, $objectType, $rel_arr);
        }
        else{
            $params[] = array("regular"=> array("searchRelation" => 
                        array("relationType"=>$rel_arr['relationType'],
                              "ignoreSubject"=>$rel_arr['ignoreSubject'],
                               "subjectName"=>$rel_arr['subjectName'],
                                "objectName"=>$rel_arr['objectName'],
                                "subjectType"=>$rel_arr['subjectType'], 
                                "objectType"=>$rel_arr['objectType'])
            ));
        }
        
        return $params;
    }
    
    /**
     * gets pairs of relations tables in dataset
     * @return NULL[][]
     */
    function getRelationsPairs($subject_table = null, $object_table = null){
        $response = [];
        
        $subject_table_cond = !empty($subject_table) ? " subject_table = \"$subject_table\"" : " TRUE ";
        $object_table_cond = !empty($object_table) ? " object_table = \"$object_table\"" : " TRUE ";
        
        $sql = "SELECT  subject_table,object_table FROM `inter_entity_relationship` WHERE $subject_table_cond AND $object_table_cond GROUP BY subject_table,object_table";
        $res = sqlQuery($this->mysqli, $sql);
        while ($res && $obj = $res->fetch_object()) {
            $response[] = ["subject"=> $obj->subject_table, "object"=>$obj->object_table];
        }
        return $response;        
    }
    
    
    function getMultiRelationParams($subjectType, $objectType,$rel_arr){
//         $tables_pairs = $this->getRelationsPairs($subjectType, $objectType);//array("person_object","organizational_identity","event","place_object");
        $params = array();
        $rel_type = $rel_arr["relationType"];
        //if only one side marks "all"
        if(!empty($subjectType) || !empty($objectType)){
            $params[0]["regular"]["searchRelation"][] = array("relationType"=>$rel_type ,"ignoreSubject"=>$rel_arr['ignoreSubject'],
                                                                                "subjectName"=>"$rel_arr[subjectName]", "objectName"=>"$rel_arr[objectName]",
                                                        "subjectType"=>$subjectType, "objectType"=>$objectType);
//             foreach($tables_pairs as $pair){
//                 $params[0]["regular"]["searchRelation"][] = array("relationType"=>"$rel_arr[relationType]" ,"ignoreSubject"=>$rel_arr['ignoreSubject'],
//                                                                     "subjectName"=>"$rel_arr[subjectName]", "objectName"=>"$rel_arr[objectName]",
//                                                                  "subjectType"=>$pair["subject"], "objectType"=>$pair["object"]);
//             }
        }
        else{
            $params[0]["regular"]["searchRelation"][] = array("relationType"=>$rel_type ,"ignoreSubject"=>$rel_arr['ignoreSubject'],
                "subjectName"=>"$rel_arr[subjectName]","objectName"=>"$rel_arr[objectName]",
                "subjectType"=>"", "objectType"=>"");
//             foreach($tables_pairs as $pair){
//                 $params[0]["regular"]["searchRelation"][] = array("relationType"=>"$rel_arr[relationType]" ,"ignoreSubject"=>$rel_arr['ignoreSubject'],
//                                                             "subjectName"=>"$rel_arr[subjectName]","objectName"=>"$rel_arr[objectName]",
//                                                             "subjectType"=>$pair["subject"], "objectType"=>$pair["object"]);

//             }
        }
        return $params;
    }
    
    function getValuesFromSearch($dates_range, $containsDate, $res_cache){
        global $hideConceptInstances;
        
        $ret_arr = array();
        $arr = array();
        $response = array();
        
        $hiddenInstancesSql = "";
                
        $hidden_sql = (!empty($hideConceptInstances) && array_key_exists($this->table, $hideConceptInstances)) ? "  $this->table."."value NOT IN ('" . join("','", $hideConceptInstances[$this->table]) . "') " : " TRUE ";
            
        $saved_sql = !empty($this->docid) ?   " = $this->docid": " IN (SELECT docid FROM savedsearchid WHERE id=$this->savedSearchID) ";
        $sql = "SELECT * FROM (SELECT value as v, COUNT(DISTINCT docId) as c from $this->table WHERE docid  $saved_sql AND $hidden_sql group by VALUE) as t ORDER BY c DESC, v";
        
        $res = sqlQuery($this->mysqli, $sql);
        
        while ($res && $obj = $res->fetch_object()) {
            $arr[$obj->v] = $obj->c;
        }
        

        $arr = array_slice($arr, 0, $this->slices, true); //arrray is already sort by value (and abc if equal value)
        $cached_arr = $res_cache['amount'] ?? [];
        $cached_data = [];
        foreach($cached_arr as $key=>$value){
            $cached_data[$key] = $value['scale'];
        }
        arsort($cached_data);
        // Sort the array by keys in alphabetical order for equal values
        uksort($cached_data, function ($a, $b) use ($cached_data) {
            $valueComparison = $cached_data[$b] - $cached_data[$a];
            if ($valueComparison == 0) {
                return strcasecmp($a, $b);
            }    
            return $valueComparison;
        });
        
        //sort cache data and arr before compare and check diff
        $cached_keys = array_change_key_case($cached_data, CASE_LOWER);
        $arr_keys = array_change_key_case($arr, CASE_LOWER);
        
        $cached_keys = array_keys($cached_keys);
        $arr_keys = array_keys($arr_keys);
        foreach($arr as $key=>$val){      
            $key = strtolower($key);
            
            //scale diff
            $curr_scale = $val;
            $cache_scale = array_key_exists($key, $cached_data) ? intval($cached_data[$key]) : 0;
            $diff = abs($cache_scale-$curr_scale);
            $ret_arr[$key]['new_occ'] = $diff;

            $curr_pos = getCurrPos($arr_keys, $key);
            $cache_pos = getCurrPos($cached_keys, $key);
            $update_num = (!empty($cache_pos) || $cache_pos === 0) ? $cache_pos-$curr_pos : 0 ;
            $ret_arr[$key]['update_pos'] = $update_num;
          
            $ret_arr[$key]['label'] = $key;
            $ret_arr[$key]['scale'] =  intval($val);
            
        }
        $response["amount"] = empty($ret_arr) ? json_decode('{}') : $ret_arr;
        if ($this->table == "threat_rating") {
            $response["isRisk"] = "true";
        }
        else if ($this->table == "lang" || $this->table == "user_lang") {
            $response["amount"] = maplangFull($response);
        }
        
//         $response["total"] = intval(numOfTableObjects($this->mysqli, $this->table, $this->isAdmin, $this->username));
        $response["FilesWithoutObjects_num"] = filesWithoutObjects($this->mysqli, $this->table, $dates_range['from'] ?? null, $dates_range['to'] ?? null, $containsDate, $this->isAdmin, $this->username);
        $response['savedSearchName'] =  $this->savedSearchName;
        return $response;
    }
    
  
    
    function getResponseFromSearch($table, $res_cache){
   
        global $username;
        global $hideConceptInstances;
        
        $ret_arr = array();
        $response = array();
        
        $isAdmin =  $_REQUEST['isAdmin'] ?? getUserPermission(CAN_SHOW_ALL_USER);      
        
        $hiddenInstancesSql = "";
        
        $name_index = "name"; 
        $saved_sql = !empty($this->docid) ?   " = $this->docid": " IN (SELECT docid FROM savedsearchid WHERE id=$this->savedSearchID) ";
        if($table == "city"){
            $coordinates = getCoordinates($this->mysqli);
        }
        $hidden_sql = (!empty($hideConceptInstances) && array_key_exists($table, $hideConceptInstances)) ? "  $table."."name NOT IN ('" . join("','", $hideConceptInstances[$table]) . "') " : " TRUE ";
        $sqls = array();
        foreach(array('pro', 'anti', 'amount') as $sent){
            $sql_suffix = " TRUE ";
            $pro_var = " ";
            $anti_var = " ";
            $place_coor_var = "";
            
            if($sent=='pro'){
                $pro_var = ", pro AS p" ;
            }
            elseif($sent=='anti'){
                $anti_var = ", anti AS a";
            }    
              
            $sql_suffix = $sent !=='amount' ? "  $sent <> ''" : "  TRUE" ; 
            $sql_suffix  .= " GROUP BY n ";
            
            
            $sqls [$sent] = "SELECT * FROM (SELECT $name_index AS n, COUNT(DISTINCT docId) as c, ontName as o, orgText as org   $pro_var $anti_var   from $this->table WHERE  docid $saved_sql AND $hidden_sql AND $sql_suffix) as t ORDER BY c DESC LIMIT $this->slices";
        }

        foreach($sqls as $key=>$query){
            switch($key){
                case 'pro':
                    $key = "popular";
                    break;
                case 'anti':
                    $key = "unpopular";
                    break;
            }
            $res_sql = sqlQuery($this->mysqli, $query);
            
        
            while ($row = $res_sql->fetch_object()) {                     
                $key_label = mb_strtolower($row->n);
                $res = array("label" => $row->n, "scale" => intval($row->c), "ont" => $row->o);   
                if(property_exists($row, 'org')){
                    $res["orgText"] = $row->org;
                }
                if($table == 'city' && array_key_exists($row->o, $coordinates)){
                    $res["coordinates"] = $coordinates[$row->o];
                }
                $response[$key][$key_label] = $res;            
                
            }
            
        }  
       
        
        //compare and add stock update - add the update pos since last cached results
        if(!empty($res_cache)){
            foreach($response as $sent=>&$arr){
                if(!array_key_exists($sent, $res_cache)){
                    continue;
                }
                $cached_data = $res_cache[$sent];
             
                //sort cache data and arr before compare and check diff
                $cached_data = $res_cache['amount'] ?? [];
                $this->sortArray($cached_data);
                $this->sortArray($arr);
       
                $cached_keys = array_keys($cached_data);
                $arr_keys = array_keys($arr);
                foreach($arr as $label=>&$data){
        
                    //scale diff
                    $curr_scale = $data['scale'];
                    $cache_scale = array_key_exists($label, $cached_data) ? $cached_data[$label]['scale'] : 0;
                    $diff = abs($cache_scale-$curr_scale);
                    $data['new_occ'] = $diff; 
                    
                    $curr_pos = getCurrPos($arr_keys, $label);
                    $cache_pos = getCurrPos($cached_keys, $label);
                    
                    $update_num = (!empty($cache_pos) || $cache_pos === 0) ? $cache_pos-$curr_pos : 0 ;
                    
                    $data['update_pos'] = $update_num;                  
                }
                
            }
        }

        $response['title'] =  $this->table;
        $response['total'] = array_key_exists('amount', $response) ? count($response['amount']) : 0;
        $response['savedSearchName'] =  $this->savedSearchName;
        
        return $response;
    }
    
    function sortArray(&$arr){
        uasort($arr, function ($a, $b) {
            if ($a['scale'] == $b['scale']) {
                return strcmp($a['label'], $b['label']); // Alphabetic sorting for equal groups
            }
            return $b['scale'] - $a['scale'];
        });
    }
 
    /**
     * new solr generate keywords
     */
    function genereateSolrWordCloud($ss_name = null){
        $useSolr = getSystemSettingsProp($this->mysqli, "useSolr");
        if(!$useSolr){
            return ["error" => "Solr is off"];
        }
 
        //get stopwords from file
        $stopwordsstr = file_get_contents(".".DIRECTORY_SEPARATOR."files".DIRECTORY_SEPARATOR."stopwords.txt");;
        $stopwords = array_map('trim', explode("\r\n", $stopwordsstr));    
        
        global $SOLR_SERVER_HOSTNAME, $SOLR_SERVER_PORT, $SOLR_COLLECTION, $SOLR_TXT_FIELD;
        $solrQuery = "http://$SOLR_SERVER_HOSTNAME:$SOLR_SERVER_PORT/solr/$SOLR_COLLECTION/select?q=*:*&facet=true&facet.field=$SOLR_TXT_FIELD&facet.limit=$this->slices";
        
        $solrJson = file_get_contents($solrQuery);
        $xml = new SimpleXMLElement($solrJson);
        
        $elements = $xml->xpath("//lst[@name='content_txt']/int");
        $total = [];
        foreach ((array)$elements as $element) {
            $array = get_object_vars($element);
            $name = $array['@attributes']["name"];

            //skip pure numbers or stopwords
            if(is_numeric($name) || in_array(trim($name),$stopwords)){
                continue;
            }
            $total[] = ['label'=> $array['@attributes']["name"],'count'=>$array[0]];
        }
        
      
       
        return $total;
        
    }

    function genereateSolrWordCloudResponse($ss_name = null){
        $response = $this->genereateSolrWordCloud($ss_name);
        $final = ["all"=>[]];
        
        foreach($response as $element){
            $resArr["all"][$element["label"]]['c'] = $element["count"];
            $resArr["all"][$element["label"]]['t'] = "solr";
            
            
        }
        return $resArr;
    }
    
    function generateKeywords($mysqli, $option, $orderBy, $prominence, $savedsearch, $limit, $filter){
        $_REQUEST['skip_include'] = true;
        require_once 'searchEng.php';
        require_once 'sqlUtils.php';
        require_once 'parseUtils.php';
        global $skipDuplicate;
        global $dropdownArr,$dropdownArrSolr;
        global $extraDataKey2Table;
        $useSolr = getSystemSettingsProp($mysqli, "useSolr");
        
        $queries = array();
        $savedSearchArr = array();
        $savedSearchArr['name'] = $this->savedSearchName = "(analytics)keywords";
        $params = array();
        $table_arr = is_array($filter) ? $filter : explode(",", $filter);
        
        if(empty($filter) || empty($filter[0])){
            $table_arr = getKeywordTables($mysqli);   
        }
        
        $dates_arr = getPastPeriod_ExtraData(getPastPeriod($this->mysqli, $this->username));

        if ($option == "Concept"){
            $orgName = "name";
        }
        else{
            $orgName = "orgText";
        }
        if ($prominence == "Document"){
            $orgSum = "COUNT(name)";
        }
        else{
            $orgSum = "SUM(occurrences)";
        }
        $savedsearchId = 0;
        if (strlen($savedsearch) > 0){
            $sql = "SELECT id FROM savedsearch WHERE name='$savedsearch' AND username='$this->username'";
            $res = sqlQuery($this->mysqli, $sql);
            if ($res && $res->num_rows){
                $obj = $res->fetch_object();
                $savedsearchId = $obj->id;
            }
        }
        
        global $hideConceptInstances;
        $count = 0;
        foreach ($table_arr as $t){
            $name = $orgName;
            $sum = $orgSum;
            $table_exists = isTableExists($this->mysqli,$t);
            if(!$table_exists){
                continue;
            }
            //if it's extradata table
            if (array_key_exists($t, $dropdownArr)){
                $name = "value";
                $sum = "COUNT(value)";
            }
            $hideSql = "";
            if (!empty($hideConceptInstances) && array_key_exists($t, $hideConceptInstances))
            {
                $hideSql = "$t.$name NOT IN ('" . join("','", $hideConceptInstances[$t]) . "') ";
                
            }
            else{
                $hideSql="TRUE";
            }
            
            if(!is_null($dates_arr)){
                $date_sql = "$t.docId IN ".$dates_arr["date_sql"];
            }
            else{
                $date_sql = "TRUE";
            }
            
            if(!$this->isAdmin){
                $user_sql = "files.username='$this->username' AND  files.id=$t.docId";
                $files_string=",files ";
            }
            else{
                $user_sql = "TRUE";
                $files_string="";
            }
            
            if ($savedsearchId > 0){
                if($user_sql!="TRUE"){
                    $user_sql.=" AND files.id=$t.docId AND files.id=savedsearchid.docId";
                }
                $query = "SELECT $name AS n,$sum AS s,'$t' as tablename FROM $t,savedsearchid".$files_string." WHERE $hideSql AND $date_sql 
                AND savedsearchid.id=$savedsearchId AND $t.docId= savedsearchid.docId AND $user_sql GROUP BY $name ";           
            }
            else{
                $query = "SELECT $name AS n,$sum AS s, '$t' as tablename FROM $t".$files_string." WHERE  $hideSql AND $date_sql AND $user_sql GROUP BY $name ";    
            }
            $queries[] = $query;
        }
        $chunks = array();
        $resArr = array();
        $chunkNum = 0;
        //memsql has limitation of 40 sub-query nesting, so we need to create chunks
        foreach (array_chunk($queries, 20) AS $chunk)
            $chunks[] = "SELECT * FROM (" . join (" UNION ", $chunk) . ") AS chunk" . ++$chunkNum;
            $query = "SELECT n, SUM(s) AS s, ANY_VALUE(tablename) AS tn FROM(" . //Be Warned! This means the sum is over all instances occasionally NOT from the same table! 
                join(" UNION ALL ", $chunks) .
                ") AS t GROUP BY n ORDER BY s DESC LIMIT $limit";
                write_to_log("PERMORMENCE", "generateKeywords - $query" . date('H:i:s'.substr((string)microtime(), 1, 8)));
                $res = sqlQuery($this->mysqli, $query);
                if (!empty($res)){
                    while (($obj = $res->fetch_object()) && ($count < $limit)){
                        if (!empty($obj->n)){
                            $table = $obj->tn;
                            if ($orderBy == "Concept"){
                                $resArr[$table][$obj->n]['t'] = $obj->tn;
                                $resArr[$table][$obj->n]['c'] = $obj->s;
                            }
                            //corpus
                            else{
                                if(!isset($resArr["all"][strtolower($obj->n)])){
                                    $resArr["all"][strtolower($obj->n)]['t'] = $obj->tn;
                                    $resArr["all"][strtolower($obj->n)]['c'] = 0;
                                }
                                $resArr["all"][strtolower($obj->n)]['c'] += $obj->s; 
                            }
                            $count++;
                        }
                    }
                    
                }
                return $resArr;
    }
    
    function loadWordCountData()
    {
        $response = ["amount" => []];
        $phrases = empty($this->savedSearchName) ? getDocsWordCloud($this->mysqli, "", $this->slices) : getDocsWordCloud($this->mysqli, "SELECT ssi.docid FROM savedsearchid ssi, savedsearch ss WHERE ss.name='" . $this->mysqli->real_escape_string($this->savedSearchName) . "' AND ss.username='$this->username' AND ssi.id=ss.id", $this->slices);
        foreach ($phrases as $phrase => $count) {
            $response["amount"][] = [$phrase, $count];
        }
        return $response;
    }
    
    function loadTopCorefs($savedSearchId)
    {
        $response = ["amount" => []];
        $results = getTopCoRefs($this->mysqli, "person_object", "person_object", $this->slices, $savedSearchId, $this->username,$this->isAdmin);
        
        foreach ($results as $row)
        {
            $response["amount"][] = [$row["name1"] . " - " . $row["name2"], $row["coRefs"] ];
        }
        return $response;
    }
    
    /**Get the aggregated data as an array.*/
    function getAggregatedData($aggData, $aggArr){
        
        
        $aggregatedData = array();
        
        foreach ($aggArr as $col_name=>$name){
            if($this->table == $name){
                $this->table = $col_name;
            }
        }
        
        $query = "SELECT aggregatedName AS aggn,aggregatedManual AS man FROM entitiesmanage WHERE name='$aggData' AND entity='$this->table'";
        write_to_log("PERMORMENCE", "piegraph sql - $query -" . date('H:i:s'.substr((string)microtime(), 1, 8)));
        $res = sqlQuery($this->mysqli,$query);
        
        if(($row = $res->fetch_object()) != null){
            
            $tok = strtok($row->aggn, ";");
            
            while ($tok !== false) {
                $aggregatedData[] = $tok;
                $tok = strtok(";");
            }
            
            $man_tok = strtok($row->man, ";");
            
            while ($man_tok !== false) {
                $aggregatedData[] = $man_tok;
                $man_tok = strtok(";");
            }
            
        }
        return $aggregatedData;
    }

    
    function search_and_fetch_id($params, $full_search_name, $dates_range_str = null){
        require_once 'v2'.DIRECTORY_SEPARATOR . 'mainEng_funcs_v2.php';
        if(!empty($dates_range_str)){
            $params[] = ["regular" => ["DateSearch"=>$dates_range_str]];
        }
        $params_json = json_encode($params, JSON_FORCE_OBJECT);
        $res = getDetailsForSmartSearch_v2($this->mysqli,$this->username, $params_json);
        search($this->mysqli, $full_search_name, $res["searchParameters"], $res["entityParmetersArr"], $res["tableAndCaption"], $params, null, null, null, true);
        $this->savedSearchID = getLastSavedSearchId($this->mysqli, $this->username, $full_search_name);
        return $this->savedSearchID;
    }
}

