<?php
require_once 'slotToCaption.php';
require_once 'demosettings.php';
require_once 'write_log.php';
require_once 'sqlUtils.php';

//class flavor 
class AllConceptsData{
        private static $merged_data = array();
        private static $userName ="";

        public function __construct($mysqli, $data, $allConceptFlavor, $userName) {

        self::setUserName($userName);
        
        //setting the final array - merged - with array for the flavors
        foreach ($data as $curr_flavor => $data_flavor) {
            foreach ($data_flavor as $table_name => $digestCaption) {
                $dict_element = array("name" => $table_name);
                $dict_element["digestCaption"] = empty($digestCaption) ? [] : [$digestCaption];
                $dict_element["flavor"] = empty($digestCaption) ? [] : [$curr_flavor];
                if (array_key_exists($table_name, self::$merged_data)) {
                    self::$merged_data[$table_name]["flavor"] = array_merge($dict_element["flavor"], self::$merged_data[$table_name]["flavor"]);
                    self::$merged_data[$table_name]["digestCaption"] = array_merge($dict_element["digestCaption"], self::$merged_data[$table_name]["digestCaption"]);  
                } else {
                    self::$merged_data[$table_name] = $dict_element;
                }
            }
        }
    }
     
    public static function setUserName($name){
        self::$userName = $name; 
    }
    
    public static function getUserName(){
        return self::$userName;
    }
    
    //Getter for the flavor
    public static function get_flavors() {
        return self::$flav_arr;
    }

        public static function get_flavor($mysqli) {
            require_once 'settings.php';
            $settings_class =  new Settings($mysqli, self::$userName);
            $response =  $settings_class->getActiveFlavor();
            return $response;
    
}

    //Setter for the falvor
    public static function setFlavor($mysqli, $new_flavor) {
        $nf = strtolower($new_flavor);
        if (!in_array($nf, self::$flav_arr)) {
             $error = self::errors("setFlavor", array('new_flavor' => $new_flavor));
            write_to_log("ERROR", $error['Error']);
            return $error;
        }
        self::setFlavorToDB($mysqli, $nf);
        return array('success'=>'flavor successfully updated!');
    }

	
    //if there is flavor set its will be string 
    public static function isFlavorSet($mysqli){
        $flavor = self::get_flavor($mysqli);
        $res = is_string($flavor);
        return $res ;
    }
      
    
    //getter for the merged_array
    public static function getMergedData(){
        return self::$merged_data;
    }
    
    public static function setFlavorToDB($mysqli, $new_flavor){
        if(self::isflavorColumnExists($mysqli)){
          $sql = self::classQuerys('updateFlavor',array('updateFlavor' => $new_flavor));
          sqlQuery($mysqli, $sql); 
        } else {
            write_to_log("ERROR", "The column flavor is not set in user_status table - please clean or add this column manually");  
        }     
      return;    
    }  

    public static function addColumn($mysqli, $tableName,$columnName,$type){
       $sql = "ALTER TABLE $tableName ADD $columnName $type";
       $res = sqlQuery($mysqli, $sql);
       if($res){
         write_to_log("INFO", "Column $columnName added successfully  ");   
       } else {
          write_to_log("ERROR", "The column $columnName wasn't added"); 
       }    
       return $res;
    }
    
    public  static function isflavorColumnExists($mysqli){
        $isExists = TablesInformation::isColumnExists($mysqli, "user_status","flavor");
        return $isExists;
    } 

   
    public static function classQuerys($type,$params=[]){
         $username = self::$userName;
         switch ($type) {
            case 'updateFlavor':
                $query = "UPDATE user_status SET flavor='".$params['updateFlavor']."' WHERE username ='".$username."'";
                break;
            case 'getFlavor':
                $query ="SELECT flavor from user_status WHERE username ='$username' AND flavor IS NOT NULL";
                break;
			
        }
         return $query;
    }
    
    public static function errors($type, $param=[]){
        static $columnDosentExist = "The column flavor is not set in user_status table - please clean or add this column manually";
        static $flavorNotSet = "flavor not set!- supossed to be a defualt value=legal";
        static $setFlavor = "invalid flavor type:";
		$msg=null;
        switch ($type) {
			case 'columnDosentExist' : $msg=$columnDosentExist;
			break;
			case 'flavorNotSet' : $msg=$flavorNotSet;
			break;
			case 'setFlavor' : $msg=$setFlavor . $param['new_flavor'];
			break;
			default:
			break;
		}
        return array('Error'=>$msg);
    }


        public static function getFlavorDataArr($mysqli, $key_Val_format = false){
            $merged_data = self::getMergedData();
            $curr_flavor = self::get_flavor($mysqli);
            $final_arr = [];
            foreach($merged_data as $element){
                if(!in_array($curr_flavor,$element["flavor"])){
                    continue;
                }
                else{
                    $dc_index = array_search($curr_flavor,$element["flavor"]);
                }
                if($key_Val_format){
                    $final_arr[$element["name"]] = array("digestCaption"=>$element["digestCaption"][$dc_index], "flavor" => $curr_flavor);
                }
                else{
                    $curr_element = array("name"=>$element["name"], "digestCaption"=>$element["digestCaption"][$dc_index], "flavor" => $curr_flavor);
                    $final_arr[] = $curr_element;
                }
            }
            return $final_arr;
        }

    }
    
 