<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class OSSpecific {

    private  static $name = null;
    private  static $osInstance = null;
    
    private function __construct() { //this is private to prevent the use of 'new' use getInstance instead 
        if (self::$osInstance == null) {
            self::$name = self::get_os();
            self::$osInstance = self::create();
        }
    }

    private static function create() {
        if (self::$name =='windows') {
            require_once 'osWindows.php';
            return new OSWindows(); 
        } else {
            require_once 'osLinux.php';
            return new OSLinux(); 
        }
    }

    public static function getInstance() {
        if (self::$osInstance == null) {
            self::$name = self::get_os();
            self::$osInstance = self::create();
        }
        return self::$osInstance;
    }
    
    
    private static function get_os() {
        $os = strtoupper(substr(PHP_OS, 0, 3));
        if ($os === 'WIN') {
            return 'windows';
        } else if ($os === 'LIN') {
            return 'linux';
        } else {
            return 'server:'.$os;
        }
    }
    
    
    private static function getOsName(){
        return self::get_os();
    }

}
