style exp_bar:
    right_bar "gui/scrollbar/horizontal_hover_exp.png"
    xysize (400,80)




style skills_bar:
    right_bar "gui/scrollbar/horizontal_hover_skills.png"
    xysize (620, 50)




default current_profile_menu = 0

default current_talent_id = -1

default current_showed_talent_id = -1


screen profile_menu:

    modal True

    add "images/character_menu/background.png"
    
    add "images/quests/textbox_2.png" xalign 0.75 ypos 40

    add "images/skills/textbox_2.png" xalign 0.75 yalign 0.95


    add "images/quests/textbox_2.png" xalign 0.25 ypos 40

    add "images/skills/textbox_2.png" xalign 0.25 yalign 0.95


    

        

    if current_profile_menu == 0 or current_profile_menu == 1:


        vbox xalign 0.295 yalign 0.85:

            spacing 20

            imagebutton xpos 20:
                idle "images/profile/bio_btn.png"
                hover im.MatrixColor("images/profile/bio_btn.png", im.matrix.brightness(0.2))
                mouse 'pointer'
                action [
                    Show('character_info')
                ]

            imagebutton xpos -20:
                idle "images/profile/attributes_btn.png"
                hover im.MatrixColor("images/profile/attributes_btn.png", im.matrix.brightness(0.2))
                mouse 'pointer'
                action [
                    SetVariable('current_profile_menu', 1)
                ]

            imagebutton xpos 20:
                idle "images/profile/abilities_btn.png"
                hover im.MatrixColor("images/profile/abilities_btn.png", im.matrix.brightness(0.2))
                mouse 'pointer'
                action [
                    Show('skills_window')
                ]

            imagebutton xpos -20:
                idle "images/profile/talents_btn.png"
                hover im.MatrixColor("images/profile/talents_btn.png", im.matrix.brightness(0.2))
                mouse 'pointer'
                action [
                    SetVariable('current_profile_menu', 3)
                ]

        

        vbox xalign 0.295 yalign 0.08:
        
            spacing 10

            if game_mc_changed == 1:

                add "images/char_info/char_vr.png" at shrink
                
            else:
                
                add "images/char_info/char.png" at shrink

            text "[char_name]" font "gui/fonts/TMR_Regular.ttf" size 34 xalign 0.5 color "#c8a055"



        

        vbox xalign 0.285 yalign 0.42:

            text "Level  {size=+20}[MC_Lvl]{/size}" size 25 xalign 1.0 color "#c8a055"

            bar:
                style "exp_bar"
                value MC_Exp
                range MC_Lvl * 98
                left_bar "gui/scrollbar/horizontal_idle_exp.png"
            
            $ needxp = MC_Lvl * 98

        
            text "[MC_Exp] / [needxp]" size 24 xalign 1.0 ypos -60 color "#c8a055"



        vbox xalign 0.295 yalign 0.5:
            
            text "Available attributes points: [ap_available]" font "gui/fonts/TMR.ttf" size 26 ypos 60 xalign 0.78 color "#c8a055"

            text "Available skill points: [sp_available]" font "gui/fonts/TMR.ttf" size 26 ypos 60 xalign 0.78 color "#c8a055"

            text "Available talent points: [tp_available]" font "gui/fonts/TMR.ttf" size 26 ypos 60 xalign 0.78 color "#c8a055"







        
        if current_profile_menu == 0:
            text char_biography font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1030 ypos 30 color "#c8a055" size 26

        elif current_profile_menu == 1:

            text "Attributes" font "gui/fonts/TMR_Regular.ttf" size 32 ypos 60 xalign 0.69 color "#c8a055"

            text "Available attributes points: [ap_available_cur]" font "gui/fonts/TMR_Regular.ttf" size 26 ypos 120 xalign 0.78 color "#c8a055"

            vbox xpos 1030 yalign 0.25:

                vbox:
                    spacing -5

                    default attributes = [
                        ("Strength",     "MC_Strength",    "Attack Power (+[{0}_Cur*2]%)"),
                        ("Dexterity",    "MC_Dexterity",   "Critical Chance ([{0}_Cur*2]%)"),
                        ("Magic",        "MC_Magic",       "Magic Damage (+[{0}_Cur*2]%)"),
                        ("Willpower",    "MC_Willpower",   "Mana / Stamina ([100 + {0}_Cur * 5])"),
                        ("Cunning",      "MC_Cunning",     "Critical Damage ([100 + {0}_Cur * 5]%)"),
                        ("Constitution", "MC_Body",        "Health ([150 + MC_Lvl * 5 + {0}_Cur * 5])"),
                    ]

                    for label, base_var, desc_template in attributes:

                        $ cur_var = base_var + "_Cur"
                        $ cur_val = getattr(store, cur_var)
                        $ base_val = getattr(store, base_var)

                        hbox xminimum 530:
                            hbox:
                                spacing 8

                                hbox yalign 0.5:
                                    spacing 2

                                    if cur_val > base_val:
                                        textbutton "-" action [
                                            SetVariable(cur_var, cur_val - 1),
                                            SetVariable("ap_available_cur", ap_available_cur + 1)
                                        ] text_size 32 text_font "gui/fonts/TMR_Regular.ttf" ypos -3
                                    else:
                                        textbutton "-" action NullAction() text_size 32 text_font "gui/fonts/TMR_Regular.ttf" ypos -3

                                    text "[cur_val]" font "gui/fonts/TMR_Regular.ttf" size 28 color "#fbd389" yalign 0.5

                                    if ap_available_cur > 0:
                                        textbutton "+" action [
                                            SetVariable(cur_var, cur_val + 1),
                                            SetVariable("ap_available_cur", ap_available_cur - 1)
                                        ] text_size 28 text_font "gui/fonts/TMR_Regular.ttf" yalign 0.5
                                    else:
                                        textbutton "+" action NullAction() text_size 28 text_font "gui/fonts/TMR_Regular.ttf" yalign 0.5

                                text label font "gui/fonts/TMR_Regular.ttf" size 28 color "#fbd389" yalign 0.5

                            text desc_template.format(base_var) font "gui/fonts/TMR_Regular.ttf" size 20 color "#ae7e26" yalign 0.7 xalign 1.0

                    


                vbox xpos -10 ypos 20:

                    add "images/profile/delimeter.png"

                    vbox ypos 20 xpos 10: 
                        spacing 8

                        hbox xminimum 530:

                            text "Damage" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                            text "[10+MC_Strength_Cur*5+Weapon_Damage]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0

                        hbox xminimum 530:

                            text "Magic Damage" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                            text "[10+MC_Magic_Cur*5+Weapon_Damage]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0

                        hbox xminimum 530:

                            text "Defense" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                            text "[2+MC_Body_Cur*2+MC_Strength_Cur+Armor]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0

                        hbox xminimum 530:

                            text "Evasion" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                            text "[int(2+MC_Dexterity_Cur*0.8+MC_Cunning_Cur*0.6)]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0



            if ap_available_cur != ap_available:
                
                hbox xalign 0.71 yalign 0.75:

                    imagebutton:
                        idle "images/profile/accept_btn.png" at shrink
                        hover im.MatrixColor('images/profile/accept_btn.png', im.matrix.brightness(0.2))
                        action [
                            SetVariable("ap_available", ap_available_cur),
                            SetVariable("MC_Strength", MC_Strength_Cur),
                            SetVariable("MC_Dexterity", MC_Dexterity_Cur),
                            SetVariable("MC_Magic", MC_Magic_Cur),
                            SetVariable("MC_Willpower", MC_Willpower_Cur),
                            SetVariable("MC_Cunning", MC_Cunning_Cur),
                            SetVariable("MC_Body", MC_Body_Cur),
                        ]
                        mouse 'pointer'

                    imagebutton:
                        idle "images/profile/reset_btn.png" at shrink
                        hover im.MatrixColor('images/profile/reset_btn.png', im.matrix.brightness(0.2))
                        action [
                            SetVariable("ap_available_cur", ap_available),
                            SetVariable("MC_Strength_Cur", MC_Strength),
                            SetVariable("MC_Dexterity_Cur", MC_Dexterity),
                            SetVariable("MC_Magic_Cur", MC_Magic),
                            SetVariable("MC_Willpower_Cur", MC_Willpower),
                            SetVariable("MC_Cunning_Cur", MC_Cunning),
                            SetVariable("MC_Body_Cur", MC_Body),
                        ]
                        mouse 'pointer'

            









    elif current_profile_menu == 3:


        text "Available talent points: [tp_available_cur]" font "gui/fonts/TMR_Regular.ttf" size 26 ypos 60 xalign 0.38 color "#c8a055"

        vbox xalign 0.27 yalign 0.55:
            spacing 10
            text "Talents" font "gui/fonts/TMR_Regular.ttf" size 34 color "#c8a055" xalign 0.5 ypos -30

            python:
                talent_rows = [
                    ["talk", 0],
                    ["seduce", 4],
                    ["body", 8],
                    ["pupil", 12],
                    ["craft", 16],
                    ["herbal", 20],
                    ["thief", 24],
                ]

            for group, start_id in talent_rows:
                hbox xalign 0.5 spacing 0:
                    for i in range(4):
                        $ tid = start_id + i
                        $ var_name = f"talent_{group}_{i}"
                        $ img_path = f"images/skills/{group}_{i+1}.png"

                        if talents[tid] == 1:

                            imagebutton:
                                idle im.MatrixColor(img_path, im.matrix.tint(1.9, 1.2, 1.9)) at shrink
                                hovered SetVariable("current_showed_talent_id", tid)
                                unhovered SetVariable("current_showed_talent_id", -1)
                                mouse "pointer"
                                action NullAction()

                        # elif (i == 0 or eval(var_name)) or (talents[tid+7] == 0):

                        elif (talents[tid] == 0 and (tid == 0 or tid == 4 or tid == 8 or tid == 12 or tid == 16 or tid == 20 or tid == 24)) or (talents[tid-1] == 1):
                            imagebutton:
                                idle img_path at shrink
                                hover im.MatrixColor(img_path, im.matrix.brightness(0.2))
                                hovered SetVariable("current_showed_talent_id", tid)
                                unhovered SetVariable("current_showed_talent_id", -1)
                                selected_idle im.MatrixColor(img_path, im.matrix.tint(1.6, 1.2, 1.0))
                                selected_hover im.MatrixColor(im.MatrixColor(img_path, im.matrix.tint(1.6, 1.6, 1.0)), im.matrix.brightness(0.2))
                                mouse "pointer"
                                if tp_available_cur > 0:
                                    action [
                                        SetVariable('talent_image', img_path),
                                        SetVariable("tp_available_cur", tp_available_cur-1),
                                        SetVariable("current_talent_id", tid)
                                        ]
                                else:
                                    action [
                                        SetVariable("current_talent_id", tid)
                                        ]
                        else:
                            imagebutton:
                                idle im.MatrixColor(img_path, im.matrix.tint(0.4, 0.4, 0.4)) at shrink
                                hovered SetVariable("current_showed_talent_id", tid)
                                unhovered SetVariable("current_showed_talent_id", -1)
                                mouse "pointer"
                                action NullAction()

                        if i != 3:
                            add "images/skills/arrow.png" yalign 0.5



        if tp_available_cur != tp_available and (current_talent_id < 12) and talents[current_talent_id] != 1:

            vbox xalign 0.7 yalign 0.6:

                text "Talent upgrade cost: 1 TP" font "gui/fonts/TMR_Regular.ttf" size 26 color "#c8a055"
                
            hbox xalign 0.71 yalign 0.65:

                imagebutton:
                    idle "images/profile/accept_btn.png" at shrink
                    hover im.MatrixColor('images/profile/accept_btn.png', im.matrix.brightness(0.2))
                    action [
                        SetVariable("tp_available", tp_available_cur),
                        Function(set_talent, current_talent_id, 1)
                    ]
                    mouse 'pointer'

                imagebutton:
                    idle "images/profile/reset_btn.png" at shrink
                    hover im.MatrixColor('images/profile/reset_btn.png', im.matrix.brightness(0.2))
                    action [
                        SetVariable("tp_available_cur", tp_available),
                    ]
                    mouse 'pointer'





        if current_showed_talent_id == 0:
            
            text "Persuasion – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You’ve taken your first steps toward mastering the art of influence. Whether it’s through charm, reason, or subtle manipulation, your words now carry more weight.\n\nConversations may open new paths, and people might start seeing things your way — if only just a little. Use this gift wisely... persuasion can be as powerful as any weapon." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


        
        elif current_showed_talent_id == 1:
            
            text "Persuasion – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "Your voice carries greater confidence, and your arguments are sharper. You’re no longer just convincing — you’re compelling.\n\nAt this level, you can influence decisions more effectively, charm resistant characters, and occasionally steer conversations in your favor with ease. Words are no longer just tools — they’re your weapon." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


        
        elif current_showed_talent_id == 2:
            
            text "Persuasion – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You've become a true master of words. With a glance or a few carefully chosen phrases, you can shift emotions, twist logic, and guide people exactly where you want them.\n\nEven the most stubborn minds can falter under your influence. At this level, your persuasion can unlock exclusive dialogue paths, manipulate outcomes, and bend the will of others to serve your goals." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


        
        elif current_showed_talent_id == 3:
            
            text "Persuasion – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "Your words now carry the weight of absolute conviction. People listen, believe, and act — often without even realizing why. You don’t just persuade anymore — you reshape desires.\n\nAt this level, your presence alone can alter conversations, defuse conflicts, or spark decisions that change fates. Only the strongest minds can resist you now… and even they may waver." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5









        elif current_showed_talent_id == 4:
            
            text "Seduction – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You’ve begun to tap into the power of desire. With a flirtatious smile or a well-timed glance, you can stir emotions and cloud judgment.\n\nAt this level, your seductive presence may sway hearts and open doors — figuratively and literally. It’s not just about beauty; it’s about knowing exactly when to use it." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


        elif current_showed_talent_id == 5:
            
            text "Seduction – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "Your charm has deepened — no longer just playful, but undeniably alluring. A touch, a look, even silence can now make hearts race.\n\nAt this level, seductive choices become more effective, especially in situations involving attraction, distraction, or manipulation through desire." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



        elif current_showed_talent_id == 6:
            
            text "Seduction – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You’ve refined seduction into an art. Your presence stirs fantasies, and your body language speaks louder than words. People want to please you — or at least stay close enough to try.\n\nAt this level, seduction can override logic, sway strong-willed characters, and open intimate or hidden paths that others would never see." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



        elif current_showed_talent_id == 7:
            
            text "Seduction – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You are irresistible. Every gesture feels deliberate, every glance loaded with promise. People don’t just want you — they need you.\n\nAt this level, your seductive power can break defenses, dominate interactions, and turn even enemies into admirers. You don’t chase — the world follows." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5








        elif current_showed_talent_id == 8:
            
            text "Heracles – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You’ve begun shaping your body into something stronger, tougher. Muscles tighten, and each strike lands with more weight.\n\nAt this level, you gain a small bonus to physical attack and max health — a solid foundation for future might." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


        elif current_showed_talent_id == 9:
            
            text "Heracles – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "Your physique grows noticeably more powerful. Your blows hit harder, and you can take more punishment without faltering.\n\nAttack and health are further increased, making you more resilient in both combat and survival." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



        elif current_showed_talent_id == 10:
            
            text "Heracles – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You now carry the presence of a true warrior. Your body is a weapon — forged through effort and endurance. Few can stand against your strength.\n\nMajor boosts to physical damage and health pool. Enemies may hesitate before testing your power." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



        elif current_showed_talent_id == 11:
            
            text "Heracles – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You’ve reached near-mythic strength. With every move, you radiate raw power. Your body withstands what would crush lesser beings, and your strikes can shatter armor — or bone.\n\nAt this level, you gain massive increases to physical attack and max health. You're no longer just strong — you're unstoppable." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5









        elif current_showed_talent_id == 12:
            
            text "Love for Magic – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You’ve discovered a spark — a fascination with the arcane. Magic feels natural in your hands, and your will begins to shape reality.\n\nAt this level, you gain a small boost to magic attack and mana pool. You also unlock access to basic magical abilities." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


        elif current_showed_talent_id == 13:
            
            text "Love for Magic – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "Your connection to the mystical deepens. Spells come more easily, and your mind becomes more resistant to outside influence.\n\nGrants a moderate increase to magic damage and mana reserves. You can now learn intermediate spells that others struggle to grasp." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



        elif current_showed_talent_id == 14:
            
            text "Love for Magic – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "Magic flows through you like a second bloodstream. Your will is sharp, your focus unshakable. Even the elements seem to answer your call.\n\nAt this level, you receive a major boost to magical power and mana capacity. Unlocks advanced magical abilities and improves spellcasting efficiency." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



        elif current_showed_talent_id == 15:
            
            text "Love for Magic – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You’ve become one with the arcane. Your presence distorts the air around you, and your power can bend reality itself.\n\nGrants a massive increase to magic attack and mana. You now have access to powerful, rare spells — and the will to control them." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5











        elif current_showed_talent_id == 16:
            
            text "Craftsman’s Path – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You’ve learned the basics of crafting. With the right tools and a bit of patience, you can now create simple equipment and consumables.\n\nUnlocks basic crafting recipes: potions, basic gear, and utility items." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


        elif current_showed_talent_id == 17:
            
            text "Craftsman’s Path – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "Your hands are steadier, your designs more refined. You now have the skill to forge reliable weapons and armor that can hold their own in battle.\n\nAllows crafting of improved weapons, armor, and useful trinkets with moderate stats." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



        elif current_showed_talent_id == 18:
            
            text "Craftsman’s Path – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You’ve begun weaving magic into your creations. Enchanted blades, spell-imbued scrolls, and arcane tools are now within your grasp.\n\nGrants access to magical crafting: enchanted gear, scrolls, and specialty items with magical properties." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



        elif current_showed_talent_id == 19:
            
            text "Craftsman’s Path – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You are a true master of the forge and the arcane bench. With rare materials and ancient knowledge, you can now create legendary artifacts — unique and unmatched.\n\nEnables crafting of legendary weapons, powerful gear, and rare one-of-a-kind magical items. Your craftsmanship can change the fate of kingdoms." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5







        elif current_showed_talent_id == 20:
            
            text "Gatherer – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You’ve developed an eye for useful things. Herbs, ore, and common materials no longer go unnoticed.\n\nGrants a small bonus to gathering efficiency and increases the chance of finding basic resources." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


        elif current_showed_talent_id == 21:
            
            text "Gatherer – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "Your hands are swift, and your instincts sharper. You gather faster and lose less in the process.\n\nImproves yield from resource nodes and increases the chance of collecting rare components." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



        elif current_showed_talent_id == 22:
            
            text "Gatherer – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You know where to look — and how to make the most of every trip. Even magical creatures seem to yield more under your touch.\n\nGrants significant boosts to gathering quantity and unlocks chances to find magical or uncommon materials." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



        elif current_showed_talent_id == 23:
            
            text "Gatherer – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You are a master of the wild harvest. The land seems to respond to your presence, offering up its finest treasures.\n\nMassively increases resource yield and greatly improves chances of obtaining rare and legendary materials. Every expedition becomes a profitable venture." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5








        elif current_showed_talent_id == 24:
            
            text "Thief – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You’ve learned the basics of stealth and sleight of hand. You can now pick simple pockets and quietly lift unattended items.\n\nAllows low-risk theft from NPCs and small chests. Slight increase in gold and loot found during exploration." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


        elif current_showed_talent_id == 25:
            
            text "Thief – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "Your fingers are quicker, your movements smoother. Locks and distractions no longer intimidate you.\n\nUnlocks moderate-level pickpocketing, chest unlocking, and improves the chance to steal rare items or gold unnoticed." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



        elif current_showed_talent_id == 26:
            
            text "Thief – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You’ve become a shadow in plain sight. Even guarded belongings are not safe when you’re nearby.\n\nGrants access to high-risk, high-reward thefts, including stealing from nobles or guarded storages. Greatly increases loot and gold gain from theft and exploration." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



        elif current_showed_talent_id == 27:
            
            text "Thief – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

            text "You are the stuff of whispered legends. Locks mean nothing, guards are blind, and riches flow to your hands as if by fate.\n\nAllows stealing legendary items, bypassing magical protections, and extracting maximum gold from every opportunity. You don’t just take — you own the shadows." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5










        if current_showed_talent_id == -1:

            if current_talent_id == 0:
                
                text "Persuasion – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You’ve taken your first steps toward mastering the art of influence. Whether it’s through charm, reason, or subtle manipulation, your words now carry more weight.\n\nConversations may open new paths, and people might start seeing things your way — if only just a little. Use this gift wisely... persuasion can be as powerful as any weapon." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


            elif current_talent_id == 1:
                
                text "Persuasion – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "Your voice carries greater confidence, and your arguments are sharper. You’re no longer just convincing — you’re compelling.\n\nAt this level, you can influence decisions more effectively, charm resistant characters, and occasionally steer conversations in your favor with ease. Words are no longer just tools — they’re your weapon." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


            
            elif current_talent_id == 2:
                
                text "Persuasion – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You've become a true master of words. With a glance or a few carefully chosen phrases, you can shift emotions, twist logic, and guide people exactly where you want them.\n\nEven the most stubborn minds can falter under your influence. At this level, your persuasion can unlock exclusive dialogue paths, manipulate outcomes, and bend the will of others to serve your goals." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


            
            elif current_talent_id == 3:
                
                text "Persuasion – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "Your words now carry the weight of absolute conviction. People listen, believe, and act — often without even realizing why. You don’t just persuade anymore — you reshape desires.\n\nAt this level, your presence alone can alter conversations, defuse conflicts, or spark decisions that change fates. Only the strongest minds can resist you now… and even they may waver." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5







            elif current_talent_id == 4:
                
                text "Seduction – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You’ve begun to tap into the power of desire. With a flirtatious smile or a well-timed glance, you can stir emotions and cloud judgment.\n\nAt this level, your seductive presence may sway hearts and open doors — figuratively and literally. It’s not just about beauty; it’s about knowing exactly when to use it." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 5:
                
                text "Seduction – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "Your charm has deepened — no longer just playful, but undeniably alluring. A touch, a look, even silence can now make hearts race.\n\nAt this level, seductive choices become more effective, especially in situations involving attraction, distraction, or manipulation through desire." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 6:
                
                text "Seduction – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You’ve refined seduction into an art. Your presence stirs fantasies, and your body language speaks louder than words. People want to please you — or at least stay close enough to try.\n\nAt this level, seduction can override logic, sway strong-willed characters, and open intimate or hidden paths that others would never see." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 7:
                
                text "Seduction – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You are irresistible. Every gesture feels deliberate, every glance loaded with promise. People don’t just want you — they need you.\n\nAt this level, your seductive power can break defenses, dominate interactions, and turn even enemies into admirers. You don’t chase — the world follows." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5








            elif current_talent_id == 8:
                
                text "Heracles – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You’ve begun shaping your body into something stronger, tougher. Muscles tighten, and each strike lands with more weight.\n\nAt this level, you gain a small bonus to physical attack and max health — a solid foundation for future might." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


            elif current_talent_id == 9:
                
                text "Heracles – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "Your physique grows noticeably more powerful. Your blows hit harder, and you can take more punishment without faltering.\n\nAttack and health are further increased, making you more resilient in both combat and survival." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 10:
                
                text "Heracles – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You now carry the presence of a true warrior. Your body is a weapon — forged through effort and endurance. Few can stand against your strength.\n\nMajor boosts to physical damage and health pool. Enemies may hesitate before testing your power." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 11:
                
                text "Heracles – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You’ve reached near-mythic strength. With every move, you radiate raw power. Your body withstands what would crush lesser beings, and your strikes can shatter armor — or bone.\n\nAt this level, you gain massive increases to physical attack and max health. You're no longer just strong — you're unstoppable." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5









            elif current_talent_id == 12:
                
                text "Love for Magic – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You’ve discovered a spark — a fascination with the arcane. Magic feels natural in your hands, and your will begins to shape reality.\n\nAt this level, you gain a small boost to magic attack and mana pool. You also unlock access to basic magical abilities." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


            elif current_talent_id == 13:
                
                text "Love for Magic – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "Your connection to the mystical deepens. Spells come more easily, and your mind becomes more resistant to outside influence.\n\nGrants a moderate increase to magic damage and mana reserves. You can now learn intermediate spells that others struggle to grasp." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 14:
                
                text "Love for Magic – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "Magic flows through you like a second bloodstream. Your will is sharp, your focus unshakable. Even the elements seem to answer your call.\n\nAt this level, you receive a major boost to magical power and mana capacity. Unlocks advanced magical abilities and improves spellcasting efficiency." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 15:
                
                text "Love for Magic – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You’ve become one with the arcane. Your presence distorts the air around you, and your power can bend reality itself.\n\nGrants a massive increase to magic attack and mana. You now have access to powerful, rare spells — and the will to control them." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5











            elif current_talent_id == 16:
                
                text "Craftsman’s Path – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You’ve learned the basics of crafting. With the right tools and a bit of patience, you can now create simple equipment and consumables.\n\nUnlocks basic crafting recipes: potions, basic gear, and utility items." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


            elif current_talent_id == 17:
                
                text "Craftsman’s Path – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "Your hands are steadier, your designs more refined. You now have the skill to forge reliable weapons and armor that can hold their own in battle.\n\nAllows crafting of improved weapons, armor, and useful trinkets with moderate stats." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 18:
                
                text "Craftsman’s Path – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You’ve begun weaving magic into your creations. Enchanted blades, spell-imbued scrolls, and arcane tools are now within your grasp.\n\nGrants access to magical crafting: enchanted gear, scrolls, and specialty items with magical properties." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 19:
                
                text "Craftsman’s Path – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You are a true master of the forge and the arcane bench. With rare materials and ancient knowledge, you can now create legendary artifacts — unique and unmatched.\n\nEnables crafting of legendary weapons, powerful gear, and rare one-of-a-kind magical items. Your craftsmanship can change the fate of kingdoms." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5







            elif current_talent_id == 20:
                
                text "Gatherer – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You’ve developed an eye for useful things. Herbs, ore, and common materials no longer go unnoticed.\n\nGrants a small bonus to gathering efficiency and increases the chance of finding basic resources." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


            elif current_talent_id == 21:
                
                text "Gatherer – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "Your hands are swift, and your instincts sharper. You gather faster and lose less in the process.\n\nImproves yield from resource nodes and increases the chance of collecting rare components." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 22:
                
                text "Gatherer – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You know where to look — and how to make the most of every trip. Even magical creatures seem to yield more under your touch.\n\nGrants significant boosts to gathering quantity and unlocks chances to find magical or uncommon materials." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 23:
                
                text "Gatherer – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You are a master of the wild harvest. The land seems to respond to your presence, offering up its finest treasures.\n\nMassively increases resource yield and greatly improves chances of obtaining rare and legendary materials. Every expedition becomes a profitable venture." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5








            elif current_talent_id == 24:
                
                text "Thief – Level 1" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You’ve learned the basics of stealth and sleight of hand. You can now pick simple pockets and quietly lift unattended items.\n\nAllows low-risk theft from NPCs and small chests. Slight increase in gold and loot found during exploration." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5


            elif current_talent_id == 25:
                
                text "Thief – Level 2" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "Your fingers are quicker, your movements smoother. Locks and distractions no longer intimidate you.\n\nUnlocks moderate-level pickpocketing, chest unlocking, and improves the chance to steal rare items or gold unnoticed." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 26:
                
                text "Thief – Level 3" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You’ve become a shadow in plain sight. Even guarded belongings are not safe when you’re nearby.\n\nGrants access to high-risk, high-reward thefts, including stealing from nobles or guarded storages. Greatly increases loot and gold gain from theft and exploration." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5



            elif current_talent_id == 27:
                
                text "Thief – Level 4" font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xalign 0.71 ypos 120 color "#c8a055" size 36 text_align 1.0

                text "You are the stuff of whispered legends. Locks mean nothing, guards are blind, and riches flow to your hands as if by fate.\n\nAllows stealing legendary items, bypassing magical protections, and extracting maximum gold from every opportunity. You don’t just take — you own the shadows." font "gui/fonts/TMR_Regular.ttf" xmaximum 550 xpos 1020 ypos 210 color "#c8a055" size 26 text_align 0.5










    imagebutton xalign 0.998 yalign 0.01:
        idle "images/quests/buttons/exit.png"
        hover im.MatrixColor('images/quests/buttons/exit.png', im.matrix.brightness(0.2))
        mouse 'pointer'
        
        if current_profile_menu != 0:
            action [
                SetVariable('current_profile_menu', 0)
            ]

        else:
            if current_dialogue == 80:
                action [
                    Hide('profile_menu'),
                    Jump('Part3_8_3')
                ]

            else:
                action [
                    SetVariable("ap_available_cur", ap_available),
                    SetVariable("MC_Strength_Cur", MC_Strength),
                    SetVariable("MC_Dexterity_Cur", MC_Dexterity),
                    SetVariable("MC_Magic_Cur", MC_Magic),
                    SetVariable("MC_Willpower_Cur", MC_Willpower),
                    SetVariable("MC_Cunning_Cur", MC_Cunning),
                    SetVariable("MC_Body_Cur", MC_Body),


                    Hide('profile_menu')
                ]
        


    key "K_ESCAPE":

        if current_profile_menu != 0:
            action [
                SetVariable('current_profile_menu', 0)
            ]

        else:
            if current_dialogue == 80:
                action [
                    Hide('profile_menu'),
                    Jump('Part3_8_3')
                ]

            else:
                action [
                    SetVariable("ap_available_cur", ap_available),
                    SetVariable("MC_Strength_Cur", MC_Strength),
                    SetVariable("MC_Dexterity_Cur", MC_Dexterity),
                    SetVariable("MC_Magic_Cur", MC_Magic),
                    SetVariable("MC_Willpower_Cur", MC_Willpower),
                    SetVariable("MC_Cunning_Cur", MC_Cunning),
                    SetVariable("MC_Body_Cur", MC_Body),


                    Hide('profile_menu')
                ]