label mall:

    $ set_location_by_id('mall')

    call storylines_checker from _call_storylines_checker_20

    scene mall

    menu mall_choice:

        "Grocery Store":

            jump grocery_mall

        "Electronics Store":

            jump electro_mall


        "Clothing Store" if wife_storyline_step > 30:

            jump clothes_mall


        "Gift Shop":

            mc "I don’t need to go there right now"

            jump mall


        "Sex Shop":

            mc "I don’t need to go there right now"

            jump mall


        "Leave":

            show screen map_icon



    window hide
    $ renpy.pause()

return
















label grocery_mall:

    show screen grocery_mall_screen

    window hide
    $ renpy.pause()

return





screen grocery_mall_screen:

    modal True
    add "images/mall/store_shalve.png" xalign 0.0 yalign 0.0
    use money_screen

    hbox xpos 310 yalign 0.10:

        spacing 60

        # Вино
        hbox yalign 1.0:
            imagebutton yalign 1.0:
                idle "images/mall/wine.png"
                hover im.MatrixColor('images/mall/wine.png', im.matrix.brightness(0.2))
                mouse 'pointer'

                if mc_money >= 99: 
                    action [
                        Function(add_item, "wine", 1),   # например, покупка
                        SetVariable('mc_money', mc_money-99)
                        ]
                else:
                    action Function(renpy.notify, "You don’t have enough money to buy this")

            null width -35
            frame yalign 1.0:
                background None
                text "[inv_count('wine')]" font "gui/fonts/TMR.ttf" size 52 color "#fbd389" ypos -40 xalign 1 outlines [(2, "#000000", 0, 0)]

        # Виноград
        hbox yalign 1.0:
            imagebutton yalign 1.0:
                idle "images/mall/grape.png"
                hover im.MatrixColor('images/mall/grape.png', im.matrix.brightness(0.2))
                mouse 'pointer'

                if mc_money >= 7: 
                    action [
                        Function(add_item, "grape", 1),   # например, покупка
                        SetVariable('mc_money', mc_money-7)
                        ]
                else:
                    action Function(renpy.notify, "You don’t have enough money to buy this")

            null width -35
            frame yalign 1.0:
                background None
                text "[inv_count('grape')]" font "gui/fonts/TMR.ttf" size 52 color "#fbd389" ypos -40 xalign 1 outlines [(2, "#000000", 0, 0)]







    imagebutton yalign 0.88 xalign 0.5:
        idle "images/mall/leave.png"
        hover im.MatrixColor('images/mall/leave.png', im.matrix.brightness(0.2))
        mouse 'pointer'
        action [
            Hide('grocery_mall_screen'),
            Jump('mall')
        ]


    key "K_ESCAPE":

        action [
            Hide('grocery_mall_screen'),
            Jump('mall')
        ]


























label electro_mall:

    show screen electro_mall_screen

    window hide
    $ renpy.pause()

return




screen electro_mall_screen:

    modal True
    add "images/mall/store_shalve.png" xalign 0.0 yalign 0.0
    use money_screen

    hbox xpos 310 yalign 0.16:

        spacing 60



        # VR
        hbox yalign 1.0:
            imagebutton yalign 1.0:
                idle "images/mall/vr.png"
                hover im.MatrixColor('images/mall/vr.png', im.matrix.brightness(0.2))
                mouse 'pointer'

                if mc_money >= 1500: 
                    action [
                        Function(add_item, "vr", 1),   # например, покупка
                        SetVariable('mc_money', mc_money-1500)
                        ]
                else:
                    action Function(renpy.notify, "You don’t have enough money to buy this")

            null width -35
            frame yalign 1.0:
                background None
                text "[inv_count('vr')]" font "gui/fonts/TMR.ttf" size 52 color "#fbd389" ypos -40 xalign 1 outlines [(2, "#000000", 0, 0)]




        if spy_camera_available == 1:


            # SPY Camera
            hbox yalign 1.0:
                imagebutton yalign 1.0:
                    idle "images/mall/spy_camera.png"
                    hover im.MatrixColor('images/mall/spy_camera.png', im.matrix.brightness(0.2))
                    mouse 'pointer'

                    if mc_money >= 1000: 
                        action [
                            Function(add_item, "spy_camera", 1),   # например, покупка
                            SetVariable('mc_money', mc_money-1000)
                            ]
                    else:
                        action Function(renpy.notify, "You don’t have enough money to buy this")

                null width -35
                frame yalign 1.0:
                    background None
                    text "[inv_count('spy_camera')]" font "gui/fonts/TMR.ttf" size 52 color "#fbd389" ypos -40 xalign 1 outlines [(2, "#000000", 0, 0)]




    imagebutton yalign 0.88 xalign 0.5:
        idle "images/mall/leave.png"
        hover im.MatrixColor('images/mall/leave.png', im.matrix.brightness(0.2))
        mouse 'pointer'
        action [
            Hide('electro_mall_screen'),
            Jump('mall')
        ]

    key "K_ESCAPE":

        action [
            Hide('electro_mall_screen'),
            Jump('mall')
        ]































label clothes_mall:

    show screen clothes_mall_screen

    window hide
    $ renpy.pause()

return







# =========================
# Инициализация и хелперы
# =========================
init python:
    def page_scroll_x(adj, screen_name, vp_id, step_px=1920):
        """
        Жёсткий шаг по X на step_px. Сразу форсим перерисовку именно того viewport,
        чтобы обновление произошло немедленно (не ждать ухода курсора).
        """
        rng = adj.range or 0
        new_v = adj.value + step_px
        if new_v < 0:
            new_v = 0
        elif rng and new_v > rng:
            new_v = rng
        adj.value = new_v

        # Находим viewport по id и перерисовываем
        try:
            w = renpy.get_widget(screen_name, vp_id)
            if w:
                renpy.redraw(w, 0)
        except Exception:
            pass

        renpy.restart_interaction()

# Состояние
default vp_x = ui.adjustment()






default dresses = [("dress_1", 250), ("dress_2", 200), ("dress_3", 500), ("dress_4", 750)]



# =========================
# Экран магазина одежды
# =========================
screen clothes_mall_screen:

    modal True

    add "images/mall/clothes_back.png" xalign 0.0 yalign 0.0
    use money_screen

    # ВАЖНО: никаких таймеров с restart_interaction во время нажатия — они мешают интеракции

    window background None:
        area (0, 0, 1920, 1080)

        viewport id "shop_vp":      # <- даём id, чтобы форсить перерисовку адресно
            xadjustment vp_x
            ymaximum 1080           # по Y фикс
            draggable False         # отключил, чтобы не было гонок с кликами (включишь при желании)
            mousewheel False
            pagekeys False
            side_yfill True

            hbox xminimum 1920 yminimum 1080:
                
                hbox xalign 0.5 yalign 0.4:
                    
                    spacing 60
                
                    for item_id, price in dresses:

                        $ owned = inv_count(item_id) > 0
                        $ idle_img = "images/mall/clothes/{}_sold.png".format(item_id) if owned else "images/mall/clothes/{}.png".format(item_id)
                        $ hover_img = idle_img if owned else im.MatrixColor(idle_img, im.matrix.brightness(0.2))

                        imagebutton:
                            idle idle_img
                            hover hover_img
                            mouse 'pointer'
                            sensitive not owned           # отключаем ховеры/клики, если уже куплено

                            if owned:
                                action NullAction()
                            else:
                                if mc_money >= price:
                                    action [ Function(add_item, item_id, 1),
                                            SetVariable('mc_money', mc_money - price) ]
                                else:
                                    action Function(renpy.notify, "You don’t have enough money to buy this")

                    

    # Кнопки: строго по 1920 пикселей. Обрати внимание — НИКАКОГО 1220.
    textbutton "←" xpos 0 ypos 460 text_size 142 text_outlines [(2, "#000000", 0, 0)] mouse 'pointer':
        action Function(page_scroll_x, vp_x, "clothes_mall_screen", "shop_vp", -1920)

    textbutton "→" xpos 1760 ypos 460 text_size 142 text_outlines [(2, "#000000", 0, 0)] mouse 'pointer':
        action Function(page_scroll_x, vp_x, "clothes_mall_screen", "shop_vp", +1920)

    # Выход
    imagebutton yalign 0.93 xalign 0.5:
        idle "images/mall/leave.png"
        hover im.MatrixColor('images/mall/leave.png', im.matrix.brightness(0.2))
        mouse 'pointer'
        action [ Hide('clothes_mall_screen'), Jump('mall') ]
        


    key "K_ESCAPE":

        action [ Hide('clothes_mall_screen'), Jump('mall') ]























default inventory = {
    "wine": 0,
    "grape": 0,
    "candy": 0,

    "dress_1": 0,
    "dress_2": 0,
    "dress_3": 0,
    "dress_4": 0,
    "dress_5": 0,

    "camera": 0,
    "spy_camera": 0,

    "vr": 0,

    
    "flower_1": 0,
    "flower_2": 0,

    
    "sex_toy_1": 0,
}



init python:
    def inv_count(item_id):
        return inventory.get(item_id, 0)

    def add_item(item_id, amount=1):
        inventory[item_id] = inventory.get(item_id, 0) + amount

    def remove_item(item_id, amount=1):
        if inventory.get(item_id, 0) >= amount:
            inventory[item_id] -= amount
        # Можно добавить else с сообщением, если хочешь запрещать удаление при 0