screen char_info_icon:

    imagebutton xalign 0.0 yalign 0.06:
        idle "images/char_info.png"
        hover im.MatrixColor('images/char_info.png', im.matrix.brightness(0.3))
        action Show('quest_info_window')
        mouse 'pointer'





screen char_info_window:

    modal True


    add "images/char_info/background.png"



    vbox xalign 0.47 yalign 0.74:

        spacing 20

        hbox xminimum 440:
            
            text "Name: " size 44 color "#fff"

            text "[mc_name]" size 44 color "#fff" xalign 1.0

        hbox xminimum 440:
            
            text "Age: " size 44 color "#fff"

            text "18" size 44 color "#fff" xalign 1.0

        hbox xminimum 440:
            
            text "Cheating: " size 44 color "#fff"

            text "[mc_cheating] point(s)" size 44 color "#fff" xalign 1.0

        hbox xminimum 440:
            
            text "Money: " size 44 color "#fff"

            text "$ [mc_money]" size 44 color "#fff" xalign 1.0


    add "images/mc/mc_school_0.png" xzoom -1 xalign 1.1 yalign 1.0



    add "images/char_info/background_2.png"






    



    imagebutton xalign 0.998 yalign 0.01:
        idle "images/quests/buttons/exit.png"
        hover im.MatrixColor('images/quests/buttons/exit.png', im.matrix.brightness(0.2))
        mouse 'pointer'
        
        action [
                Hide('char_info_window')
            ]
        


    key "K_ESCAPE":

        action [
                Hide('char_info_window')
            ]











default current_quest = None

screen quest_info_window:

    modal True


    add "images/char_info/background.png"




    vbox xpos 100 ypos 120:

        spacing 15


        for s in storylines.values():
            textbutton s.name:
                text_font "gui/fonts/TMR.ttf"
                text_size 42
                mouse 'pointer'
                action SetVariable('current_quest', s)

        

        # textbutton "[wife_name] & MC quest" text_font "gui/fonts/TMR.ttf" text_size 42 mouse 'pointer' action NullAction()

        # textbutton "Mom's Job quest" text_font "gui/fonts/TMR.ttf" text_size 42 mouse 'pointer' action NullAction()

        # textbutton "Rick's quest" text_font "gui/fonts/TMR.ttf" text_size 42 mouse 'pointer' action NullAction()

        # textbutton "Jamal quest" text_font "gui/fonts/TMR.ttf" text_size 42 mouse 'pointer' action NullAction()

        # textbutton "Sis & MC quest" text_font "gui/fonts/TMR.ttf" text_size 42 mouse 'pointer' action NullAction()

        # textbutton "MC's Boss quest" text_font "gui/fonts/TMR.ttf" text_size 42 mouse 'pointer' action NullAction()


    # add "images/wife/school_normal.png" xalign 0.45 yalign 1.0




    if current_quest != None:


        text current_quest.desc xsize 600 font "gui/fonts/Kurale.ttf" color "#000" size 28 xpos 1040 ypos 110

        vbox xpos 1040 ypos 660:

            spacing -5
            text "Current step: {color=#2d2673}[current_quest.step]" xsize 600 font "gui/fonts/Kurale.ttf" color "#000" size 30

            if current_quest.name == "Brotherhood" and current_quest.step == 13:
                text "End of Content" xsize 600 font "gui/fonts/Kurale.ttf" color "#000" size 30
            elif current_quest.name == "Blood Ties" and current_quest.step == 16:
                text "End of Content" xsize 600 font "gui/fonts/Kurale.ttf" color "#000" size 30
            elif current_quest.name == "Love and Loyalty" and current_quest.step == 34:
                text "End of Content" xsize 600 font "gui/fonts/Kurale.ttf" color "#000" size 30
            elif current_quest.name == "The Working Mother" and current_quest.step == 18:
                text "End of Content" xsize 600 font "gui/fonts/Kurale.ttf" color "#000" size 30
            else:
                text "Location: {color=#2d2673}[get_location_title_by_id(current_quest.location)]" xsize 600 font "gui/fonts/Kurale.ttf" color "#000" size 30
                text "Day of the week: {color=#2d2673}[current_quest.day]" xsize 600 font "gui/fonts/Kurale.ttf" color "#000" size 30
                text "Time of day: {color=#2d2673}[current_quest.daytime]" xsize 600 font "gui/fonts/Kurale.ttf" color "#000" size 30
                text "Days until activation: {color=#2d2673}[current_quest.days_need]" xsize 600 font "gui/fonts/Kurale.ttf" color "#000" size 30



    add "images/char_info/background_2.png"
    





    imagebutton xalign 0.998 yalign 0.01:
        idle "images/quests/buttons/exit.png"
        hover im.MatrixColor('images/quests/buttons/exit.png', im.matrix.brightness(0.2))
        mouse 'pointer'
        
        action [
                Hide('quest_info_window')
            ]
        


    key "K_ESCAPE":

        action [
                Hide('quest_info_window')
            ]

















init python:


    from renpy import store

    def get_location_title_by_id(loc_id):
        """Вернуть title по id из списка locations. Работает даже если locations ещё нет."""
        if not loc_id:
            return None
        locs = getattr(store, "locations", None)
        if not locs:            # locations ещё не определён → вернём то, что дали (id или уже title)
            return loc_id
        for loc in locs:
            if loc.get("id") == loc_id:
                return loc.get("title", loc_id)
        return loc_id




    class Storyline(object):
        def __init__(self, name, desc="",
                     step=0, day="All", daytime="All",
                     location=None, days_need=0):
            self.name = name                # название
            self.desc = desc                # описание

            # текущие параметры прогресса
            self.step = step
            self.day = day
            self.daytime = daytime
            # location можно сразу передать как id или title
            self.location = get_location_title_by_id(location) if location else None
            self.days_need = days_need


        def advance(self, step=1, day="All", daytime="All", location=None, days_need=0):
            """Сохраняем шаг и данные. location можно передавать как id или title."""
            self.step = step
            self.day = day
            self.daytime = daytime
            self.days_need = days_need

            if location:
                self.location = get_location_title_by_id(location)


        def set_desc(self, new_desc):
            """Меняем описание линии."""
            self.desc = new_desc







default storylines = {

    "wife": Storyline("Love and Loyalty", "Right now, everything is going well for me. I’m happy that [wife_name] is my girlfriend. And I’m glad that she is exactly the way she is. I hope that soon something more will happen between us, and we’ll… well, time will tell. For now, I’ll just enjoy the time we spend together.",
                        step=0, day="Sunday", daytime="Evening", location="My Room", days_need=0),

    "mom":  Storyline("The Working Mother", "Mom has been working so much ever since Dad lost his job. And it bothers me. I don’t want everything to fall on her shoulders. Dad should start working again too. Maybe I can help her somehow. If only I had a decent job myself…",
                        step=0, day="All", daytime="Morning", location="Kitchen", days_need=2),

    "sis":  Storyline("Blood Ties", "It feels like I’ve grown a bit distant from my sister lately. I should probably fix that. I’ll try to be a more… caring brother. I think [sis_name] will like that. She’s a good sister, even if she can be a real pain in the ass sometimes.",
                        step=0, day="Friday", daytime="Day", location="Living Room", days_need=0),

    "rick": Storyline("Brotherhood", "Rick… Rick is someone whose plans are never really known. Not because he hides them, but because he just doesn’t have any. I don’t know why we’re still friends, but we are — and it’s actually a really good friendship. I just hope our bond keeps getting stronger.",
                        step=0, day="All", daytime="Evening", location="Work Locker Room", days_need=3),

}
