
define MC_Name = "Dorian"
define Mom = "Mom"
define nvl_mode = "phone"
define Claire = "Claire"
define Shad = "Shad"
define John  = "John"
define Aura = "Aura"
define kate = "Kate"
define William = "William"
define daniel = "Daniel"
define Emma = "Emma"
define Megan = "Megan"
define Victor = "Victor"
define Louis = "Louis"
define Boss = "Boss"
define Chloe = "Chloe"
define Harper = "Harper"
define Logan = "Logan"
init -1 python:
    phone_position_x = 0.3
    phone_position_y = 0.5
    # Character callback ; Play a sound when a message is received
    def Phone_ReceiveSound(event, interact=True, **kwargs):
        if event == "show_done":
            renpy.sound.play("audio/ReceiveText.ogg")
    def Phone_SendSound(event, interact=True, **kwargs):
        if event == "show_done":
            renpy.sound.play("audio/SendText.ogg")

screen PhoneDialogue(dialogue, items=None):

    style_prefix "phoneFrame"

    vbox:
        spacing 0
        # Messenger screen
        frame:
            # ysize 0.85
            if len(items)>=2:
                ysize 1632-(len(items)-2)*(120+10)-20
            else:
                ymaximum 1632
            viewport:
                draggable True
                mousewheel True
                # cols 1
                yinitial 1.0
                # scrollbars "vertical"
                vbox:
                    xalign 0.5
                    null height 20
                    use nvl_phonetext(dialogue,items)
                    null height -100
        # Button to progress
        if len(items)==0: #If we don't have a menu
            button:
                padding (0,0)
                #add Solid("#ffffffff")
                add Transform("continue_btn.png", align=(0.5,0.2))
                text "CLick here to continue..." size 50 yalign 0.8 xalign 0.5 font "fonts/TerminalDosis-ExtraBold.ttf"
                imagebutton auto "images/settings_%s.png" action ShowMenu("preferences")
                imagebutton auto "images/mainmenu_%s.png" action MainMenu() xalign 1.0 yalign 1.0
                imagebutton auto "images/save_%s.png" action ShowMenu("save") xalign 1.0
                action RollForward()
        else:
            # Phone Menu Choice
            frame:
                background None #Solid("#3b373700")
                foreground None

                vbox:
                    yalign 0.5
                    for i in items: #For each choices...
                        button:
                            action i.action
                            xalign 0.5
                            frame:
                                background None
                                
                                foreground None
                                xysize (1020,120)

                                text i.caption:
                                    align (0.5,0.5)
                                    text_align 0.5
                                    size 60
                            # style "nvl_button"

# The actual messenger screen
screen nvl_phonetext(dialogue,items):
    style_prefix None

    $ previous_d_who = None
    for id_d, d in enumerate(dialogue):
        if d.who == None: # If it's the narrator talking
            null height 30
            text d.what:
                    xalign 0.5
                    ypos 0.0
                    xsize 650
                    text_align 0.5
                    italic True
                    size 45
                    color "#fff"
                    font "fonts/TerminalDosis-Bold.ttf"
                    outlines [(3, "#000000", 0, 0)]
                    slow_cps False
                    id d.what_id
                    if d.current and len(items)==0:
                        at message_narrator
            null height 30
        else:
            if d.who == mc_name: # Use dynamic name
                $ message_frame = "phone_send_frame.png"
            else:
                $ message_frame = "phone_received_frame.png"

            hbox:
                spacing 10
                if d.who == mc_name:
                    box_reverse True
                    xalign 1.0
                
                #If this is the first message of the character, show an icon
                if previous_d_who != d.who:
                    if previous_d_who != d.who:
                        if d.who == mc_name:
                            $ message_icon = "mc.png"
                        elif d.who == Claire:
                            $ message_icon = "claire.png"
                        elif d.who == Mom:
                            $ message_icon = "mae.png"
                        elif d.who == Shad:
                            $ message_icon = "Shad.png"
                        elif d.who == Aura:
                            $ message_icon = "aura.png"
                        elif d.who == kate:
                            $ message_icon = "Kate.png"
                        elif d.who == Megan:
                            $ message_icon = "meg.png"
                        elif d.who == Emma:
                            $ message_icon = "emma.png"
                        elif d.who == Boss:
                            $ message_icon = "chefe.png"
                        elif d.who == William:
                            $ message_icon = "william.png"
                        elif d.who == daniel:
                            $ message_icon = "daniel.png"
                        elif d.who == Louis:
                            $ message_icon = "Louis.png"
                        elif d.who == Victor:
                            $ message_icon = "victor.png"
                        elif d.who == Logan:
                            $ message_icon = "logan.png"
                        elif d.who == Harper:
                            $ message_icon = "harper.png"
                        elif d.who == Chloe:
                            $ message_icon = "chloe.png"
                        else:
                            $ message_icon = "phone_received_icon.png"

                    add message_icon:
                        if d.current  and len(items)==0:
                            at message_appear_icon()
                        
                else:
                    null width 107

                vbox:
                    yalign 1.0
                    
                    if d.who != "[mc_name]" and previous_d_who != d.who:
                        text d.who:
                            size 50

                    frame:
                        padding (20,20)
                        background Frame(message_frame, 23,23,23,23)
                        # xsize 750

                        if d.current and len(items)==0:
                            if d.who == "[mc_name]": # Use dynamic name
                                at message_appear(1)
                            else:
                                at message_appear(-1)

                        text d.what:
                            pos (0,0)
                            # xsize 750
                            slow_cps False
                            size 45
                            if d.who == "[mc_name]": # Use dynamic name
                                color "#FFF"
                                outlines [(3, "#000000", 0, 0)]
                                font "fonts/NationalPark-Bold.ttf"
                                text_align 1.0
                                xanchor 1.0
                                xpos 1.0
                            else:
                                color "#ffffff"
                                outlines [(3, "#000000", 0, 0)]
                                font "fonts/NationalPark-Bold.ttf"
                            id d.what_id
        $ previous_d_who = d.who
                    
style phoneFrame is default

style phoneFrame_frame:
    background "phone_background.png"
    foreground "phone_foreground.png"
    
    yfill True
    xfill True
    # ysize 815
    # xsize 495

    padding (20,0)

style phoneFrame_viewport:
    yfill True
    xfill True

    # yoffset -20

style phoneFrame_vbox:
    spacing 10
    xfill True

transform phone_transform(pXalign=0.5, pYalign=0.5):
    xcenter pXalign
    yalign pYalign

transform phone_appear(pXalign=0.5, pYalign=0.5): #Used only when the dialogue have one element
    xcenter pXalign
    yalign pYalign

    on show:
        yoffset 1080
        easein_back 1.0 yoffset 0

transform resize_image:
    zoom 0.5
    
transform message_appear(pDirection):
    alpha 0.0
    xoffset 50 * pDirection
    parallel:
        ease 0.5 alpha 1.0
    parallel:
        easein_back 0.5 xoffset 0

transform message_appear_icon():
    zoom 0.0
    easein_back 0.5 zoom 1.0
    

transform message_narrator:
    alpha 0.0
    yoffset -50

    parallel:
        ease 0.5 alpha 1.0
    parallel:
        easein_back 0.5 yoffset 0