/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modsupport.packs;

import com.wurmonline.client.WurmClientBase;
import com.wurmonline.client.renderer.PlayerBodyRenderable;
import com.wurmonline.client.renderer.cell.CellRenderable;
import com.wurmonline.client.renderer.cell.CellRenderer;
import com.wurmonline.client.renderer.cell.PlayerCellRenderable;
import com.wurmonline.client.resources.ResourceUrl;
import com.wurmonline.client.resources.Resources;
import com.wurmonline.client.resources.textures.IconLoader;
import com.wurmonline.client.resources.textures.ResourceTextureLoader;
import com.wurmonline.shared.constants.IconConstants;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import org.gotti.wurmunlimited.modloader.ReflectionUtil;
import org.gotti.wurmunlimited.modloader.classhooks.HookException;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;
import org.gotti.wurmunlimited.modsupport.ModClient;
import org.gotti.wurmunlimited.modsupport.packs.ArmorLoader;
import org.gotti.wurmunlimited.modsupport.packs.MapsLoader;

public class ModPacks {
    private static Logger logger = Logger.getLogger(ModPacks.class.getName());
    private static Class<?> jarPackClass;
    private static Constructor<?> jarPackConstructor;
    private static Method jarPackInit;
    private static Method jarPackGetResource;
    private static Field resourceResolvedResources;
    private static Field resourcesUnresolvedResources;
    private static Field resourcesPacks;
    private static Field cellRendererTickRenderables;
    private static Field playerCellRenderableTextureDirty;
    private static Field playerBodyRenderableTextureDirty;

    public static void preInit() {
        try {
            ClassPool classPool = HookManager.getInstance().getClassPool();
            ExprEditor modArmorDeriveEditor = new ExprEditor(){

                @Override
                public void edit(MethodCall m) throws CannotCompileException {
                    if ("com.wurmonline.client.resources.ResourceUrl".equals(m.getClassName()) && "derive".equals(m.getMethodName())) {
                        StringBuilder code = new StringBuilder();
                        code.append("{\n");
                        code.append("\tcom.wurmonline.client.resources.ResourceUrl res = org.gotti.wurmunlimited.modsupport.packs.ModArmor.getArmorTexture($$);\n");
                        code.append("\t$_ = res != null ? res : $proceed($$);\n");
                        code.append("}\n");
                        m.replace(code.toString());
                    }
                }
            };
            classPool.get("com.wurmonline.client.resources.textures.PlayerTextureBuilderGL").getMethod("generateTexture", Descriptor.ofMethod(CtPrimitiveType.voidType, new CtClass[0])).instrument(modArmorDeriveEditor);
            classPool.get("com.wurmonline.client.renderer.cell.PlayerTexture$PlayerBodyTextureLoader").getMethod("run", Descriptor.ofMethod(CtPrimitiveType.voidType, new CtClass[0])).instrument(modArmorDeriveEditor);
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new HookException(e);
        }
    }

    public static void init() {
        try {
            jarPackClass = Class.forName("com.wurmonline.client.resources.JarPack");
            jarPackConstructor = jarPackClass.getDeclaredConstructor(File.class);
            jarPackInit = jarPackClass.getSuperclass().getDeclaredMethod("init", Resources.class);
            jarPackGetResource = jarPackClass.getSuperclass().getDeclaredMethod("getResource", String.class);
            resourceResolvedResources = ReflectionUtil.getField(Resources.class, "resolvedResources");
            resourcesUnresolvedResources = ReflectionUtil.getField(Resources.class, "unresolvedResources");
            resourcesPacks = ReflectionUtil.getField(Resources.class, "packs");
            cellRendererTickRenderables = ReflectionUtil.getField(CellRenderer.class, "tickRenderables");
            playerBodyRenderableTextureDirty = ReflectionUtil.getField(PlayerBodyRenderable.class, "textureDirty");
            playerCellRenderableTextureDirty = ReflectionUtil.getField(PlayerCellRenderable.class, "textureDirty");
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new HookException(e);
        }
    }

    public static Set<Options> getOptionSet(Options[] options) {
        if (options == null || options.length == 0) {
            return Collections.emptySet();
        }
        return EnumSet.copyOf(Arrays.asList(options));
    }

    public static boolean addPack(File jarFile, Options ... options) {
        Set<Options> o = ModPacks.getOptionSet(options);
        try {
            Object jarPack = ModPacks.initPack(jarFile);
            ModPacks.addPack(jarPack, o);
            ModPacks.updateServerData(jarPack, o);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object initPack(File file) throws SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean contructorWasAccessible = jarPackConstructor.isAccessible();
        boolean initWasAccessible = jarPackInit.isAccessible();
        try {
            jarPackConstructor.setAccessible(true);
            jarPackInit.setAccessible(true);
            Resources resources = WurmClientBase.getResourceManager();
            Object jarPack = jarPackConstructor.newInstance(file);
            jarPackInit.invoke(jarPack, resources);
            Object obj = jarPack;
            return obj;
        }
        finally {
            jarPackInit.setAccessible(initWasAccessible);
            jarPackConstructor.setAccessible(contructorWasAccessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPack(Object jarPack, Set<Options> options) throws IllegalArgumentException, IllegalAccessException, ClassCastException {
        Resources resources = WurmClientBase.getResourceManager();
        List packs = (List)ReflectionUtil.getPrivateField(resources, resourcesPacks);
        Resources resources2 = resources;
        synchronized (resources2) {
            if (options.contains((Object)Options.PREPEND)) {
                packs.add(0, jarPack);
            } else {
                packs.add(jarPack);
            }
            if (!options.contains((Object)Options.NORELOAD)) {
                ModPacks.reloadPacks();
            }
        }
    }

    private static void reloadPacks() throws IllegalArgumentException, IllegalAccessException, ClassCastException {
        Resources resources = WurmClientBase.getResourceManager();
        Set unresolved = (Set)ReflectionUtil.getPrivateField(resources, resourcesUnresolvedResources);
        Map resolved = (Map)ReflectionUtil.getPrivateField(resources, resourceResolvedResources);
        HashMap oldResolved = new HashMap(resolved);
        unresolved.clear();
        resolved.clear();
        boolean reloadIcons = false;
        for (Map.Entry entry : oldResolved.entrySet()) {
            ResourceUrl oldUrl = (ResourceUrl)entry.getValue();
            ResourceUrl newUrl = resources.getResource((String)entry.getKey());
            if (newUrl == null || newUrl.equals((Object)oldUrl)) continue;
            if (Arrays.asList(IconConstants.ICON_SHEET_FILE_NAMES).contains(entry.getKey())) {
                reloadIcons = true;
                continue;
            }
            ResourceTextureLoader.reload((ResourceUrl)oldUrl, (ResourceUrl)newUrl);
        }
        if (reloadIcons) {
            IconLoader.initIcons();
            IconLoader.clear();
        }
    }

    private static void updateServerData(Object jarPack, Set<Options> options) {
        if (!options.contains((Object)Options.NOMAPS)) {
            ModPacks.updateMaps(jarPack);
        }
        if (!options.contains((Object)Options.NOARMOR)) {
            ModPacks.updateArmor(jarPack);
        }
    }

    public static ResourceUrl getResource(Object jarPack, String resourceName) {
        try {
            return (ResourceUrl)ReflectionUtil.callPrivateMethod(jarPack, jarPackGetResource, resourceName);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private static void updateMaps(Object jarPack) {
        ResourceUrl mapsUnlimited = ModPacks.getResource(jarPack, "mapunlimited");
        if (mapsUnlimited != null) {
            new MapsLoader().load(mapsUnlimited);
        }
    }

    private static void updateArmor(Object jarPack) {
        ResourceUrl armor = ModPacks.getResource(jarPack, "armor.xml");
        if (armor != null) {
            new ArmorLoader().load(armor);
            ModPacks.refreshPlayerModels();
        }
    }

    public static void refreshPlayerModels() {
        try {
            CellRenderer cellRenderer = ModClient.getWorld().getCellRenderer();
            List renderables = (List)ReflectionUtil.getPrivateField(cellRenderer, cellRendererTickRenderables);
            if (renderables != null) {
                for (CellRenderable renderable : renderables) {
                    if (renderable instanceof PlayerCellRenderable) {
                        ReflectionUtil.setPrivateField(renderable, playerCellRenderableTextureDirty, true);
                    }
                    if (!(renderable instanceof PlayerBodyRenderable)) continue;
                    ReflectionUtil.setPrivateField(renderable, playerBodyRenderableTextureDirty, true);
                }
            }
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new HookException(e);
        }
    }

    public static enum Options {
        PREPEND,
        NORELOAD,
        NOMAPS,
        NOARMOR;

    }
}

