/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modsupport.packs;

import com.wurmonline.client.renderer.cell.ArmorMeshData;
import com.wurmonline.client.renderer.cell.ArmorXmlParser;
import com.wurmonline.client.resources.ResourceUrl;
import com.wurmonline.shared.xml.XmlNode;
import com.wurmonline.shared.xml.XmlParser;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gotti.wurmunlimited.modsupport.ModClient;
import org.gotti.wurmunlimited.modsupport.packs.ModArmor;

public class ArmorLoader {
    private static Logger logger = Logger.getLogger(ArmorLoader.class.getName());

    public void load(ResourceUrl armor) {
        if (ModClient.getWorld().getArmorMeshDataList() == null) {
            ModClient.getWorld().setArmorMeshDataList(ArmorXmlParser.parse());
        }
        XmlNode rootNode = null;
        try (InputStream input = armor.openStream();){
            rootNode = XmlParser.parse((InputStream)input);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (rootNode != null) {
            Map armorData = ModClient.getWorld().getArmorMeshDataList();
            List categorys = rootNode.getChildren();
            for (XmlNode categoryNode : categorys) {
                List items = categoryNode.getChildren();
                for (XmlNode itemNode : items) {
                    String itemName = itemNode.getName();
                    List kingdom = itemNode.getChildren();
                    for (XmlNode kingdomNode : kingdom) {
                        String kingdomName = kingdomNode.getName();
                        List genders = kingdomNode.getChildren();
                        for (XmlNode genderNode : genders) {
                            String[] meshTextureNames;
                            String[] texturePlaces;
                            String[] meshNames;
                            String genderName = genderNode.getName();
                            String[] meshPlaces = ArmorLoader.getValueFromXmlTag(genderNode, "meshPlace");
                            if (meshPlaces.length != (meshNames = ArmorLoader.getValueFromXmlTag(genderNode, "meshName")).length) {
                                // empty if block
                            }
                            if ((texturePlaces = ArmorLoader.getValueFromXmlTag(genderNode, "texturePlace")).length != (meshTextureNames = ArmorLoader.getValueFromXmlTag(genderNode, "texture")).length) {
                                // empty if block
                            }
                            boolean[] textureHasAlpha = new boolean[meshTextureNames.length];
                            for (int i = 0; i < textureHasAlpha.length; ++i) {
                                textureHasAlpha[i] = meshTextureNames[i].contains("hasAlpha");
                            }
                            boolean boolean1 = genderNode.getFirst("isSkirt") != null;
                            boolean1 = genderNode.getFirst("showHair") != null || boolean1;
                            boolean1 = genderNode.getFirst("isBelt") != null || boolean1;
                            boolean1 = genderNode.getFirst("isWeapon") != null || boolean1;
                            boolean boolean2 = genderNode.getFirst("removeHead") != null;
                            boolean2 = genderNode.getFirst("isTwoHander") != null || boolean2;
                            boolean boolean3 = genderNode.getFirst("removeMask") == null;
                            ArmorMeshData itemData = new ArmorMeshData(itemName, meshPlaces, meshNames, texturePlaces, meshTextureNames, textureHasAlpha, boolean1, boolean2, boolean3);
                            armorData.put(String.valueOf(itemName) + "_" + kingdomName + "_" + genderName, itemData);
                            for (int i = 0; i < meshTextureNames.length; ++i) {
                                ModArmor.addArmorTexture(meshTextureNames[i], armor);
                            }
                        }
                    }
                }
            }
        }
    }

    private static String[] getValueFromXmlTag(XmlNode xmlNode, String xmlTag) {
        List childeren = xmlNode.getAll(xmlTag);
        String[] valueArray = new String[childeren.size()];
        for (int i = 0; i < childeren.size(); ++i) {
            String text;
            valueArray[i] = text = ((XmlNode)childeren.get(i)).getText();
        }
        return valueArray;
    }
}

