/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modloader.dependency;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gotti.wurmunlimited.modloader.dependency.DependencyEntry;
import org.gotti.wurmunlimited.modloader.dependency.DependencyException;
import org.gotti.wurmunlimited.modloader.dependency.DependencyProvider;

public class DependencyResolver<T extends DependencyProvider> {
    private final Set<String> provided = new HashSet<String>();

    public List<T> order(List<? extends T> mods) {
        HashMap byName = new HashMap();
        mods.forEach(mod -> byName.put(mod.getName(), mod));
        LinkedHashMap<String, DependencyEntry> entries = new LinkedHashMap<String, DependencyEntry>();
        mods.forEach(mod -> entries.put(mod.getName(), new DependencyEntry((DependencyProvider)mod)));
        this.checkRequires(entries);
        this.checkConflicts(entries);
        this.removeMissing(entries);
        this.removeSelfReference(entries);
        this.resolveAfter(entries);
        this.resolveBefore(entries);
        while (this.pruneOnDemand(entries)) {
        }
        List<DependencyEntry> order = this.resolveOrder(entries);
        return order.stream().map(DependencyEntry::getName).map(byName::get).collect(Collectors.toList());
    }

    public DependencyResolver<T> provided(Collection<String> provided) {
        this.provided.addAll(DependencyEntry.parse(provided));
        return this;
    }

    private List<DependencyEntry> resolveOrder(Map<String, DependencyEntry> entries) {
        HashSet<DependencyEntry> blocked = new HashSet<DependencyEntry>();
        TreeSet<DependencyEntry> ready = new TreeSet<DependencyEntry>(Comparator.comparing(DependencyEntry::getName));
        LinkedList<DependencyEntry> order = new LinkedList<DependencyEntry>();
        for (DependencyEntry mod : entries.values()) {
            if (mod.getBefore().isEmpty()) {
                ready.add(mod);
                continue;
            }
            blocked.add(mod);
        }
        while (!ready.isEmpty()) {
            DependencyEntry entry = ready.pollFirst();
            for (String after : entry.getAfter()) {
                DependencyEntry mod = entries.get(after);
                mod.getBefore().remove(entry.getName());
                if (!mod.getBefore().isEmpty()) continue;
                blocked.remove(mod);
                ready.add(mod);
            }
            order.add(entry);
        }
        if (!blocked.isEmpty()) {
            throw new DependencyException("Unresolved order for the following elements: " + blocked.stream().map(DependencyEntry::getName).sorted().collect(Collectors.joining(", ")));
        }
        return order;
    }

    private void checkRequires(Map<String, DependencyEntry> entries) {
        for (DependencyEntry entry : entries.values()) {
            for (String required : entry.getRequires()) {
                if (entries.keySet().contains(required) || this.provided.contains(required)) continue;
                throw new DependencyException(String.format("%s requires %s which is unavailable", entry.getName(), required));
            }
        }
    }

    private void checkConflicts(Map<String, DependencyEntry> entries) {
        for (DependencyEntry entry : entries.values()) {
            for (String conflict : entry.getConflicts()) {
                if (!entries.keySet().contains(conflict) && !this.provided.contains(conflict)) continue;
                throw new DependencyException(String.format("%s conflicts with %s", entry.getName(), conflict));
            }
        }
    }

    private void resolveAfter(Map<String, DependencyEntry> entries) {
        for (DependencyEntry mod : entries.values()) {
            mod.getAfter().forEach(info -> ((DependencyEntry)entries.get(info)).addBefore(mod.getName()));
        }
    }

    private void resolveBefore(Map<String, DependencyEntry> entries) {
        for (DependencyEntry mod : entries.values()) {
            mod.getBefore().forEach(info -> ((DependencyEntry)entries.get(info)).addAfter(mod.getName()));
        }
    }

    private void removeSelfReference(Map<String, DependencyEntry> entries) {
        for (DependencyEntry mod : entries.values()) {
            String name = mod.getName();
            mod.getBefore().removeIf(name::equals);
            mod.getAfter().removeIf(name::equals);
        }
    }

    private void removeMissing(Map<String, DependencyEntry> entries) {
        Predicate<String> present = entries::containsKey;
        Predicate<String> missing = present.negate();
        for (DependencyEntry mod : entries.values()) {
            mod.getBefore().removeIf(missing);
            mod.getAfter().removeIf(missing);
        }
    }

    private boolean pruneOnDemand(Map<String, DependencyEntry> entries) {
        HashSet<String> toRemove = new HashSet<String>();
        for (DependencyEntry mod : entries.values()) {
            if (!mod.isOnDemand() || !mod.getAfter().isEmpty()) continue;
            for (String before : mod.getBefore()) {
                entries.get(before).getAfter().remove(mod.getName());
            }
            toRemove.add(mod.getName());
        }
        return entries.keySet().removeAll(toRemove);
    }
}

