/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modloader.callbacks;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Loader;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import org.gotti.wurmunlimited.modloader.callbacks.CallbackApi;
import org.gotti.wurmunlimited.modloader.classhooks.HookException;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;

public class Callbacks {
    private static final Logger LOG = Logger.getLogger(Callbacks.class.getName());
    private static final String PROXY_CLASSNAME_PATTERN = "__cb_Proxy_%s_%d";
    private static final String CALLBACK_ID_PATTERN = "%s#%s";
    private static final String METHOD_FIELD = "__cb_%s_%d";
    private static final String INSTANCE_FIELD = "__cb_target";
    private final Map<String, CallbackInfo> callbackMap = new ConcurrentHashMap<String, CallbackInfo>();
    private final ClassPool classPool;
    private final Loader loader;

    public Callbacks(Loader loader, ClassPool classPool) {
        this.loader = loader;
        this.classPool = classPool;
    }

    public <T> T getCallback(String callbackId) {
        CallbackInfo callbackInfo = this.callbackMap.get(callbackId);
        if (callbackInfo == null || callbackInfo.get() == null) {
            throw new HookException("Callback " + callbackId + " was not found");
        }
        return (T)callbackInfo.get();
    }

    private Object initializeProxy(CtClass proxy, CtField targetField, Map<String, CtMethod> methods, Object callbackTarget) {
        try {
            Class<?> proxyClass = proxy.toClass();
            Object proxyInstance = proxyClass.newInstance();
            for (Map.Entry<String, CtMethod> entry : methods.entrySet()) {
                CtMethod ctMethod = entry.getValue();
                Class[] paramTypes = (Class[])Arrays.stream(ctMethod.getParameterTypes()).map(this::toClass).toArray(Class[]::new);
                Method method = callbackTarget.getClass().getMethod(ctMethod.getName(), paramTypes);
                method.setAccessible(true);
                proxyClass.getField(entry.getKey()).set(proxyInstance, method);
            }
            proxyClass.getField(targetField.getName()).set(proxyInstance, callbackTarget);
            return proxyInstance;
        }
        catch (Exception e) {
            throw new HookException(e);
        }
    }

    private static CtClass getCtClass(Class<?> clazz) {
        try {
            ClassPool classPool = new ClassPool();
            classPool.appendClassPath(new ClassClassPath(clazz));
            CtClass ctClass = classPool.get(clazz.getName());
            return ctClass;
        }
        catch (NotFoundException e) {
            throw new HookException(e);
        }
    }

    private CtClass toCtClass(Class<?> clazz) {
        try {
            return this.classPool.get(clazz.getName());
        }
        catch (NotFoundException e) {
            throw new HookException(e);
        }
    }

    private CtClass toCtClass(CtClass ctClass) {
        try {
            return this.classPool.get(ctClass.getName());
        }
        catch (NotFoundException e) {
            throw new HookException(e);
        }
    }

    private Class<?> toClass(CtClass ctClass) {
        try {
            if (ctClass.isPrimitive()) {
                CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)ctClass;
                switch (ctPrimitiveType.getDescriptor()) {
                    case 'Z': {
                        return Boolean.TYPE;
                    }
                    case 'C': {
                        return Character.TYPE;
                    }
                    case 'B': {
                        return Byte.TYPE;
                    }
                    case 'S': {
                        return Short.TYPE;
                    }
                    case 'I': {
                        return Integer.TYPE;
                    }
                    case 'J': {
                        return Long.TYPE;
                    }
                    case 'F': {
                        return Float.TYPE;
                    }
                    case 'D': {
                        return Double.TYPE;
                    }
                    case 'V': {
                        return Void.TYPE;
                    }
                }
                throw new HookException("Invalid type " + ctClass.getName());
            }
            if (ctClass.isArray()) {
                return Class.forName(Descriptor.toJavaName(Descriptor.of(ctClass)));
            }
            return this.loader.loadClass(ctClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new HookException(e);
        }
    }

    public void addCallback(CtClass targetClass, String callbackName, Object callbackTarget) {
        try {
            CtClass proxy = this.classPool.makeClass(String.format(PROXY_CLASSNAME_PATTERN, callbackName, this.callbackMap.size()));
            String callbackId = String.format(CALLBACK_ID_PATTERN, targetClass.getName(), callbackName);
            CtField targetField = new CtField(this.classPool.get(Object.class.getName()), INSTANCE_FIELD, proxy);
            targetField.setModifiers(1);
            proxy.addField(targetField);
            HashMap<String, CtMethod> methodFieldValues = new HashMap<String, CtMethod>();
            CtMethod[] methods = Callbacks.getCtClass(callbackTarget.getClass()).getMethods();
            boolean requireAnnotation = Arrays.stream(methods).anyMatch(method -> method.hasAnnotation(CallbackApi.class));
            for (CtMethod method2 : methods) {
                String code;
                if (method2.getDeclaringClass().getName().equals(Object.class.getName()) || requireAnnotation && !method2.hasAnnotation(CallbackApi.class)) continue;
                CtField methodField = new CtField(this.toCtClass(Method.class), String.format(METHOD_FIELD, method2.getName(), methodFieldValues.size()), proxy);
                methodField.setModifiers(1);
                proxy.addField(methodField);
                CtClass returnType = this.toCtClass(method2.getReturnType());
                CtClass[] paramTypes = (CtClass[])Arrays.stream(method2.getParameterTypes()).map(this::toCtClass).toArray(CtClass[]::new);
                CtMethod ctMethod = new CtMethod(returnType, method2.getName(), paramTypes, proxy);
                if (returnType == CtClass.voidType) {
                    code = String.format("%s.invoke(%s, $args);", methodField.getName(), INSTANCE_FIELD);
                    ctMethod.setBody(code);
                } else {
                    code = String.format("return ($r) %s.invoke(%s, $args);", methodField.getName(), INSTANCE_FIELD);
                    ctMethod.setBody(code);
                }
                proxy.addMethod(ctMethod);
                methodFieldValues.put(methodField.getName(), ctMethod);
            }
            CtField callbackField = new CtField(proxy, callbackName, targetClass);
            callbackField.setModifiers(10);
            String expr = String.format("(%s) %s.getCallback(\"%s\")", proxy.getName(), HookManager.class.getName(), callbackId);
            CtField.Initializer initializer = CtField.Initializer.byExpr(expr);
            targetClass.addField(callbackField, initializer);
            CallbackInfo callbackInfo = new CallbackInfo(() -> this.initializeProxy(proxy, targetField, methodFieldValues, callbackTarget));
            this.callbackMap.put(callbackId, callbackInfo);
            List methodNames = methodFieldValues.values().stream().map(CtMethod::getLongName).collect(Collectors.toList());
            LOG.info(String.format("Adding callback %s to class %s for  %s with methods %s", callbackName, targetClass.getName(), callbackTarget.getClass().getName(), methodNames));
        }
        catch (IllegalArgumentException | SecurityException | CannotCompileException | NotFoundException e) {
            throw new HookException(e);
        }
    }

    public void init() {
        for (CallbackInfo callbackInfo : this.callbackMap.values()) {
            callbackInfo.get();
        }
    }

    private static class CallbackInfo {
        private Object callback;
        private Supplier<Object> callbackBuilder;

        private CallbackInfo(Supplier<Object> callbackBuilder) {
            this.callbackBuilder = callbackBuilder;
        }

        public synchronized Object get() {
            if (this.callback == null && this.callbackBuilder != null) {
                this.callback = this.callbackBuilder.get();
                this.callbackBuilder = null;
            }
            return this.callback;
        }
    }
}

