/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modloader;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ReflectionUtil {
    private static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> currentClassFields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> parentClass = clazz.getSuperclass();
        if (parentClass != null && !parentClass.equals(Object.class)) {
            List<Field> parentClassFields = ReflectionUtil.getAllFields(parentClass);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    private static List<Method> getAllMethods(Class<?> clazz) {
        ArrayList<Method> currentClassMethods = new ArrayList<Method>(Arrays.asList(clazz.getDeclaredMethods()));
        Class<?> parentClass = clazz.getSuperclass();
        if (parentClass != null && !parentClass.equals(Object.class)) {
            List<Method> parentClassFields = ReflectionUtil.getAllMethods(parentClass);
            currentClassMethods.addAll(parentClassFields);
        }
        return currentClassMethods;
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        for (Field field : ReflectionUtil.getAllFields(clazz)) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        throw new NoSuchFieldException(fieldName);
    }

    public static Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        return ReflectionUtil.getMethod(clazz, methodName, null);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] signature) throws NoSuchMethodException {
        for (Method method : ReflectionUtil.getAllMethods(clazz)) {
            if (!method.getName().equals(methodName) || signature != null && !Arrays.equals(signature, method.getParameterTypes())) continue;
            return method;
        }
        throw new NoSuchMethodException(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void setPrivateField(Object object, Field field, T value) throws IllegalArgumentException, IllegalAccessException, ClassCastException {
        boolean isAccesible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        finally {
            field.setAccessible(isAccesible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getPrivateField(Object object, Field field) throws IllegalArgumentException, IllegalAccessException, ClassCastException {
        boolean isAccesible = field.isAccessible();
        field.setAccessible(true);
        try {
            Object object2 = field.get(object);
            return (T)object2;
        }
        finally {
            field.setAccessible(isAccesible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T callPrivateMethod(Object target, Method method, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean isAccesible = method.isAccessible();
        method.setAccessible(true);
        try {
            Object object = method.invoke(target, args);
            return (T)object;
        }
        finally {
            method.setAccessible(isAccesible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T callPrivateConstructor(Constructor<T> constructor, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        boolean isAccesible = constructor.isAccessible();
        constructor.setAccessible(true);
        try {
            T t = constructor.newInstance(args);
            return t;
        }
        finally {
            constructor.setAccessible(isAccesible);
        }
    }
}

