/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modloader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.NotFoundException;
import org.gotti.wurmunlimited.modloader.DefrostingClassLoader;
import org.gotti.wurmunlimited.modloader.EarlyLoadingChecker;
import org.gotti.wurmunlimited.modloader.ModInfo;
import org.gotti.wurmunlimited.modloader.ModInstanceBuilder;
import org.gotti.wurmunlimited.modloader.ReflectionUtil;
import org.gotti.wurmunlimited.modloader.classhooks.HookException;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;
import org.gotti.wurmunlimited.modloader.dependency.DependencyResolver;
import org.gotti.wurmunlimited.modloader.interfaces.Configurable;
import org.gotti.wurmunlimited.modloader.interfaces.Initable;
import org.gotti.wurmunlimited.modloader.interfaces.ModEntry;
import org.gotti.wurmunlimited.modloader.interfaces.ModListener;
import org.gotti.wurmunlimited.modloader.interfaces.PreInitable;
import org.gotti.wurmunlimited.modloader.interfaces.Versioned;

public abstract class ModLoaderShared<T extends Versioned>
implements Versioned {
    private static Logger logger = Logger.getLogger(ModLoaderShared.class.getName());
    private Class<? extends T> modClass;

    public ModLoaderShared(Class<? extends T> modClass) {
        this.modClass = modClass;
    }

    protected abstract void modcommInit();

    protected abstract void preInit();

    protected abstract void init();

    private List<ModInfo> discoverMods(Path modDir) throws IOException {
        ModInfo mod;
        Path modJar;
        String modName;
        ArrayList<ModInfo> unorderedMods = new ArrayList<ModInfo>();
        HashSet<String> handled = new HashSet<String>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(modDir, "*.properties");){
            for (Path modInfo : directoryStream) {
                modName = modInfo.getFileName().toString().replaceAll("\\.properties$", "");
                modJar = modDir.resolve(modName).resolve(modName + ".jar");
                mod = this.loadModFromInfo(modName, modInfo, modJar);
                unorderedMods.add(mod);
                handled.add(modName);
            }
        }
        directoryStream = Files.newDirectoryStream(modDir, path -> Files.isDirectory(path, new LinkOption[0]) && !handled.contains(path.getFileName().toString()));
        var5_5 = null;
        try {
            for (Path modInfo : directoryStream) {
                modName = modInfo.getFileName().toString();
                modJar = modDir.resolve(modName).resolve(modName + ".jar");
                if (!Files.exists(modJar, new LinkOption[0])) continue;
                mod = this.loadModFromInfo(modName, null, modJar);
                unorderedMods.add(mod);
                handled.add(modName);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (directoryStream != null) {
                if (var5_5 != null) {
                    try {
                        directoryStream.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    directoryStream.close();
                }
            }
        }
        return unorderedMods;
    }

    public List<? extends ModEntry<T>> loadModsFromModDir(Path modDir) throws IOException {
        String version = this.getVersion();
        logger.info(String.format("ModLoader version %1$s", version));
        String modLoaderProvided = "modloader";
        if (version != null && !version.isEmpty()) {
            modLoaderProvided = modLoaderProvided + "@" + version;
        }
        LinkedHashSet<String> provided = new LinkedHashSet<String>();
        provided.add(modLoaderProvided);
        String steamVersion = this.getGameVersion();
        provided.add("wurmunlimited@" + steamVersion);
        logger.info(String.format("Game version %1$s", steamVersion));
        List<ModInfo> unorderedMods = this.discoverMods(modDir);
        ModInstanceBuilder<? extends T> entryBuilder = new ModInstanceBuilder<T>(this.modClass);
        List mods = new DependencyResolver().provided(Collections.singleton(modLoaderProvided)).order(unorderedMods).stream().map(modInfo -> {
            try (EarlyLoadingChecker c = EarlyLoadingChecker.init(modInfo.getName(), "load");){
                modInfo.getProperties().put("steamVersion", steamVersion);
                Entry entry = new Entry(this, (Versioned)entryBuilder.createModInstance((ModInfo)modInfo), modInfo.getProperties(), modInfo.getName());
                return entry;
            }
        }).collect(Collectors.toList());
        mods.stream().forEach(modEntry -> {
            String implementationVersion = modEntry.mod.getVersion();
            if (implementationVersion == null || implementationVersion.isEmpty()) {
                implementationVersion = "unversioned";
            }
            logger.info(String.format("Loading %1$s as %2$s (%3$s)", modEntry.mod.getClass().getName(), modEntry.getName(), implementationVersion));
        });
        mods.stream().filter(modEntry -> (modEntry.mod instanceof Initable || modEntry.mod instanceof PreInitable) && modEntry.mod instanceof Configurable).forEach(modEntry -> {
            try (EarlyLoadingChecker c = EarlyLoadingChecker.init(modEntry.getName(), "configure");){
                ((Configurable)modEntry.mod).configure(modEntry.getProperties());
            }
        });
        try (EarlyLoadingChecker c = EarlyLoadingChecker.init("ModComm", "init");){
            this.modcommInit();
        }
        mods.stream().filter(modEntry -> modEntry.mod instanceof PreInitable).forEach(modEntry -> {
            try (EarlyLoadingChecker c = EarlyLoadingChecker.init(modEntry.getName(), "preinit");){
                ((PreInitable)modEntry.mod).preInit();
            }
        });
        this.preInit();
        mods.stream().filter(modEntry -> modEntry.mod instanceof Initable).forEach(modEntry -> {
            try (EarlyLoadingChecker c = EarlyLoadingChecker.init(modEntry.getName(), "init");){
                ((Initable)modEntry.mod).init();
            }
        });
        this.init();
        mods.stream().filter(modEntry -> !(modEntry.mod instanceof Initable) && !(modEntry.mod instanceof PreInitable) && modEntry.mod instanceof Configurable).forEach(modEntry -> {
            try (EarlyLoadingChecker c = EarlyLoadingChecker.init(modEntry.getName(), "configure");){
                ((Configurable)modEntry.mod).configure(modEntry.getProperties());
            }
        });
        mods.stream().filter(modEntry -> modEntry.mod instanceof ModListener).forEach(modEntry -> {
            try (EarlyLoadingChecker c = EarlyLoadingChecker.init(modEntry.getName(), "modListener");){
                mods.stream().forEach(mod -> ((ModListener)modEntry.mod).modInitialized((ModEntry<?>)mod));
            }
        });
        return mods;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private Properties loadDefaultPropertiesFromJar(String modName, Path jarFile) throws IOException {
        block30: {
            try {
                Throwable throwable = null;
                try (FileSystem fs = FileSystems.newFileSystem(URI.create("jar:" + jarFile.toUri()), new HashMap());){
                    Path propsFile = fs.getPath("/META-INF/" + ModLoaderShared.class.getPackage().getName() + "/" + modName + ".properties", new String[0]);
                    if (Files.exists(propsFile, new LinkOption[0])) {
                        logger.log(Level.INFO, "Reading " + jarFile.toString() + "!" + propsFile.toString());
                        try (InputStream inputStream = Files.newInputStream(propsFile, new OpenOption[0]);){
                            Properties properties = new Properties();
                            properties.load(inputStream);
                            Properties properties2 = properties;
                            return properties2;
                        }
                    }
                    break block30;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return new Properties();
    }

    private void copyConfigFromJar(String modName, Path jarFile, Path configFile) throws IOException {
        try (FileSystem fs = FileSystems.newFileSystem(URI.create("jar:" + jarFile.toUri()), new HashMap());){
            Path configTemplate = fs.getPath("/META-INF/" + ModLoaderShared.class.getPackage().getName() + "/" + modName + ".config", new String[0]);
            if (Files.exists(configTemplate, new LinkOption[0])) {
                logger.log(Level.INFO, "Copying " + jarFile + "!" + configTemplate + " to " + configFile);
                Files.copy(configTemplate, configFile, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private ModInfo loadModFromInfo(String modName, Path modInfo, Path jarFile) throws IOException {
        Throwable throwable;
        InputStream inputStream;
        Path configFile = Paths.get("mods", modName + ".config");
        Properties properties = new Properties();
        if (jarFile != null && Files.exists(jarFile, new LinkOption[0])) {
            if (modInfo == null || !Files.exists(modInfo, new LinkOption[0])) {
                properties.put("depend.ondemand", "true");
            }
            properties.putAll((Map<?, ?>)this.loadDefaultPropertiesFromJar(modName, jarFile));
            if (!Files.exists(configFile, new LinkOption[0])) {
                this.copyConfigFromJar(modName, jarFile, configFile);
            }
        }
        if (modInfo != null) {
            logger.log(Level.INFO, "Reading " + modInfo.toString());
            inputStream = Files.newInputStream(modInfo, new OpenOption[0]);
            throwable = null;
            try {
                properties.load(inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        if (Files.exists(configFile, new LinkOption[0])) {
            inputStream = Files.newInputStream(configFile, new OpenOption[0]);
            throwable = null;
            try {
                logger.log(Level.INFO, "Reading " + configFile.toString());
                properties.load(inputStream);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        return new ModInfo(properties, modName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getGameVersion() {
        ClassPool classPool = HookManager.getInstance().getClassPool();
        try (DefrostingClassLoader loader = new DefrostingClassLoader(classPool);){
            Class<?> clazz = loader.loadClass("com.wurmonline.shared.constants.SteamVersion");
            Method getCurrentVersion = ReflectionUtil.getMethod(clazz, "getCurrentVersion");
            String string = getCurrentVersion.invoke(clazz, new Object[0]).toString();
            return string;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException | CannotCompileException | NotFoundException e) {
            throw new HookException(e);
        }
    }

    private static class Entry
    extends ModInfo
    implements ModEntry<T> {
        T mod;
        final /* synthetic */ ModLoaderShared this$0;

        public Entry(T mod, Properties properties, String name) {
            this.this$0 = var1_1;
            super(properties, name);
            this.mod = mod;
        }

        @Override
        public T getWurmMod() {
            return this.mod;
        }
    }
}

