/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modloader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.ClassPool;
import javassist.Loader;
import javassist.NotFoundException;
import org.gotti.wurmunlimited.modloader.JoinClassLoader;
import org.gotti.wurmunlimited.modloader.ModInfo;
import org.gotti.wurmunlimited.modloader.classhooks.HookException;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;

class ModInstanceBuilder<T> {
    private static Logger logger = Logger.getLogger(ModInstanceBuilder.class.getName());
    private Map<String, ClassLoader> classLoaders = new HashMap<String, ClassLoader>();
    private Class<? extends T> modClass;

    public ModInstanceBuilder(Class<? extends T> modClass) {
        this.modClass = modClass;
    }

    T createModInstance(ModInfo entry) {
        Properties properties = entry.getProperties();
        String modInfo = entry.getName();
        String className = properties.getProperty("classname");
        if (className == null) {
            throw new HookException("Missing property classname for mod " + modInfo);
        }
        try {
            ClassLoader classloader;
            Loader loader = HookManager.getInstance().getLoader();
            String classpath = properties.getProperty("classpath");
            if (classpath != null) {
                Boolean sharedClassLoader = Boolean.valueOf(properties.getProperty("sharedClassLoader", "false"));
                ClassLoader[] dependencies = (ClassLoader[])entry.getImport().stream().map(this.classLoaders::get).filter(Objects::nonNull).toArray(ClassLoader[]::new);
                classloader = this.createClassLoader(entry.getName(), classpath, loader, sharedClassLoader, dependencies);
                if (!sharedClassLoader.booleanValue()) {
                    this.classLoaders.put(entry.getName(), classloader);
                }
            } else {
                classloader = loader;
            }
            return classloader.loadClass(className).asSubclass(this.modClass).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | MalformedURLException | NotFoundException e) {
            throw new HookException(e);
        }
    }

    private List<Path> getClassLoaderEntries(String modname, String classpath) {
        String[] entries;
        final ArrayList<Path> pathEntries = new ArrayList<Path>();
        for (String entry : entries = classpath.split(",")) {
            final Path modPath = Paths.get("mods", modname);
            FileSystem fs = modPath.getFileSystem();
            final PathMatcher matcher = fs.getPathMatcher("glob:" + entry);
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path p = modPath.relativize(file);
                    if (matcher.matches(p)) {
                        pathEntries.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            try {
                Files.walkFileTree(modPath, (FileVisitor<? super Path>)visitor);
            }
            catch (IOException e) {
                throw new HookException(e);
            }
        }
        return pathEntries;
    }

    private ClassLoader createClassLoader(String modname, String classpath, Loader loader, Boolean shared, ClassLoader ... dependencies) throws MalformedURLException, NotFoundException {
        List<Path> pathEntries = this.getClassLoaderEntries(modname, classpath);
        logger.log(Level.INFO, "Classpath: " + pathEntries.toString());
        if (shared.booleanValue()) {
            ClassPool classPool = HookManager.getInstance().getClassPool();
            for (Path path : pathEntries) {
                classPool.appendClassPath(path.toString());
            }
            return loader;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Path path : pathEntries) {
            urls.add(path.toUri().toURL());
        }
        ClassLoader parent = loader;
        if (dependencies != null && dependencies.length > 0) {
            parent = new JoinClassLoader(parent, dependencies);
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }
}

