/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modloader;

import java.io.Closeable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.NotFoundException;
import javassist.Translator;
import org.gotti.wurmunlimited.modloader.AddToListTranslator;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;

interface EarlyLoadingChecker
extends Closeable {
    public static final Logger LOGGER = Logger.getLogger(EarlyLoadingChecker.class.getName());
    public static final Translator NOOP_TRANSLATOR = new Translator(){

        @Override
        public void start(ClassPool paramClassPool) throws NotFoundException, CannotCompileException {
        }

        @Override
        public void onLoad(ClassPool paramClassPool, String paramString) throws NotFoundException, CannotCompileException {
        }
    };

    @Override
    public void close();

    public static EarlyLoadingChecker init(final String modname, final String phase) {
        final HookManager hookManager = HookManager.getInstance();
        final AddToListTranslator translator = new AddToListTranslator(paramString -> paramString.startsWith("com.wurmonline.") && !paramString.endsWith("Exception"));
        try {
            hookManager.getLoader().addTranslator(hookManager.getClassPool(), translator);
            return new EarlyLoadingChecker(){

                @Override
                public void close() {
                    for (String classname : translator.getLoadedClasses()) {
                        LOGGER.log(Level.WARNING, String.format("Mod %1$s loaded server class %3$s during phase %2$s", modname, phase, classname));
                    }
                    try {
                        hookManager.getLoader().addTranslator(hookManager.getClassPool(), NOOP_TRANSLATOR);
                    }
                    catch (CannotCompileException | NotFoundException exception) {
                        // empty catch block
                    }
                }
            };
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

