/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modcomm;

import com.wurmonline.communication.SocketConnection;
import java.nio.ByteBuffer;
import org.gotti.wurmunlimited.modcomm.IChannelListener;
import org.gotti.wurmunlimited.modcomm.ModComm;

public class Channel {
    int id = -1;
    final IChannelListener listener;
    final String name;

    Channel(String name, IChannelListener listener) {
        this.name = name;
        this.listener = listener;
    }

    public void sendMessage(ByteBuffer message) {
        if (!this.isActive()) {
            throw new RuntimeException(String.format("Channel %s is not active", this.name));
        }
        try {
            SocketConnection conn = ModComm.getServerConnection();
            ByteBuffer buff = conn.getBuffer();
            buff.put((byte)-100);
            buff.put((byte)1);
            buff.putInt(this.id);
            buff.put(message);
            buff.put(message);
            conn.flush();
        }
        catch (Exception e) {
            ModComm.logException(String.format("Error sending packet on channel %s", this.name), e);
        }
    }

    public boolean isActive() {
        return this.id > 0;
    }
}

