/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.clientlauncher;

import com.wurmonline.client.console.ConsoleListenerClass;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.gotti.wurmunlimited.clientlauncher.OneLineLogMessageFormatter;

public class ClientLogger {
    private static final String CONSOLE_LOGGER = "com.wurmonline.console";
    private static ThreadLocal<Boolean> inLogHandler = new ThreadLocal();

    public static void initLogger() {
        final OneLineLogMessageFormatter formatter = new OneLineLogMessageFormatter();
        StreamHandler handler = new StreamHandler(System.out, new SimpleFormatter()){

            @Override
            public synchronized void publish(LogRecord record) {
                if (!ClientLogger.CONSOLE_LOGGER.equals(record.getLoggerName())) {
                    try {
                        inLogHandler.set(true);
                        System.out.println(formatter.format(record));
                    }
                    finally {
                        inLogHandler.remove();
                    }
                }
            }
        };
        Logger.getLogger("").addHandler(handler);
    }

    public static ConsoleListenerClass createConsoleListener() {
        return new ConsoleListenerClass(){

            public void consoleOutput(String message) {
                Boolean b = (Boolean)inLogHandler.get();
                if (b == null || !b.booleanValue()) {
                    Logger.getLogger(ClientLogger.CONSOLE_LOGGER).log(Level.INFO, message);
                }
            }

            public void consoleClosed() {
            }
        };
    }
}

