/*
 * Decompiled with CFR 0.152.
 */
package com.wurmonline.client.launcherfx;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WurmMain {
    public static void main(String[] args) {
        try {
            WurmMain.initLogger();
            URL[] urls = new URL[]{Paths.get("javassist.jar", new String[0]).toUri().toURL()};
            try (URLClassLoader urlClassLoader = new URLClassLoader(urls);){
                Class<?> launcher = urlClassLoader.loadClass("org.gotti.wurmunlimited.clientlauncher.ClientLauncher");
                Method method = launcher.getDeclaredMethod("main", String[].class);
                method.invoke(launcher, new Object[]{args});
            }
        }
        catch (Exception e) {
            Logger.getLogger("org.gotti.wurmunlimited.Loader").log(Level.SEVERE, e.getMessage(), e);
            e.printStackTrace();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(-1);
        }
    }

    private static void initLogger() throws SecurityException, IOException {
        if (System.getProperty("java.util.logging.config.file") != null) {
            return;
        }
        if (System.getProperty("java.util.logging.config.class") != null) {
            return;
        }
        Path loggingPropertiesFile = Paths.get("logging.properties", new String[0]);
        if (Files.isRegularFile(loggingPropertiesFile, new LinkOption[0])) {
            System.setProperty("java.util.logging.config.file", loggingPropertiesFile.toString());
            return;
        }
    }
}

