/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.wurm.scanner;

import com.wurmonline.client.renderer.Color;
import com.wurmonline.client.renderer.cell.CellRenderable;
import java.util.function.Predicate;
import net.bdew.wurm.scanner.Utils;

public class Selectors {
    public static Predicate<CellRenderable> parse(String name) {
        if (name.startsWith("!")) {
            return Selectors.parse(name.substring(1)).negate();
        }
        if (name.startsWith("%")) {
            return Selectors.selectModel(name.substring(1).toLowerCase());
        }
        if (name.startsWith("&")) {
            return Selectors.selectColor(name.substring(1).toLowerCase());
        }
        return Selectors.selectName(name.toLowerCase());
    }

    private static Predicate<CellRenderable> selectName(String name) {
        return i -> i.getHoverName().toLowerCase().contains(name);
    }

    private static Predicate<CellRenderable> selectModel(String model) {
        return i -> i.getModelWrapper().getResourceUrl().toString().toLowerCase().contains(model);
    }

    private static Predicate<CellRenderable> selectColor(String name) {
        Color col = Utils.parseColor(name);
        if (col == null) {
            return i -> false;
        }
        return i -> {
            Color test = i.getOutlineColor();
            return test.r == col.r && test.g == col.g && test.b == col.b;
        };
    }
}

