/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.wurm.scanner;

import com.wurmonline.client.comm.ServerConnectionListenerClass;
import com.wurmonline.client.game.PlayerPosition;
import com.wurmonline.client.renderer.Color;
import com.wurmonline.client.renderer.PickRenderer;
import com.wurmonline.client.renderer.PickableUnit;
import com.wurmonline.client.renderer.WorldRender;
import com.wurmonline.client.renderer.backend.Primitive;
import com.wurmonline.client.renderer.backend.Queue;
import com.wurmonline.client.renderer.backend.RenderState;
import com.wurmonline.client.renderer.cell.CellRenderable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.bdew.wurm.scanner.ScanEntry;
import net.bdew.wurm.scanner.ScannerMod;
import org.gotti.wurmunlimited.modloader.ReflectionUtil;

public class OutlineRender {
    public static List<ScanEntry> entries = new LinkedList<ScanEntry>();
    private static PickRenderer pickRenderer;
    private static PickRenderer.CustomPickFillRender customPickFill;
    private static PickRenderer.CustomPickFillDepthRender customPickFillDepth;
    private static PickRenderer.CustomPickOutlineRender customPickOutline;
    private static Field groundItemsField;
    private static final String[] headings;
    private static final double PI = Math.PI;
    private static long nextNotify;

    public static void render(WorldRender wr, Queue queue) {
        if (entries.isEmpty()) {
            return;
        }
        if (pickRenderer == null) {
            try {
                pickRenderer = (PickRenderer)ReflectionUtil.getPrivateField((Object)wr, (Field)ReflectionUtil.getField(WorldRender.class, (String)"pickRenderer"));
                customPickFill = (PickRenderer.CustomPickFillRender)ReflectionUtil.getPrivateField((Object)wr, (Field)ReflectionUtil.getField(WorldRender.class, (String)"customPickFill"));
                customPickFillDepth = (PickRenderer.CustomPickFillDepthRender)ReflectionUtil.getPrivateField((Object)wr, (Field)ReflectionUtil.getField(WorldRender.class, (String)"customPickFillDepth"));
                customPickOutline = (PickRenderer.CustomPickOutlineRender)ReflectionUtil.getPrivateField((Object)wr, (Field)ReflectionUtil.getField(WorldRender.class, (String)"customPickOutline"));
                groundItemsField = ReflectionUtil.getField(ServerConnectionListenerClass.class, (String)"groundItems");
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            boolean doNotify;
            ServerConnectionListenerClass conn = ScannerMod.hud.getWorld().getServerConnection().getServerConnectionListener();
            Collection items = ((Map)ReflectionUtil.getPrivateField((Object)conn, (Field)groundItemsField)).values();
            Collection creatures = conn.getCreatures().values();
            boolean bl = doNotify = nextNotify < System.currentTimeMillis();
            if (doNotify) {
                nextNotify = System.currentTimeMillis() + 5000L;
            }
            Consumer<CellRenderable> process = item -> {
                for (ScanEntry entry : entries) {
                    if (!entry.condition.test((CellRenderable)item)) continue;
                    OutlineRender.renderOutline(queue, (PickableUnit)item, entry.color);
                    if (!doNotify || !entry.notify) break;
                    OutlineRender.doNotify(item, entry.color);
                    break;
                }
            };
            items.forEach(process);
            creatures.forEach(process);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    private static void doNotify(CellRenderable item, Color color) {
        double slice;
        PlayerPosition plPos;
        double at;
        double degrees;
        double a;
        int idx;
        if (color == null) {
            color = new Color(1.0f, 0.0f, 1.0f);
        }
        if ((idx = (int)((a = (degrees = ((at = Math.atan2((plPos = ScannerMod.hud.getWorld().getPlayer().getPos()).getY() - item.getYPos(), plPos.getX() - item.getXPos())) > 0.0 ? at : Math.PI * 2 + at) * 360.0 / (Math.PI * 2) - 90.0) + (slice = (double)(360.0f / (float)headings.length)) / 2.0) / slice) % headings.length) < 0) {
            idx += headings.length;
        }
        String heading = headings[idx];
        String distance = String.format("%.1f", Math.sqrt((item.getXPos() - plPos.getX()) * (item.getXPos() - plPos.getX()) + (item.getYPos() - plPos.getY()) * (item.getYPos() - plPos.getY())));
        ScannerMod.hud.addOnscreenMessage(String.format("%s %s %s!", item.getHoverName(), distance, heading), color.r, color.g, color.b, (byte)1);
    }

    private static void renderOutline(Queue queue, PickableUnit item, Color outlineOverride) {
        RenderState renderStateFill = new RenderState();
        RenderState renderStateFillDepth = new RenderState();
        RenderState renderStateOutline = new RenderState();
        Color color = new Color(item.getOutlineColor());
        if (outlineOverride != null) {
            color = outlineOverride;
        }
        renderStateFill.alphaval = color.a;
        renderStateFill.twosided = false;
        renderStateFill.depthtest = Primitive.TestFunc.ALWAYS;
        renderStateFill.depthwrite = true;
        renderStateFill.customstate = customPickFill;
        item.renderPicked(queue, renderStateFill, color);
        renderStateOutline.alphaval = color.a;
        renderStateOutline.twosided = false;
        renderStateOutline.depthtest = Primitive.TestFunc.LESS;
        renderStateOutline.depthwrite = false;
        renderStateOutline.blendmode = Primitive.BlendMode.ALPHABLEND;
        renderStateOutline.customstate = customPickOutline;
        item.renderPicked(queue, renderStateOutline, color);
        renderStateFillDepth.customstate = customPickFillDepth;
        renderStateFillDepth.depthtest = Primitive.TestFunc.ALWAYS;
        item.renderPicked(queue, renderStateFillDepth, color);
    }

    static {
        headings = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};
        nextNotify = Long.MIN_VALUE;
    }
}

