/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.wurm.action;

import com.wurmonline.client.game.inventory.InventoryMetaItem;
import com.wurmonline.client.renderer.PickableUnit;
import com.wurmonline.client.renderer.gui.HeadsUpDisplay;
import com.wurmonline.mesh.Tiles;
import com.wurmonline.shared.constants.PlayerAction;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.ClassPool;
import javassist.CtClass;
import net.bdew.wurm.action.Reflect;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;
import org.gotti.wurmunlimited.modloader.interfaces.Initable;
import org.gotti.wurmunlimited.modloader.interfaces.PreInitable;
import org.gotti.wurmunlimited.modloader.interfaces.WurmClientMod;

public class ActionMod
implements WurmClientMod,
Initable,
PreInitable {
    private static final Logger logger = Logger.getLogger("ActionMod");
    public static boolean showActionNums = false;
    public static HeadsUpDisplay hud;

    public static void logException(String msg, Throwable e) {
        if (logger != null) {
            logger.log(Level.SEVERE, msg, e);
        }
    }

    public static boolean handleInput(String cmd, String[] data) {
        if (cmd.equals("act_show")) {
            if (data.length == 2) {
                if (data[1].equals("on")) {
                    hud.consoleOutput("Action numbers on");
                    showActionNums = true;
                    return true;
                }
                if (data[1].equals("off")) {
                    hud.consoleOutput("Action numbers off");
                    showActionNums = false;
                    return true;
                }
            }
            hud.consoleOutput("Usage: act_show {on|off}");
            return true;
        }
        if (cmd.equals("act")) {
            String[] commands;
            for (String nextCmd : commands = String.join((CharSequence)" ", Arrays.copyOfRange(data, 1, data.length)).split("\\|")) {
                String[] nextCmdSplit = nextCmd.trim().split(" ");
                try {
                    if (nextCmdSplit.length == 2) {
                        ActionMod.parseAct(Short.parseShort(nextCmdSplit[0]), nextCmdSplit[1]);
                        continue;
                    }
                    hud.consoleOutput("Usage: act <id> <modifier>[|<id> <modifier>|...]");
                }
                catch (ReflectiveOperationException roe) {
                    throw new RuntimeException(roe);
                }
                catch (NumberFormatException nfe) {
                    hud.consoleOutput("act: Error parsing id '" + nextCmdSplit[0] + "'");
                }
            }
            return true;
        }
        return false;
    }

    public void init() {
        logger.fine("Initializing");
        try {
            ClassPool classPool = HookManager.getInstance().getClassPool();
            CtClass ctPlayerAction = classPool.getCtClass("com.wurmonline.shared.constants.PlayerAction");
            ctPlayerAction.getMethod("getName", "()Ljava/lang/String;").insertBefore("if (net.bdew.wurm.action.ActionMod.showActionNums) return this.name + \" (\"+this.id+\")\";");
            CtClass ctWurmConsole = classPool.getCtClass("com.wurmonline.client.console.WurmConsole");
            ctWurmConsole.getMethod("handleDevInput", "(Ljava/lang/String;[Ljava/lang/String;)Z").insertBefore("if (net.bdew.wurm.action.ActionMod.handleInput($1,$2)) return true;");
            HookManager.getInstance().registerHook("com.wurmonline.client.renderer.gui.HeadsUpDisplay", "init", "(II)V", () -> (proxy, method, args) -> {
                method.invoke(proxy, args);
                hud = (HeadsUpDisplay)proxy;
                Reflect.setup();
                return null;
            });
            logger.fine("Loaded");
        }
        catch (Throwable e) {
            ActionMod.logException("Error loading mod", e);
        }
    }

    public void preInit() {
    }

    private static void sendAreaAction(PlayerAction action) {
        ActionMod.sendLocalAction(action, 1, 1);
        ActionMod.sendLocalAction(action, 1, 0);
        ActionMod.sendLocalAction(action, 1, -1);
        ActionMod.sendLocalAction(action, 0, 1);
        ActionMod.sendLocalAction(action, 0, 0);
        ActionMod.sendLocalAction(action, 0, -1);
        ActionMod.sendLocalAction(action, -1, 1);
        ActionMod.sendLocalAction(action, -1, 0);
        ActionMod.sendLocalAction(action, -1, -1);
    }

    private static void sendLocalAction(PlayerAction action, int xo, int yo) {
        int x = hud.getWorld().getPlayerCurrentTileX();
        int y = hud.getWorld().getPlayerCurrentTileY();
        hud.sendAction(action, Tiles.getTileId((int)(x + xo), (int)(y + yo), (int)0));
    }

    private static void parseAct(short id, String target) throws ReflectiveOperationException {
        PlayerAction act = new PlayerAction(id, 65535, "", false);
        switch (target) {
            case "hover": {
                hud.getWorld().sendHoveredAction(act);
                break;
            }
            case "body": {
                hud.sendAction(act, Reflect.getBodyItem(Reflect.getPaperdollInventory(hud)).getId());
                break;
            }
            case "tile": {
                hud.getWorld().sendLocalAction(act);
                break;
            }
            case "tile_n": {
                ActionMod.sendLocalAction(act, 0, -1);
                break;
            }
            case "tile_w": {
                ActionMod.sendLocalAction(act, -1, 0);
                break;
            }
            case "tile_nw": {
                ActionMod.sendLocalAction(act, -1, -1);
                break;
            }
            case "tile_ne": {
                ActionMod.sendLocalAction(act, 1, -1);
                break;
            }
            case "tile_s": {
                ActionMod.sendLocalAction(act, 0, 1);
                break;
            }
            case "tile_e": {
                ActionMod.sendLocalAction(act, 1, 0);
                break;
            }
            case "tile_se": {
                ActionMod.sendLocalAction(act, 1, 1);
                break;
            }
            case "tile_sw": {
                ActionMod.sendLocalAction(act, -1, 1);
                break;
            }
            case "tool": {
                InventoryMetaItem t = Reflect.getActiveToolItem(hud);
                if (t != null) {
                    hud.sendAction(act, t.getId());
                    break;
                }
                hud.consoleOutput("act: tool modifier requires an active tool selected");
                break;
            }
            case "selected": {
                PickableUnit p = Reflect.getSelectedUnit(hud.getSelectBar());
                if (p == null) break;
                hud.sendAction(act, p.getId());
                break;
            }
            case "area": {
                ActionMod.sendAreaAction(act);
                break;
            }
            case "toolbelt": {
                if (id >= 1 && id <= 10) {
                    hud.setActiveTool(id - 1);
                    break;
                }
                hud.consoleOutput("act: Invalid toolbelt slot '" + id + "'");
                break;
            }
            default: {
                if (target.startsWith("@tb")) {
                    int slot = Integer.parseInt(target.substring(3));
                    if (slot >= 1 && slot <= 10 && hud.getToolBelt().getItemInSlot(slot - 1) != null) {
                        hud.sendAction(act, hud.getToolBelt().getItemInSlot(slot - 1).getId());
                        break;
                    }
                    hud.consoleOutput("act: Invalid toolbelt slot '" + slot + "'");
                    break;
                }
                hud.consoleOutput("act: Invalid target keyword '" + target + "'");
            }
        }
    }
}

