/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmonline.clientmods.livehudmap.renderer;

import com.wurmonline.client.game.NearTerrainDataBuffer;
import com.wurmonline.mesh.Tiles;
import java.awt.Color;
import java.awt.image.BufferedImage;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.AbstractSurfaceRenderer;

public class MapRendererIsometric
extends AbstractSurfaceRenderer {
    public MapRendererIsometric(NearTerrainDataBuffer buffer) {
        super(buffer);
    }

    @Override
    public BufferedImage createMapDump(int xo, int yo, int lWidth, int lHeight, int px, int py) {
        if (yo < 0) {
            yo = 0;
        }
        if (xo < 0) {
            xo = 0;
        }
        BufferedImage bi2 = new BufferedImage(lWidth, lHeight, 1);
        float[] data = new float[lWidth * lHeight * 3];
        int y0 = lHeight + lHeight / 2;
        for (int x = 0; x < lWidth; ++x) {
            int alt = y0 - 1;
            for (int y = y0 - 1; y >= -lHeight / 2 && alt >= 0; --y) {
                float node = (float)this.getSurfaceHeight(x + xo, y + yo) / 9929.395f;
                float node2 = y == y0 - 1 ? node : (float)this.getSurfaceHeight(x + 1 + xo, y + 1 + yo) / 9929.395f;
                float hh = node;
                float h = (node2 - node) * 1500.0f / 256.0f * 4096.0f / 128.0f + hh / 2.0f + 1.0f;
                float r = h *= 0.4f;
                float g = h;
                float b = h;
                Tiles.Tile tile = this.getTileType(x + xo, y + yo);
                Color color = tile != null ? tile.getColor() : Tiles.Tile.TILE_DIRT.getColor();
                r *= (float)color.getRed() / 255.0f * 2.0f;
                g *= (float)color.getGreen() / 255.0f * 2.0f;
                b *= (float)color.getBlue() / 255.0f * 2.0f;
                if (r < 0.0f) {
                    r = 0.0f;
                }
                if (r > 1.0f) {
                    r = 1.0f;
                }
                if (g < 0.0f) {
                    g = 0.0f;
                }
                if (g > 1.0f) {
                    g = 1.0f;
                }
                if (b < 0.0f) {
                    b = 0.0f;
                }
                if (b > 1.0f) {
                    b = 1.0f;
                }
                if (node < 0.0f) {
                    r = r * 0.2f + 0.16000001f;
                    g = g * 0.2f + 0.2f;
                    b = b * 0.2f + 0.4f;
                }
                if (px == x + xo && py == y + yo) {
                    r = 1.0f;
                    g = 0.0f;
                    b = 0.0f;
                }
                int altTarget = y - (int)((float)this.getSurfaceHeight(x + xo, y + yo) * 1000.0f / 4.0f / 13106.8f);
                while (alt > altTarget && alt >= 0) {
                    if (alt < lHeight) {
                        data[(x + alt * lWidth) * 3 + 0] = r * 255.0f;
                        data[(x + alt * lWidth) * 3 + 1] = g * 255.0f;
                        data[(x + alt * lWidth) * 3 + 2] = b * 255.0f;
                    }
                    --alt;
                }
            }
        }
        bi2.getRaster().setPixels(0, 0, lWidth, lHeight, data);
        return bi2;
    }
}

