/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmonline.clientmods.livehudmap.renderer;

import com.wurmonline.client.game.NearTerrainDataBuffer;
import com.wurmonline.mesh.Tiles;
import java.awt.Color;
import java.awt.image.BufferedImage;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.AbstractSurfaceRenderer;

public class MapRendererFlat
extends AbstractSurfaceRenderer {
    public MapRendererFlat(NearTerrainDataBuffer buffer) {
        super(buffer);
    }

    @Override
    public BufferedImage createMapDump(int xo, int yo, int lWidth, int lHeight, int px, int py) {
        if (yo < 0) {
            yo = 0;
        }
        if (xo < 0) {
            xo = 0;
        }
        BufferedImage bi2 = new BufferedImage(lWidth, lWidth, 1);
        float[] data = new float[lWidth * lWidth * 3];
        for (int x = 0; x < lWidth; ++x) {
            for (int y = lWidth - 1; y >= 0; --y) {
                short height = this.getSurfaceHeight(x + xo, y + yo);
                Tiles.Tile tile = this.getTileType(x + xo, y + yo);
                Color color = tile != null ? tile.getColor() : Tiles.Tile.TILE_DIRT.getColor();
                int r = color.getRed();
                int g = color.getGreen();
                int b = color.getBlue();
                if (height < 0) {
                    r = (int)((float)r * 0.2f + 40.960003f);
                    g = (int)((float)g * 0.2f + 51.2f);
                    b = (int)((float)b * 0.2f + 102.4f);
                }
                if (px == x + xo && py == y + yo) {
                    r = Color.RED.getRed();
                    g = 0;
                    b = 0;
                }
                data[(x + y * lWidth) * 3 + 0] = r;
                data[(x + y * lWidth) * 3 + 1] = g;
                data[(x + y * lWidth) * 3 + 2] = b;
            }
        }
        bi2.getRaster().setPixels(0, 0, lWidth, lWidth, data);
        return bi2;
    }
}

