/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmonline.clientmods.livehudmap.renderer;

import com.wurmonline.client.game.CaveDataBuffer;
import com.wurmonline.client.renderer.PickData;
import com.wurmonline.mesh.Tiles;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.gotti.wurmonline.clientmods.livehudmap.LiveHudMapMod;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.AbstractCaveRenderer;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.CaveColors;

public class MapRendererCave
extends AbstractCaveRenderer {
    public static boolean showHiddenOre;

    public MapRendererCave(CaveDataBuffer buffer) {
        super(buffer);
    }

    @Override
    public BufferedImage createMapDump(int xo, int yo, int lWidth, int lHeight, int px, int py) {
        if (yo < 0) {
            yo = 0;
        }
        if (xo < 0) {
            xo = 0;
        }
        BufferedImage bi2 = new BufferedImage(lWidth, lWidth, 1);
        float[] data = new float[lWidth * lWidth * 3];
        for (int x = 0; x < lWidth; ++x) {
            for (int y = lWidth - 1; y >= 0; --y) {
                short height = this.getHeight(x + xo, y + yo);
                Tiles.Tile tile = this.getEffectiveTileType(x + xo, y + yo);
                Color color = tile != null ? CaveColors.getColorFor(tile) : CaveColors.getColorFor(Tiles.Tile.TILE_CAVE);
                int r = color.getRed();
                int g = color.getGreen();
                int b = color.getBlue();
                if (height < 0 && tile == Tiles.Tile.TILE_CAVE) {
                    r = (int)((float)r * 0.2f + 40.960003f);
                    g = (int)((float)g * 0.2f + 51.2f);
                    b = (int)((float)b * 0.2f + 102.4f);
                }
                if (px == x + xo && py == y + yo) {
                    r = Color.RED.getRed();
                    g = 0;
                    b = 0;
                }
                data[(x + y * lWidth) * 3 + 0] = r;
                data[(x + y * lWidth) * 3 + 1] = g;
                data[(x + y * lWidth) * 3 + 2] = b;
            }
        }
        bi2.getRaster().setPixels(0, 0, lWidth, lWidth, data);
        return bi2;
    }

    private Tiles.Tile getEffectiveTileType(int x, int y) {
        Tiles.Tile tile = this.getTileType(x, y);
        if (!showHiddenOre && tile != Tiles.Tile.TILE_CAVE_WALL && !this.isTunnel(tile) && this.isSurroundedByRock(x, y)) {
            return Tiles.Tile.TILE_CAVE_WALL;
        }
        return tile;
    }

    private boolean isTunnel(int x, int y) {
        Tiles.Tile tileType = this.getTileType(x, y);
        return this.isTunnel(tileType);
    }

    private boolean isTunnel(Tiles.Tile tileType) {
        if (tileType == null) {
            return false;
        }
        return tileType == Tiles.Tile.TILE_CAVE || tileType == Tiles.Tile.TILE_CAVE_EXIT || tileType.isReinforcedFloor() || tileType.isRoad();
    }

    private boolean isSurroundedByRock(int x, int y) {
        return !this.isTunnel(x + 1, y) && !this.isTunnel(x - 1, y) && !this.isTunnel(x, y + 1) && !this.isTunnel(x, y - 1);
    }

    private int getQl(int x, int y, int sz) {
        Random r = new Random();
        r.setSeed((long)(x + y * sz) * 789221L);
        return 20 + r.nextInt(80);
    }

    @Override
    public void pick(PickData pickData, float xMouse, float yMouse, int width, int height, int px, int py) {
        int ox = px + (int)(xMouse * (float)width) - width / 2;
        int oy = py + (int)(yMouse * (float)height) - height / 2;
        Tiles.Tile tile = this.getEffectiveTileType(ox, oy);
        if (!this.isTunnel(tile)) {
            pickData.addText(tile.getName().replace(" wall", "").replace(" vein", "") + (LiveHudMapMod.serverSize > 0 ? String.format(" (%d QL)", this.getQl(ox, oy, LiveHudMapMod.serverSize)) : ""));
        }
    }
}

