/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmonline.clientmods.livehudmap;

import com.wurmonline.client.game.PlayerPosition;
import com.wurmonline.client.game.World;
import com.wurmonline.client.renderer.PickData;
import com.wurmonline.math.FastMath;
import java.awt.image.BufferedImage;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.MapRenderer;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.RenderType;

public class MapLayerView {
    private RenderType type;
    private MapRenderer renderer;
    private int zoom;
    private World world;

    public MapLayerView(World world, RenderType renderType) {
        this.world = world;
        this.zoom = 1;
        this.type = renderType;
        this.renderer = this.type.createMapRenderer(world);
    }

    public void zoomIn() {
        if (this.type.getMapSize() / this.zoom > 4) {
            this.zoom *= 2;
        }
    }

    public void zoomOut() {
        if (this.zoom > 1) {
            this.zoom /= 2;
        }
    }

    public BufferedImage render(int px, int py) {
        int sz = this.type.getMapSize() / this.zoom;
        return this.renderer.createMapDump(px - sz / 2, py - sz / 2, sz, sz, px, py);
    }

    public void setRenderer(RenderType renderType) {
        if (renderType != this.type) {
            this.type = renderType;
            this.renderer = this.type.createMapRenderer(this.world);
            if (this.type.getMapSize() / this.zoom < 4) {
                this.zoom = FastMath.nearestPowerOfTwo((int)(this.type.getMapSize() / 4));
            }
            if (this.zoom == 0) {
                this.zoom = 1;
            }
        }
    }

    public void pick(PickData pickData, float xMouse, float yMouse) {
        int sz = this.type.getMapSize() / this.zoom;
        PlayerPosition pos = this.world.getPlayer().getPos();
        this.renderer.pick(pickData, xMouse, yMouse, sz, sz, pos.getTileX(), pos.getTileY());
    }
}

