/*
 * Decompiled with CFR 0.152.
 */
package com.wurmonline.client.renderer.gui;

import com.wurmonline.client.renderer.backend.Queue;
import com.wurmonline.client.renderer.gui.ButtonListener;
import com.wurmonline.client.renderer.gui.WButton;
import com.wurmonline.client.resources.textures.Texture;

public class LiveMapButton
extends WButton {
    private final Texture texture;

    public LiveMapButton(String label, String hoverString, int width, int height, Texture texture, ButtonListener buttonListener) {
        super(label, buttonListener);
        if (!hoverString.isEmpty()) {
            this.setHoverString(hoverString);
        }
        this.sizeFlags = 0;
        this.setInitialSize(width, height, false);
        this.sizeFlags = 3;
        this.texture = texture;
    }

    protected void renderComponent(Queue queue, float alpha) {
        if (!this.hoverMode || this.hovered) {
            float r2 = this.r;
            float g2 = this.g;
            float b2 = this.b;
            if ((this.isCloseHovered || this.isDown) && this.isEnabled()) {
                r2 /= 2.0f;
                g2 /= 2.0f;
                b2 /= 2.0f;
            }
            if (this.texture != null) {
                this.drawTexture(queue, this.texture, r2, g2, b2, 1.0f, this.x, this.y, this.width, this.height, 0, 0, 256, 256);
            }
        }
        int yo2 = (this.isCloseHovered || this.isDown) && this.isEnabled() ? 1 : 0;
        float c = (this.isCloseHovered || this.isDown) && this.isEnabled() ? 0.8f : 1.0f;
        this.text.moveTo(this.x + 4 + 0, this.y + this.text.getHeight() + yo2 + 0);
        this.text.paint(queue, this.label, this.rText * c, this.gText * c, this.bText * c, 1.0f);
    }
}

