// jAnimation Flash Tools is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License //
//////////////////////////////
//	Created By: Jay Edry    //
//           2016           //
//	www.artisanimation.com	//
//////////////////////////////


jPlayLoop();
function jPlayLoop(){
	var doc = fl.getDocumentDOM();
	
	var loopStart = null;
	var loopEnd = null;
	var movieClipInstanceName = "MCPLAYSELECTED"
	var frmsArray = doc.getTimeline().getSelectedFrames(); 

	// check if there is selection made in timeline. If not request input
	if (frmsArray[0] == undefined || frmsArray[2]-frmsArray[1]<=1){
		while (true){
			loopStart = prompt("Enter Start Frame: ", 0);
			if (loopStart==null){
				return;
			}
			else if (loopStart >= 0 && loopStart <= 1000000){
				break;
			}
			else{
				alert("That input is not a valid. Please try again.")
			}
		}

		while (true){
			loopEnd = prompt("Enter End Frame: ", 0);
			if (loopEnd==null){
				return;
			}
			else if (loopEnd >= 0 && loopEnd <= 1000000){
				if (loopEnd<= loopStart){
					alert("End Frame must be greater the Start Frame. Please try again.")
				}
				else{
					break;
				}
			}
			else{
				alert("That input is not a valid. Please try again.")
			}
		}
	}
	else{
		loopStart = frmsArray[1];
		loopEnd = frmsArray[2];	
	}

	
	var isRootTimeline = false;
	var isSymbol = true;
	if (doc.getTimeline().libraryItem == undefined){
		isRootTimeline = true;
		isSymbol = false;
	}

	if (isSymbol){
		var currTimelineLibraryItem = doc.getTimeline().libraryItem.name;
		var viewMtrx = doc.viewMatrix; // matrix of current timeline
		doc.currentTimeline = 0; // go to root Scene
	}
	
	doc.getTimeline().setSelectedFrames([0, 0, 1]); // select first frame and layer
	doc.getTimeline().addNewLayer("_SCRIPT_", "normal", true); // make a layer above the top layer
	doc.getTimeline().setSelectedFrames([0, 0, 1]);
	
	if (isSymbol){
		while (!doc.library.addItemToDocument({x:0, y:0}, currTimelineLibraryItem)){}
		doc.getTimeline().setSelectedFrames([0, 0, 1]);
		var slctn = doc.getTimeline().layers[0].frames[0].elements[0];
		slctn.matrix = viewMtrx;
		slctn.symbolType = "movie clip";
		doc.setElementProperty("name",movieClipInstanceName);
	}
	if (isRootTimeline){
		movieClipInstanceName = "this";
	}
	doc.getTimeline().setFrameProperty("actionScript", myScript(loopStart, loopEnd, movieClipInstanceName));

	if (isSymbol){
		var visibleLayers = [];
		for (var i=0 ; i < doc.getTimeline().layerCount ; i++){
			if (fl.getDocumentDOM().getTimeline().layers[i].visible){
				visibleLayers.push(i);
			}
		}
		// hide all other layers
		doc.getTimeline().setLayerProperty('visible', false, 'all');
		doc.getTimeline().layers[0].visible = true;
	}
	// change profile and publish
	tmpChangePublishProfileAndTest();
	
	if (isSymbol){
		// revert to original visible layers
		for (var i=0 ; i < visibleLayers.length ; i++){
			fl.getDocumentDOM().getTimeline().layers[visibleLayers[i]].visible = true;
		}
	}
	
	// delete the uneeded layer
	fl.getDocumentDOM().getTimeline().deleteLayer(0);
}

function tmpChangePublishProfileAndTest(){
	var doc=fl.getDocumentDOM();
	var profile;
	var flashFileName;
	 
	//Delete a prev attempted temp profile
	if (doc.publishProfiles.indexOf('@temp') != -1) {
	  doc.currentPublishProfile = '@temp';
	  doc.deletePublishProfile();
	}
	 //InvisibleLayer
	//Make a copy of the 1st profile and tweak
	doc.currentPublishProfile=doc.publishProfiles[0]; 
	profile=new XML(doc.exportPublishProfileString());
	flashFileName=profile.PublishFormatProperties.flashFileName.split('.').shift();
	doc.addNewPublishProfile('@temp');
	doc.currentPublishProfile='@temp';
	profile.@name="@temp";
	profile.PublishFlashProperties.InvisibleLayer='0';
	doc.importPublishProfileString(profile);

	
	if(fl.getDocumentDOM().canTestMovie()){
		fl.getDocumentDOM().testMovie();
	}
	
	//delete the temp profile
	doc.deletePublishProfile();
}

function myScript(loopStart, loopEnd, movieClipInstanceName){
	var myScript = "";
	myScript+="\n" + "import flash.events.Event;"
	myScript+="\n" + "var loopStart:int = "
	myScript+= String(loopStart+1)
	myScript+= ";"
	myScript+="\n" + "var loopEnd:int = "
	myScript+= String(loopEnd+1)
	myScript+= ";"
	myScript+="\n" + movieClipInstanceName+".gotoAndPlay(loopStart);"
	myScript+="\n" + movieClipInstanceName+".addEventListener(Event.ENTER_FRAME, jayLoop);"
	myScript+="\n" + "function jayLoop(e:Event):void"
	myScript+="\n" + "{"
	myScript+="\n" + "	if ("+movieClipInstanceName+".currentFrame >= loopEnd)"
	myScript+="\n" + "	{"
	myScript+="\n" + "		"+movieClipInstanceName+".gotoAndPlay(loopStart);"
	myScript+="\n" + "	}"
	myScript+="\n" + "	if ("+movieClipInstanceName+".currentFrame < loopStart)"
	myScript+="\n" + "	{"
	myScript+="\n" + "		"+movieClipInstanceName+".gotoAndPlay(loopStart);"
	myScript+="\n" + "	}"	
	myScript+="\n" + "}"
	
	return myScript;
}
