

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;
[Command]
name = "TripleKFPalm"
command = ~B, D, $F, $B, y
time = 30

[Command]
name = "TripleKFPalm"   ;Same name as above
command = ~B, D, $F, $B, ~y
time = 30
buffer.time=12


;-| Special Motions |------------------------------------------------------

[Command]
name = "QCF_x"
command = ~D,$D, F, x

[Command]
name = "QCF_y"
command =~D,$D, F, y

[Command]
name ="QCF_x"
command = ~D,$D, F, ~x
buffer.time=5

[Command]
name = "QCF_y"
command =~D,$D, F, ~y
buffer.time=5

[Command]
name = "QCB_x"
command = ~D,$D, B, x

[Command]
name = "QCB_y"
command =~D,$D,B, y

[Command]
name ="QCB_x"
command = ~D,$D, B, ~x
buffer.time=5

[Command]
name = "QCB_y"
command =~D,$D, B, ~y
buffer.time=5


[Command]
name = "QCF_a"
command = ~F,$D, D, a

[Command]
name = "QCF_b"
command =~F,$D, D, b

[Command]
name ="QCF_a"
command = ~F,$D, D, ~a
buffer.time=5

[Command]
name = "QCF_b"
command =~F,$D, D, ~b
buffer.time=5





;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1
buffer.time=3
[Command]
name = "b"
command = b
time = 1
buffer.time=3
[Command]
name = "c"
command = c
time = 1
buffer.time=3
[Command]
name = "x"
command = x
time = 1
buffer.time=3
[Command]
name = "y"
command = y
time = 1
buffer.time=3
[Command]
name = "z"
command = z
time = 1
buffer.time=3

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;------------------------------------------------------------------------
[State -1, AIgh]
type = ChangeState
value = 3000
triggerall = AILevel >0 && roundstate = 2
triggerall = (p2stateno!=[120,155])
trigger1 =  (p2bodydist x=[0,120]) && ctrl
trigger2= (stateno=210||(stateno=240)||stateno=410||stateno=200||stateno=400)&&movehit
triggerall = ((p2bodydist y = [-90,0]))
triggerall = random<199
triggerall = life <= lifemax/3
triggerall = var(3)=0
triggerall = var(4)=0
triggerall = stateno != [800,3999]
triggerall = movetype!=H
triggerall = p2statetype!=L
triggerall = (Statetype!=A)
;--------------------------------------------
[State -1, Guard]
type = ChangeState
value = 120
triggerall = movetype !=H
triggerall = roundstate = 2
triggerall = stateno!=[120,155]
triggerall=AILevel>0
triggerall = statetype!=A
triggerall =(StateNo !=[200,3999])&&(StateNo != 105)
triggerall = Random < 113* AILevel
triggerall =InGuardDist || enemynear,hitdefattr=SCA,NP,SP,HP || enemynear,hitdefattr = SCA,AA
triggerall =((EnemyNear, movetype=A&& enemynear,hitdefattr!=SCA,AA)||( enemynear,hitdefattr=SCA,NP,SP,HP || enemynear,hitdefattr = SCA,AA))|| enemy,numproj >0
trigger1 = ctrl ||stateno=20
;-----------------------------------------------------
[State -1, AIRun Back]
type = ChangeState
value = 105
triggerall = AILevel >0
triggerall = stateno !=105
triggerall = statetype != A
triggerall = random <  22*AILevel
triggerall = roundstate = 2
trigger1 = (((p2statetype =L) || p2movetype = A )&& backedgedist >40 && (p2bodydist x=[-99,45])) && ctrl 
trigger2 = (stateno=[200,430])&&moveguarded && backedgedist >60


;------------------------------------------------------------------------
[State -1, AI Throw]
type = ChangeState
value = 800
triggerall = random <= 30*AILevel
triggerall = AILevel >0
triggerall= ((p2statetype != A)&&statetype!=A) || ((p2statetype = A)&&statetype=A)
triggerall = ctrl || stateno=20
triggerall = stateno != [200,9999]
Triggerall = (RoundState = 2)
triggerall = (p2MoveType != H)
trigger1 = p2bodydist X < 27 && (p2bodydist y = [-20,20])
trigger2 = (p2stateno =[120,150]) &&(p2bodydist X < 27 && (p2bodydist y = [-20,20]))
;------------------------------------------------------------------------
[State -1, AI Throw]
type = ChangeState
value = 801
triggerall = random <= 30*AILevel
triggerall = AILevel >0
triggerall = statetype != A
triggerall= ((p2statetype != A)&&statetype!=A)
triggerall = ctrl || stateno=20
triggerall = stateno != [200,9999]
Triggerall = (RoundState = 2)
triggerall = (p2MoveType != H)
trigger1 = p2bodydist X < 27 && (p2bodydist y = [-20,20])
trigger2 = (p2stateno =[120,150]) &&(p2bodydist X < 27 && (p2bodydist y = [-20,20]))
;---------------------------------------------------------------------------
;Stand Light Punch
;p`
[State -1, Stand Light Punch]
type = ChangeState
value = 200
Triggerall = (RoundState = 2) && (AILevel >0)
Triggerall = (StateType != A)
triggerall = (stateno != [800,3999])
Triggerall = P2BodyDist X = [0,80]
Triggerall = Random < 63*AILevel
triggerall = p2statetype !=L
triggerall = p2bodydist y=0
triggerall = helper(10003),var(8)=0
triggerall = p2statetype != C
triggerall = var(3)=0
trigger1 = (ctrl||stateno=[10,20])&& (helper(10003),var(10)>0||helper(10003),var(11)>0)&& p2bodydist x <50
trigger2 =(ctrl||stateno=[10,20]) && (p2bodydist x=[25,80]) && p2statetype=S && p2movetype=I&&random <199
trigger3 = stateno = 200 && movecontact
trigger4= stateno = 400 && movecontact
trigger5 = (stateno = 230) && movecontact
trigger6 = (stateno = 430) && movecontact


;---------------------------------------------------------------------------
;Stand Strong Punch
;p`
[State -1, Stand strong Punch]
type = ChangeState
value = 210
Triggerall = (RoundState = 2) && (AILevel >0)
Triggerall = (StateType != A)
triggerall = (stateno != [800,3999])
Triggerall = Random < 70*AILevel
triggerall = p2statetype !=L
triggerall = p2bodydist y=0
triggerall = helper(10003),var(8)=0
triggerall = p2statetype != C
Triggerall = P2BodyDist X = [0,90]
triggerall = var(3)=0
trigger1 = (ctrl||stateno=[10,20])&& helper(10003),var(11)>0
trigger2=(ctrl||stateno=[10,20])  && (p2bodydist x=[55,90]) && p2statetype=A&&p2movetype!=H &&enemy,vel y >-2 
trigger3 =(ctrl||stateno=[10,20]) && (p2bodydist x=[55,90]) && p2statetype=S && p2movetype=I&&random <199
trigger4 = stateno = 200 && movecontact
trigger5= stateno = 400 && movecontact
trigger6 = (stateno = 230) && movecontact
trigger7 = (stateno = 430) && movecontact


;---------------------------------------------------------------------------
;Stand Light Kick
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value =230
Triggerall = (RoundState = 2) && (AILevel >0)
Triggerall = (StateType != A)
triggerall = (stateno != [800,3999])||var(5)=1
Triggerall =Random < 45*AILevel
triggerall = p2statetype !=L
triggerall = (p2bodydist y=0)&&enemy,vel y>=0
triggerall = p2bodydist x = [0,45]
triggerall = helper(10003),var(8)=0
triggerall = p2statetype != C
triggerall = var(3)=0
trigger1 = (ctrl||stateno=[10,20])&& (helper(10003),var(10)>0||helper(10003),var(11)>0)&& p2bodydist x <30
trigger2 = stateno = 200 && movecontact
trigger3= stateno = 400 && movecontact
trigger4 = (stateno = 230) && movecontact
trigger5 = (stateno = 430) && movecontact



;---------------------------------------------------------------------------
;Standing medium Kick
;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value =240
Triggerall = (RoundState = 2) && (AILevel >0)
Triggerall = (StateType != A)
triggerall = (stateno != [800,3999])
Triggerall =Random < 70*AILevel
triggerall = p2statetype !=L
triggerall = helper(10003),var(8)=0
triggerall = p2bodydist y=0
Triggerall = ((P2BodyDist X = [0,75])&&movehit)||((p2bodydist x =[50,75])&&ctrl)
triggerall = (p2bodydist y=[0,-70])&&enemy,vel y>=0
triggerall = var(3)=0
triggerall = var(4)=0
triggerall = p2statetype!=C
trigger1 = (ctrl||stateno=[10,20])&& helper(10003),var(11)>0
trigger2 =(ctrl||stateno=[10,20]) && (p2bodydist x=[45,75]) && p2statetype=S && p2movetype=I&&random <199
trigger3 = stateno = 200 && movecontact
trigger4= stateno = 400 && movecontact
trigger5 = (stateno = 230) && movecontact
trigger6 = (stateno = 430) && movecontact



;------------------------------------------------------
[State -1, AI5]
Type = ChangeState
Triggerall = (RoundState = 2) && (AILevel >0)
Triggerall = (StateType != A)
triggerall = (stateno != [800,3999])||var(5)=1
Triggerall = (P2BodyDist X = [0,80])&&(P2BodyDist Y = 0 )
Triggerall = Random < 70*AILevel
triggerall = (p2statetype !=L)
triggerall = (movetype !=H)
triggerall = var(3)=0
trigger1 = (ctrl||stateno=[10,20])&& (helper(10003),var(10)>0||helper(10003),var(11)>0)&& p2bodydist x <50
trigger2 = stateno = 200 && movecontact
trigger3= stateno = 400 && movecontact
trigger4 = (stateno = 230) && movecontact
trigger5 = (stateno = 430) && movecontact
value = 400

;------------------------------------------------------
[State -1, AI2]
Type = ChangeState
Triggerall = (RoundState = 2) && (AILevel >0)
Triggerall =  (StateType != A)
triggerall = (stateno != [800,3999])
Triggerall = (p2bodydist x =[0,95])
triggerall = p2bodydist y=0&&p2statetype!=A
Triggerall =Random < 70*AILevel
triggerall = p2statetype !=L
triggerall = (movetype !=H)
triggerall = helper(10003),var(8)=0
triggerall = var(3)=0
trigger1 = (ctrl||stateno=[10,20])&& helper(10003),var(11)>0
trigger2 =(ctrl||stateno=[10,20]) && (p2bodydist x=[65,95]) && p2statetype=S && p2movetype=I&&random <199
trigger3 = stateno = 200 && movecontact
trigger4= stateno = 400 && movecontact
trigger5 = (stateno = 230) && movecontact
trigger6 = (stateno = 430) && movecontact
value = 410
;------------------------------------------------------
[State -1, AI9]
Type = ChangeState
Triggerall = (RoundState = 2) && (AILevel >0)
Triggerall = StateType != A
triggerall = stateno != [800,3999]
Triggerall = P2BodyDist X = [0,40]
triggerall = (movetype !=H)||p2statetype=S
Triggerall = ( Random < 70*AILevel) && (p2statetype != A && enemy,statetype !=L)
triggerall = var(3)=0
trigger1 = (ctrl||stateno=[10,20])&& (helper(10003),var(10)>0||helper(10003),var(11)>0)&& p2bodydist x <30
trigger2= p2statetype=S&&ctrl
trigger3 = stateno = 200 && movecontact
trigger4= stateno = 400 && movecontact
trigger5 = (stateno = 230) && movecontact
trigger6 = (stateno = 430) && movecontact
trigger7 = p2movetype=H && ctrl && p2statetype!=L
trigger8= var(4)=1&&ctrl
value = 430

;------------------------------------------------------
[State -1, AI8]
Type = ChangeState
Triggerall = (RoundState = 2) && (AILevel >0)
Triggerall = StateType != A
triggerall = stateno != [800,3999]
Triggerall = P2BodyDist X = [0,85]
triggerall = (movetype !=H)
Triggerall = ( Random < 53*AILevel) && (enemy,statetype !=L) && p2statetype!=A
triggerall = var(3)=0
triggerall = helper(10003),var(8)=0
triggerall= (p2statetype=S && p2movetype=A)
trigger1 =(ctrl||stateno=[10,20]) && (p2bodydist x=[55,85]) && p2statetype=S && p2movetype=I&&random <199
trigger2= p2statetype=S&&ctrl
trigger3 = stateno = 200 && movecontact
trigger4= stateno = 400 && movecontact
trigger5 = (stateno = 230) && movecontact
trigger6 = (stateno = 430) && movecontact
value = 440
;---------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall =AILevel >0
triggerall = statetype = A
triggerall = (movetype !=H)
Triggerall = (P2BodyDist X = [-10,50])
Triggerall = Random <= 50*AILevel
triggerall = roundstate = 2
triggerall = stateno!=[100,105]
triggerall = vel y <=0
triggerall = p2statetype=A
triggerall= p2bodydist y =[-20,80]
trigger1 = ctrl

;---------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall =AILevel >0
triggerall = statetype = A
triggerall = (movetype !=H)
Triggerall = (P2BodyDist X = [-0,80])
Triggerall = Random <= 35*AILevel
triggerall = roundstate = 2
triggerall = vel y >=0
triggerall = stateno!=[100,105]
triggerall= p2bodydist y =[-20,70]
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall =AILevel >0
triggerall = statetype = A
triggerall = (movetype !=H)
Triggerall = (P2BodyDist X = [-20,70])
Triggerall = Random <= 70*AILevel
triggerall = roundstate = 2
triggerall = stateno!=[100,105]
triggerall = vel y >=0
triggerall= p2bodydist y =[-20,60]
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump medium Kick
[State -1, Jump medium Kick]
type = ChangeState
value = 640
triggerall =AILevel >0
triggerall = statetype = A
triggerall = (movetype !=H)
Triggerall = (P2BodyDist X = [-15,90])
Triggerall = Random <= 70*AILevel
triggerall = roundstate = 2
triggerall = stateno!=[100,105]
triggerall = vel y >=0
triggerall= p2bodydist y =[-20,80]
trigger1 = ctrl

;------------------------------------------------------------------
;Jump medium Kick
[State -1, Jump medium Kick]
type = ChangeState
value = 1020
triggerall = AILevel >0 && roundstate = 2
trigger1 =   (ctrl||stateno=[10,20]) && (helper(10003),var(30) ||helper(10003),var(31)) 
trigger2= stateno=105 && p2bodydist x <120
triggerall = random<55*AILevel
triggerall = stateno != [800,3999]
triggerall = p2bodydist x >70 
triggerall = movetype!=H
triggerall = p2statetype!=L
triggerall = (Statetype=A)
;------------------------------------------------------------------
;Jump medium Kick
[State -1, Jump medium Kick]
type = ChangeState
value = 1000
triggerall = AILevel >0 && roundstate = 2
triggerall = (p2stateno!=[120,155])
trigger1 = (ctrl||stateno=[10,20]) && (helper(10003),var(20) ||helper(10003),var(21)) 
trigger2=(stateno=210||stateno=240||stateno=410||stateno=430)&&movecontact
trigger3=(stateno=440)&&moveguarded
triggerall = random<49*AILevel
triggerall = stateno != [800,3999]
triggerall = (p2bodydist x =[45,155])
triggerall = movetype!=H
triggerall = p2statetype!=L
triggerall = p2statetype!=A
triggerall = (Statetype!=A)
;------------------------------------------------------------------
;Jump medium Kick
[State -1, Jump medium Kick]
type = ChangeState
value = 1010
triggerall = AILevel >0 && roundstate = 2
triggerall = (p2stateno!=[120,155])
trigger1 = (ctrl||stateno=[10,20]) && (helper(10003),var(20) ||helper(10003),var(21)) 
triggerall = random<49*AILevel
triggerall = stateno != [800,3999]
triggerall = p2bodydist x >120
triggerall = movetype!=H
triggerall = p2statetype!=L
triggerall = p2statetype!=A
triggerall = (Statetype!=A)

;----------------------------------------------------------

[state -1, AI jump]
type = changestate
triggerall=AILevel>0
triggerall = p2statetype !=L||p2stateno=5120
triggerall = (p2stateno!=[5090,5119]) &&(p2stateno!=[5121,5899])
triggerall = statetype != A
triggerall = var(30)=1
trigger1 = (ctrl||stateno=[10,20])&&var(30)=1
value = 40


[State -1, AI run]
type=changestate
value=20
triggerall = roundstate = 2
triggerall=AILevel >0 && statetype!=A && ctrl && random < 15*AILevel
trigger1= (stateno!=[20,105]) && p2movetype!=A && (p2bodydist x>=20)




;---------------------------------------------------------------------------
;Triple Kung Fu Palm (uses one super bar)
[State -1, Triple Kung Fu Palm]
type = ChangeState
value = 3000
triggerall = AILevel =0
triggerall = command = "TripleKFPalm"
triggerall = life <= lifemax/3
trigger1 = ctrl
trigger2= (stateno=[200,440])&&movecontact
triggerall = statetype != A


;===========================================================================
;This is not a move, but it sets up var(1) to be 1 if conditions are right
;for a combo into a special move (used below).
;Since a lot of special moves rely on the same conditions, this reduces
;redundant logic.
[State -1, Combo condition Reset]
type = VarSet
trigger1 = 1
var(1) = 0

[State -1, Combo condition Check]
type = VarSet
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = stateno != 440 ;Except for sweep kick
trigger2 = movecontact
trigger3 = stateno = 1310 || stateno = 1330 ;From blocking
var(1) = 1


;---------------------------------------------------------------------------
;Light Kung Fu Palm
[State -1, Light Kung Fu Palm]
type = ChangeState
value = 1000
triggerall = command = "QCF_x"||command = "QCF_y"
triggerall = statetype!=A
triggerall = numhelper(1001)<1
triggerall = AILevel =0
triggerall = numhelper(1011)<1
triggerall = numhelper(1021)<1
trigger1 = ctrl
trigger2= (stateno=[200,440])&&movecontact


;---------------------------------------------------------------------------
;Light Kung Fu Palm
[State -1, Light Kung Fu Palm]
type = ChangeState
value = 1010
triggerall = command = "QCB_x"||command = "QCB_y"
triggerall = statetype!=A
triggerall = numhelper(1001)<1
triggerall = AILevel =0
triggerall = numhelper(1011)<1
triggerall = numhelper(1021)<1
trigger1 = ctrl
trigger2= (stateno=[200,440])&&movecontact


;---------------------------------------------------------------------------
;Light Kung Fu Palm
[State -1, Light Kung Fu Palm]
type = ChangeState
value = 1020
triggerall = command = "QCF_a"||command = "QCF_b"
triggerall = statetype=A
triggerall = numhelper(1001)<1
triggerall = AILevel =0
triggerall = numhelper(1011)<1
triggerall = numhelper(1021)<1
trigger1 = ctrl
trigger2= stateno=105



;===========================================================================


;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = command = "BB"
triggerall = statetype != A
triggerall = AILevel =0
trigger1 = ctrl||((stateno=[200,440])&&movecontact)

;---------------------------------------------------------------------------
;Kung Fu Throw
[State -1, Kung Fu Throw]
type = ChangeState
value = 801
triggerall = command = "y"
triggerall = (statetype !=A&&command!="holddown")
triggerall = ctrl
triggerall = AILevel =0
triggerall = stateno != 100
trigger1 = command = "holdfwd" || command = "holdback"
trigger1 = p2bodydist X < 25  && (p2bodydist y=[-25,25])
trigger1 = (p2statetype != A&&statetype!=A)
trigger1 = p2movetype != H
;---------------------------------------------------------------------------
;Kung Fu Throw
[State -1, Kung Fu Throw]
type = ChangeState
value = 800
triggerall = command = "b"
triggerall = (statetype !=A&&command!="holddown") || (statetype=A || p2statetype=A)
triggerall = ctrl
triggerall = AILevel =0
triggerall = stateno != 100
trigger1 = command = "holdfwd" || command = "holdback"
trigger1 = p2bodydist X < 25  && (p2bodydist y=[-25,25])
trigger1 = (p2statetype != A&&statetype!=A) || (statetype=A || p2statetype=A)
trigger1 = p2movetype != H




;===========================================================================
;---------------------------------------------------------------------------
;Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = statetype != A
triggerall = AILevel =0
trigger1 = ctrl
trigger2 = stateno = 200 && movecontact
trigger3= stateno = 400 && movecontact
trigger4 = (stateno = 230) && movecontact
trigger5 = (stateno = 430) && movecontact

;---------------------------------------------------------------------------
;Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = statetype != A
triggerall = AILevel =0
trigger1 = ctrl
trigger2 = stateno = 200 && movecontact
trigger3= stateno = 400 && movecontact
trigger4 = (stateno = 230) && movecontact
trigger5 = (stateno = 430) && movecontact

;---------------------------------------------------------------------------
;Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = statetype != A
triggerall = AILevel =0
trigger1 = ctrl
trigger2 = stateno = 200 && movecontact
trigger3= stateno = 400 && movecontact
trigger4 = (stateno = 230) && movecontact
trigger5 = (stateno = 430) && movecontact


;---------------------------------------------------------------------------
;Standing Strong Kick
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = statetype != A
triggerall = AILevel =0
trigger1 = ctrl
trigger2 = stateno = 200 && movecontact
trigger3= stateno = 400 && movecontact
trigger4 = (stateno = 230) && movecontact
trigger5 = (stateno = 430) && movecontact



;---------------------------------------------------------------------------
;Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
triggerall = statetype != A
triggerall = AILevel =0
trigger1 = ctrl
trigger2 = stateno = 200 && movecontact
trigger3= stateno = 400 && movecontact
trigger4 = (stateno = 230) && movecontact
trigger5 = (stateno = 430) && movecontact


;---------------------------------------------------------------------------
;Crouching Strong Punch
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = statetype != A
triggerall = AILevel =0
trigger1 = ctrl
trigger2 = stateno = 200 && movecontact
trigger3= stateno = 400 && movecontact
trigger4 = (stateno = 230) && movecontact
trigger5 = (stateno = 430) && movecontact


;---------------------------------------------------------------------------
;Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
triggerall = statetype != A
triggerall = AILevel =0
trigger1 = ctrl
trigger2 = stateno = 200 && movecontact
trigger3= stateno = 400 && movecontact
trigger4 = (stateno = 230) && movecontact
trigger5 = (stateno = 430) && movecontact

;---------------------------------------------------------------------------
;Crouching Strong Kick
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
triggerall = statetype != A
triggerall = AILevel =0
trigger1 = ctrl
trigger2 = stateno = 200 && movecontact
trigger3= stateno = 400 && movecontact
trigger4 = (stateno = 230) && movecontact
trigger5 = (stateno = 430) && movecontact


;---------------------------------------------------------------------------
;Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
v
trigger1 = statetype = A
trigger1 = ctrl


;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
triggerall = AILevel =0
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
triggerall = AILevel =0
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
;Jump Strong Kick
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
triggerall = AILevel =0
trigger1 = statetype = A
trigger1 = ctrl

