'''
screen mainUI():
    if explore:  
        use exploration

screen exploration:
    hbox:
        spacing 10
        pass
    '''
label monster_menu_label(monster, location_label):
    $ monster_menu(monster, location_label)
    return

init python:
    
    def buy_item_menu(available_items, shop_label):    # available_items is a list of item_keys 
        if not available_items:    # validate input
            renpy.notify("No items available for purchase.")
            renpy.jump(shop_label)
        menu_choices = []    # create a list to store menu choices
        for item in available_items:    # iterate through available_items to create menu choices
            if item in items.values():
                display_text = f"{item.name}: {item.price} credits"
                menu_choices.append((display_text, item))    # add tuple to menu_choices (display_text, item_key)
            else:
                renpy.notify("Error: Shop tried to sell an item that doesn't exist.")
        menu_choices.append(("Done shopping.", 'back'))
        choice = renpy.display_menu(menu_choices)
        if choice == 'back':
            renpy.jump(shop_label)
        else:
            buy_item(choice, shop_label)
            renpy.jump(buy_label)
        return choice

    def build_menu():
        global money
        menu_choices = []
        if 'miia_room' not in player_rooms:
            display_text = "Build Miia's room. Price: 2 Wooden Boards, 5 Nails, 10 Credits."
            menu_choices.append((display_text, 'miia'))
        '''
        if 'papi_room' not in player_rooms:
            display_text = "Build Papi's room. Price: 40 Wooden Boards, 80 Nails, 500 Credits."
            menu_choices.append((display_text, 'papi'))
        if 'centorea_room' not in player_rooms:
            display_text = "Build Centorea's room. Price: 50 Wooden Boards, 100 Nails, 50 Credits."
            menu_choices.append((display_text, 'centorea'))
        if 'mero_room' not in player_rooms:
            display_text = "Build Mero's room. Price: 50 Wooden Boards, 100 Nails, 50 Credits."
            menu_choices.append((display_text, 'mero'))
            '''
        menu_choices.append(("Go back.", 'back'))
        choice = renpy.display_menu(menu_choices)
        if choice == 'back':
            renpy.jump('construction_office')
        elif choice == 'miia':
            if 'nails' not in player_items or 'wooden_boards' not in player_items:
                renpy.notify("You do not have the required materials to build Miia's room.")
                build_menu()
            if money >= 10 and player_items['nails'] >= 5 and player_items['wooden_boards'] >= 2:
                player_rooms.add('miia_room')
                miia_room.exists = True
                money -= 10
                items['nails'].remove(5)
                items['wooden_boards'].remove(2)
                renpy.notify("Miia's room has been built.")
                miia.assign_monster_room()
            else:
                renpy.notify("You do not have the required materials to build Miia's room.")
                build_menu()
        elif choice == 'papi':
            if 'nails' not in player_items or 'wooden_boards' not in player_items:
                renpy.notify("You do not have the required materials to build Papi's room.")
                build_menu()
            if money >= 500 and player_items['nails'] >= 80 and player_items['wooden_boards'] >= 40:
                player_rooms.add('papi_room')
                money -= 500
                items['nails'].remove(80)
                items['wooden_boards'].remove(40)
                renpy.notify("Papi's room has been built.")
                papi.assign_monster_room()
            else:
                renpy.notify("You do not have the required materials to build Papi's room.")
                build_menu()
        elif choice == 'centorea':
            pass
        elif choice == 'mero':
            pass
        else:
            renpy.notify(f"Error: menu choice '{choice}' does not exist")
        build_menu()

    def monster_menu(monster, location_label):
        menu_choices = []
        display_text = f"Talk to {monster.name}."
        menu_choices.append((display_text, 'talk'))
        display_text = f"Give {monster.name} a gift."
        menu_choices.append((display_text, 'gift'))
        display_text = "Attempt intimacy."
        menu_choices.append((display_text, 'intimacy'))
        display_text = f"Give {monster.name} a work assignment."
        menu_choices.append((display_text, 'work'))
        display_text = f"Care for {monster.name}."
        menu_choices.append((display_text, 'caretaking'))
        display_text = f"Give {monster.name} a training assignment."
        menu_choices.append((display_text, 'training'))
        display_text = "Check on her emotions."
        menu_choices.append((display_text, 'emotions'))
        display_text = "Clear assignments."
        menu_choices.append((display_text, 'clear'))
        menu_choices.append(("Go back.", 'back'))
        choice = renpy.display_menu(menu_choices)
        if choice == 'back':
            renpy.jump(location_label)
        elif choice == 'talk':
            monster.talk()
        elif choice == 'gift':
            monster.give_gift()
        elif choice == 'intimacy':
            if monster.intimacy_check():
                if monster.key == 'miia':
                    if miia.level_stats['intimacy_scene'] >= 2 and not chapter_2_bool:
                        renpy.jump('chapter_2')
                    elif miia.level_stats['intimacy_scene'] == 1:
                        renpy.jump('miia_bath')
                    else:
                        renpy.notify("Miia's intimacy conditions not currently satisifed.")
        elif choice == 'work':
            work_menu(monster, location_label)
        elif choice == 'caretaking':
            caretaking(monster)
        elif choice == 'training':
            if training_tutorial and monster.job_stats['can_work']:
                training_menu(monster, location_label)
            elif not monster.job_stats['can_work']:
                renpy.notify(f"{monster.name} cannot accept assignments until you properly care for her.")
            else:
                renpy.notify("Progress through the tutorial to unlock skill training.")
        elif choice == 'emotions':
            if monster.emotions['anger'] >=40:
                if monster.key == 'miia':
                    renpy.play("audio/voice/miia/miia_annoyed.opus")
            else:
                renpy.play("audio/voice/miia/miia_endearing.opus")
            renpy.say(None, f"{monster.name}  —  Happiness: {monster.emotions['happiness']}/{monster.emotions['max_happiness']},  Motivation: {monster.emotions['motivation']}/{monster.emotions['max_motivation']},  Lust: {monster.emotions['lust']}/{monster.emotions['max_lust']},  Jealousy: {monster.emotions['jealousy']}/{monster.emotions['max_jealousy']},  Anger: {monster.emotions['anger']}/{monster.emotions['max_anger']}.")
        elif choice == 'clear':
            monster.set_not_working()
            monster.set_not_training()
        else:
            renpy.notify(f"Error: menu choice '{choice}' does not exist")
        monster_menu(monster, location_label)        

    def work_menu(monster, location_label):
        menu_choices = []
        job_choices = []
        display_text = f"Assign work for {monster.name}."
        menu_choices.append((display_text, 'assign'))
        display_text = f"Clear {monster.name}'s work assignment."
        menu_choices.append((display_text, 'unassign'))
        display_text = f"Check {monster.name}'s expected earnings."
        menu_choices.append((display_text, 'earnings'))
        menu_choices.append(("Go back.", 'back'))
        choice = renpy.display_menu(menu_choices)
        if choice == 'assign':
            for job in jobs.values():
                if job.passive_unlocked:
                    job_choices.append(job)
            if len(job_choices) == 0:
                renpy.notify("No job assignments unlocked.")
            else:
                if passive_work_tutorial:
                    job_assignment_menu(monster, job_choices, location_label)
                else:
                    renpy.notify("Progress through the tutorial to unlock work assignments.")
        elif choice == 'unassign':
            monster.set_not_working()
        elif choice == 'earnings':
            if monster.job_stats['is_working']:
                monster.update_monster_income()
                renpy.say(None, f"{monster.name} promises to work {monster.job_stats['working_hours']} hours at the {jobs[monster.job_stats['assigned_job']].location_name} and earn {monster.job_stats['passive_income']} credits. Skill Modifier: {1 + ( (monster.level_stats['skill_level'] - jobs[monster.job_stats['assigned_job']].required_skill_level) * 0.2)}")
            else:
                renpy.notify(f"{monster.name} has no work assignment.")
        elif choice == 'back':
            monster_menu(monster,location_label)
        else:
            renpy.notify(f"Error: menu choice '{choice}' does not exist")
        work_menu(monster, location_label)
    
    def job_assignment_menu(monster, job_choices, location_label):
        menu_choices = []
        for job in job_choices:
            display_text = f"Assign {monster.name} to work as {job.name}."
            menu_choices.append((display_text, job))
        menu_choices.append(("Go back to work menu.", 'back_work'))
        menu_choices.append(("Go back to monster menu.", 'back_monster'))
        choice = renpy.display_menu(menu_choices)
        if choice == 'back_work':
            work_menu(monster, location_label)
        elif choice == 'back_monster':
            monster_menu(monster, location_label)
        else:
            if choice not in jobs.values():
                renpy.notify(f"Error: {choice} is not a job and cannot be assigned.")
            else:
                monster.assign_job(choice)
    
    def training_menu(monster, location_label):
        menu_choices = []
        display_text = f"Assign training for {monster.name}."
        menu_choices.append((display_text, 'assign'))
        display_text = f"Clear {monster.name}'s training assignment."
        menu_choices.append((display_text, 'unassign'))
        display_text = f"Check {monster.name}'s skill progress."
        menu_choices.append((display_text, 'progress'))
        menu_choices.append(("Go back.", 'back'))
        choice = renpy.display_menu(menu_choices)
        if choice == 'assign':
            if training_tutorial:
                monster.set_training()
            else:
                renpy.notify("Progress through the tutorial to unlock skill training.")
        elif choice == 'unassign':
            monster.set_not_training()
        elif choice == 'progress':
            renpy.say(None, f"{monster.name}  —  Skill xp: {round(monster.level_stats['skill_xp'] - (5 * monster.level_stats['skill_level']),2)}/5,  Skill Level: {int(monster.level_stats['skill_level'])}/{monster.level_stats['max_skill_level']}")
        elif choice == 'back':
            monster_menu(monster,location_label)
        else:
            renpy.notify(f"Error: menu choice '{choice}' does not exist")
        training_menu(monster, location_label)

label buy_menu(available_items, shop_label, buy_label):    # call this menu
    $ menu = buy_item_menu(available_items, shop_label)
    
    if menu == 'back':
        $ renpy.jump(shop_label)
    else:
        $ renpy.jump(buy_label)

label work_menu:
    menu:
        "Select working hours.":
            python:
                working_time_hours = renpy.input(f"How many hours will you work at the {income['active_jobs'][-1].location_name}?", default = 0, length=2)
                try: 
                    int(working_time_hours)
                except:                    
                    renpy.notify("You must enter numbers.")
                    renpy.jump('work_menu')
                shift_length_hours = int(working_time_hours)
                if income['active_jobs'][-1].check_shift_hours(shift_length_hours):    # check if working past closing time
                    if player_area == 'hardware_store':
                        renpy.jump('hardware_work_event') 
                    else:
                        earn_active_income(shift_length_hours)
                        jump_player_location()
                else: 
                    if check_weekday():
                        closing_hour = income['active_jobs'][-1].weekday_hours[1] - 12
                        renpy.notify(f"Those work hours would exceed the {income['active_jobs'][-1].location_name}'s operating hours. This employer closes at {closing_hour} PM on weekdays.")
                    else:
                        closing_hour = income['active_jobs'][-1].weekend_hours[1] - 12
                        renpy.notify(f"Those work hours would exceed the {income['active_jobs'][-1].location_name}'s operating hours. This employer closes at {closing_hour} PM on weekends.")
                    renpy.jump('work_menu')
        'Leave':
            if len(income['active_jobs']) == len(income['active_wages']):    # verify player worked this job
                pass
            else:    # player did not work here
                $ income['active_jobs'].pop()
            $ jump_player_location()

label fast_travel_menu:
    python:
        menu_choices = []
        menu_choices.append(("Close Menu", 'back'))
        menu_choices.append(("Your House", 'house'))
        menu_choices.append(("Town", 'town'))
        for location in game_locations.values():
            if location.exists and location.unlocked and not location.in_player_house and not location.key == 'outside' and not location.key == 'pond' and not location.key == 'town' and not location.key == 'construction_office' and not location.key == 'hardware_store' and not location.key == 'pet_shop' and not location.key == 'bike_shop' and not location.key == 'eroge_shop' and not location.key == 'maid_cafe' and not location.key == 'forest':
                menu_choices.append((location.name, location))
        choice = renpy.display_menu(menu_choices)
        if choice == 'back':
            jump_player_location()
        elif choice == 'house':
            menu_choices = []
            menu_choices.append(("Back", 'back'))
            for location in game_locations.values():
                if location.exists and location.unlocked and location.in_player_house:
                    menu_choices.append((location.name, location))
            choice = renpy.display_menu(menu_choices)
            if choice == 'back':
                renpy.jump('fast_travel_menu')
            elif choice.key == 'miia_room':
                if miia.needs_caretaking and miia.location == 'miia_room':
                    caretaking(miia)
                else:
                    travel('miia_room')
            elif choice.key == 'papi_room':
                if papi.needs_caretaking and miia.location == 'papi_room':
                    caretaking(papi)
                else:
                    travel('papi_room')
            elif choice.key == 'guest_room':
                if papi.needs_caretaking and papi.location == 'guest_room':
                    caretaking(papi)
                elif miia.needs_caretaking and miia.location == 'guest_room':
                    caretaking(miia)
                else:
                    travel('guest_room')
            else:
                location_key = choice.key
                travel(location_key)
        elif choice == 'town':
            menu_choices = []
            menu_choices.append(("Back", 'back'))
            menu_choices.append(("Town Square", town))
            menu_choices.append(("Hardware Store", hardware_store))
            menu_choices.append(("Pet Shop", pet_shop))
            menu_choices.append(("Eroge Shop", eroge_shop))
            menu_choices.append(("Maid Café", maid_cafe))
            menu_choices.append(("Bike Shop", bike_shop))
            choice = renpy.display_menu(menu_choices)            
            if choice == 'back':
                renpy.jump('fast_travel_menu')
            elif choice == town:
                travel('town')
            if not choice.is_open:
                if jobs[choice.key].check_shop_hours() or choice.key == 'hardware_store' or choice.key == 'bike_shop':
                    location_key = choice.key
                    travel(location_key)
                else:
                    job_closed(jobs[choice.key])
                    jump_player_location()
            else:
                location_key = choice.key
                travel(location_key)
        elif choice.key == 'park':
            travel(choice.key)
        else:
            if not choice.is_open:
                if jobs[choice.key].check_shop_hours() or choice.key == 'hardware_store' or choice.key == 'bike_shop':
                    location_key = choice.key
                    travel(location_key)
                else:
                    job_closed(jobs[choice.key])
                    jump_player_location()
            else:
                location_key = choice.key
                travel(location_key)
        renpy.jump('fast_travel_menu')

label wait_menu:
    menu:
        "Select waiting time.":
            python:
                waiting_time_hours = renpy.input("How many hours to wait?", default = 0, length=2)
                try: 
                    int(waiting_time_hours)
                except:                    
                    renpy.notify("You must enter numbers.")
                    renpy.jump('wait_menu')
                waiting_time_hours = int(waiting_time_hours) 
                waiting_time_minutes = renpy.input("How many minutes to wait?", default = 0, length=3)
                try: 
                    int(waiting_time_minutes)
                except:                    
                    renpy.notify(f"You must enter numbers.")
                    renpy.jump('wait_menu')
                waiting_time_minutes = int(waiting_time_minutes) 
                total_waiting_time = (waiting_time_hours * 60) + waiting_time_minutes    # sum in minutes
                wait(total_waiting_time)
                jump_player_location()
        'Leave':
            $ jump_player_location()

label budget_menu:
    menu:
        "Bottom line.":
            call budget from _call_budget_2
            jump budget_menu
        
        "Detailed information.":
            jump budget_menu_detail
        
        "Done with budget.":
            jump desk

label budget_menu_detail:
    menu:
        "Check inflows.":
            jump inflows

        "Check outflows.":
            jump outflows

        #"Check history.":
            #jump history
        
        "Back.":
            jump budget_menu

        "Exit budget.":
            jump desk

label inflows:
    menu:
        "See all income.":
            call display_income from _call_display_income                        
            jump inflows
        
        "See active income.":
            call display_active_income from _call_display_active_income
            jump inflows

        "See passive income.":
            call display_passive_income from _call_display_passive_income
            jump inflows

        "See only monster income":
            call display_monster_income from _call_display_monster_income
            jump inflows

        "Back.":
            jump budget_menu_detail

        "Exit budget.":
            jump desk

label display_active_income:
    "Active Income: Trade your valuable time for credits."
    python:
        for job in income['active_jobs']:
            job_name = job.location_name, job_wages = job.active_wages
            renpy.say(None, "You worked at the [job_name] and earned [job_wages] credits for your time.")
    return

label display_monster_income:
    "Passive Monster Income: You may assign monster girls to work behind the scenes and earn credits for you passively at the expense of their happiness."
    python:
        monster_total_credits = 0
        for monster in monsters_placed:
            if monster.job_stats['is_working']:
                monster_daily_credits = monster.job_stats['passive_income']
                monster_total_credits += monster_daily_credits
                renpy.say(None, f"You have assigned {monster.name} to work at {monster.job_stats['assigned_job'].location_name}. She is expected to earn {monster.job_stats['passive_income']} credits today")
    "Total Monster Income: [monster_total_credits] credits."
    return

label display_passive_income:
    "Passive Income: Earn credits while sleeping."    # while sleeping()
    "Stipend: The government pays [STIPEND] credits each day per monster." 
    $ current_stipend = STIPEND * num_placed_monsters
    "Current Stipend: [STIPEND] stipend credits * [num_placed_monsters] monster(s) in your care = [current_stipend] government credits per day."
    call display_monster_income from _call_display_monster_income_1
    return

label display_income:
    call display_active_income from _call_display_active_income_1
    call display_passive_income from _call_display_passive_income_1
    "Total Income: [total_income] credits. Active: [total_active_income] credits. Passive: [total_passive_income] credits."
    return

label outflows:
    menu:
        "See all expenses.":
            call display_expenses from _call_display_expenses
            jump outflows

        "See spending.":
            call display_spending from _call_display_spending
            jump outflows

        "See player upkeep costs.":
            call display_player_upkeep from _call_display_player_upkeep
            jump outflows

        "See monster upkeep costs.":
            call display_monster_expenses from _call_display_monster_expenses
            jump outflows
        
        "Back.":
            jump budget_menu_detail

        "Exit budget.":
            jump desk

label display_player_spending:
    python:
        i = 0
        update_player_spending()
        for receipt in player_expense['spending_receipts']:
            renpy.say("", "You spent %i credits on %i/EA %s." % (receipt, player_expense['spending_item_quantities'][i], player_expense['spending_item_names'][i]))
            i += 1
        renpy.say("", "Total Spending: %i credits." % (player_expense['spending']))

label display_player_upkeep:
    "Player Upkeep: It costs credits just to keep yourself going each day."
    "Today, you will spend [player_expense['food_use']] credits on food, [player_expense['water_use']] credits on water, and [player_expense['power_use']] credits on power."
    "Finally, you must pay some property tax each day. Given the current size of your house, you must pay [player_expense['property_tax']] credits each day or else the government will sieze your home."
    "Player Expenses: [player_expense['total']] credits."
    return

label display_player_expenses:

label display_monster_expenses:
    "Monster Upkeep: Monster girls aren't free. Each one requires attention and, more importantly, maintenance."
    python:
        total_maintenance = 0
        for monster in monsters_placed:
            if monster.is_placed:
                monster_name, monster_food, monster_power, monster_water = monster.name, monster.upkeep_stats['food_use'], monster.upkeep_stats['power_use'], monster.upkeep_stats['water_use']
                monster_total_credits = monster_food + monster_power + monster_water
                renpy.say(None, "[monster_name] is in your care. Each day, you spend [monster_food] credits to feed her, [monster_power] credits for her power usage, and [monster_water] credits for her water usage. ")
                renpy.say(None, "[monster_name] costs [monster_total_credits] credits to maintain each day.")
            total_maintenance += monster_total_credits
    "Total Monster Maintenance: [total_maintenance] credits."
    return

label display_spending:
    "Spending data goes here."
    $ total_spending = 0
    return

label display_expenses:
    call display_player_expenses from _call_display_player_expenses
    call display_monster_expenses from _call_display_monster_expenses_1
    $ total_outflow = player_expense + total_maintenance + total_spending
    "Total Outflow: [total_outflow] credits. Upkeep: [player_expense] credits. Monster Maintenance: [total_maintenance] credits. Spending: [total_spending] credits."
    return

init python:
    ## Renpy Notificatons ##
    def one_shift():
        renpy.notify("You can only work one shift at each job per day.")