define showing_notifies = 0

init python:
    import time
    import random

    def custom_notify(message):

        global showing_notifies

        # Generate 6 random letters
        rand_letters = random.choices(
            "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", k=6)

        # Make a unique tag using current time and the letters
        unique_tag = f"notify_{time.time()}_{''.join(rand_letters)}"

        showing_notifies += 1  # Increment our count
        renpy.show_screen(
            "notify",
            message=message,
            showing_notifies=showing_notifies,
            _tag=unique_tag)

        renpy.restart_interaction()  # Refresh/update screens

    config.notify = custom_notify