## World Navigation

# Player House

label bedroom:
    scene bedroom
    call quest_checker from _call_quest_checker
    call house_music from _call_house_music
    $ update_player_area('bedroom')

    call spawn_sprites from _call_spawn_sprites

    menu(monster_interaction=True):      
        "Sleep.":
            jump sleep

        "Lie in bed.":
            jump bed
        
        "Sit at desk.":
            jump desk
        
        "Leave.":
            jump leave_bedroom    

label leave_bedroom:
    menu:
        "Enter attic.":
            $ travel('attic')  

        "Go to Miia's room." if 'miia_room' in player_rooms:
            python:
                if miia.needs_caretaking and miia.location == 'miia_room':
                    caretaking(miia)
                else:
                    travel('miia_room')
        
        "Go to guest bedroom.":
            python:
                if miia.needs_caretaking and miia.location == 'guest_room':
                    caretaking(miia)
                else:
                    travel('guest_room')
            
        "Go downstairs.":
            $ travel('entryway')    

label attic:
    if not same_area('attic'):
        scene attic
        $ update_player_area('attic')
    call house_music from _call_house_music_1
    call spawn_sprites from _call_spawn_sprites_1
    menu(monster_interaction=True):
        "Search.":
            jump search_attic

        "Go downstairs.":
            $ travel('bedroom')  

label entryway:
    if not same_area('entryway'):
        scene entryway
        call house_music from _call_house_music_2
        $ update_player_area('entryway')
    call house_music from _call_house_music_3
    call spawn_sprites from _call_spawn_sprites_2
    menu(monster_interaction=True):      
        "Answer the door." if tio.location == 'entryway':
            jump tio_dialogue 
        
        "Go upstairs.":
            $ travel('bedroom')

        "Go to living room.":
            $ travel('living_room')

        "Go outside.":
            $ travel('outside')

label living_room:
    if not same_area('living_room'):
        scene living_room
        $ update_player_area('living_room')
    call house_music from _call_house_music_4    
    call spawn_sprites from _call_spawn_sprites_3
    
    menu(monster_interaction=True):  
        "Sit on the couch":
            jump couch

        "Go to the kitchen.":
            $ travel('kitchen')

        "Open the closet.":
            jump closet

        "Leave the living room.":
            $ travel('entryway')

label kitchen:
    scene kitchen
    if not same_area('kitchen'):
        
        $ update_player_area('kitchen')
    call house_music from _call_house_music_5
    call spawn_sprites from _call_spawn_sprites_4
    
    menu(monster_interaction=True):      
        "Try Miia's cooking." if miia.location == 'kitchen':
            jump miia_cooking

        "Prepare a meal." if miia.location != 'kitchen':
            jump cook

        "Go to the bathroom.":
            $ travel('bathroom')

        "Go to the living room.":
            $ travel('living_room')

label bathroom:
    if not same_area('bathroom'):
        scene bathroom
        $ update_player_area('bathroom')
    call house_music from _call_house_music_6
    call spawn_sprites from _call_spawn_sprites_5
    menu(monster_interaction=True):
        "Prepare a bath for Miia." if not miia_bath:
            $ miia_bath = True
            call miia_bath from _call_miia_bath

        "Bathe." if miia_bath:
            jump use_bath

        "Leave the bathroom.":
            $ travel('kitchen')

label guest_room:
    if not same_area('guest_room'):
        scene guest_room
        $ update_player_area('guest_room')
    call house_music from _call_house_music_7
    call spawn_sprites from _call_spawn_sprites_6

    menu(monster_interaction=True):
        "Go to Miia's room." if 'miia_room' in player_rooms:
            python:
                if miia.needs_caretaking and miia.location == 'miia_room':
                    caretaking(miia)
                else:
                    travel('miia_room')
    
        "Go back to bedroom.":
            $ travel('bedroom')

# Locked Rooms

label miia_room:
    if not same_area('miia_room'):
        scene miia_room
        $ update_player_area('miia_room')
    call house_music from _call_house_music_8
    call spawn_sprites from _call_spawn_sprites_7

    menu(monster_interaction=True):
        "Go to guest room.":
            $ travel('guest_room')

        "Go to Papi's room." if 'papi_room' in player_rooms:
            $ travel('papi_room')

label papi_room:
    if not same_area('papi_room'):
        scene papi_room
        $ update_player_area('papi_room')
    call house_music from _call_house_music_9
    call spawn_sprites from _call_spawn_sprites_8

    menu(monster_interaction=True):
        "Go to Centorea's room." if 'centorea_room' in player_rooms:
            $ travel('centorea_room')

        "Back to Miia's room.":
            python:
                if miia.needs_caretaking and miia.location == 'miia_room':
                    caretaking(miia)
                else:
                    travel('miia_room')

label centorea_room:
    if not same_area('centorea_room'):
        scene centorea_room
        $ update_player_area('centorea_room')
    call house_music from _call_house_music_10
    call spawn_sprites from _call_spawn_sprites_9

    menu(monster_interaction=True):
        "Go to Mero's room." if 'mero_room' in player_rooms:
            $ travel('mero_room')

        "Back to Papi's room.":
            $ travel('papi_room')

label mero_room:
    if not same_area('mero_room'):
        scene mero_room
        $ update_player_area('mero_room')
    call house_music from _call_house_music_11
    call spawn_sprites from _call_spawn_sprites_10

    menu(monster_interaction=True):
        "Go to Lala's room." if 'lala_room' in player_rooms:
            $ travel('lala_room')

        "Back to Centorea's room.":
            $ travel('centorea_room')

label lala_room:
    if not same_area('lala_room'):
        scene lala_room
        $ update_player_area('lala_room')
    call house_music from _call_house_music_12
    call spawn_sprites from _call_spawn_sprites_11

    menu(monster_interaction=True):
        "Back to Mero's room.":
            $ travel('mero_room')

# World
label outside:
    if not same_area('outside'):
        scene outside
        with fade
        $ update_player_area('outside')
    if renpy.music.get_playing() != audio.walking_outside:
        play music walking_outside loop  

    call spawn_sprites from _call_spawn_sprites_12

    if not find_outside:
        $ start_scene()
        "{i}Bing!{/i}"
        $ find_outside = True
        "I looked down at my phone, noticing new text messages from Smith."

        s "By the way, Darling. When you're out there exploring the world, you'll break curfew if you stay out too late. So plan to be home on time."
    
        s "But don't worry if you forget. There are buttons at the bottom of the screen you can press whenever you need to get home quickly or simply pass time."
        $ end_scene()
        $ jump_player_location()
    
    menu(monster_interaction=True):       
        "Talk to Calli." if calli.location == player_area:
            call calli_dialogue from _call_calli_dialogue
        
        "Go into town.":
            $ travel('town')

        "Go to the park.":
            $ travel('park')

        "Go to the construction office.":
            $ travel('construction_office_building')

        "Go back inside.":
            $ travel('entryway')  

label park:
    if not same_area('park'):
        scene park
        with fade
        $ update_player_area('park')  
    if renpy.music.get_playing() != audio.park:
        play music park loop  

    call spawn_sprites from _call_spawn_sprites_13

    menu(monster_interaction=True):     
        "Talk to Jig." if jig.location == 'park':
            call jig_dialogue from _call_jig_dialogue
        
        "Walk in the park.":
            jump park_walk

        "Enter the forest.":
            $ travel('forest')
        
        "Go into town.":
            $ travel('town')

        "Go to the construction office.":
            $ travel('construction_office_building')

        "Go home.":
            $ travel('entryway')   

label forest:
    if not same_area('forest'):
        scene forest with fade
        $ update_player_area('forest')  
    if renpy.music.get_playing() != audio.forest:
        play music forest loop  

    call spawn_sprites from _call_spawn_sprites_14

    menu(monster_interaction=True):
        "Walk to the pond.":
            $ travel('pond')

        "Leave the forest":
            $ travel('park')

label pond:
    if not same_area('pond'):
        scene black 
        show pond with fade
        $ update_player_area('pond')  
    if renpy.music.get_playing() != audio.pond:
        play music pond loop  

    call spawn_sprites from _call_spawn_sprites_15

    menu(monster_interaction=True):
        "Wash your face in the water." if aurora.dialogue_counter < 1:
            call aurora_dialogue from _call_aurora_dialogue

        "Leave the forest":
            $ travel('park')

label construction_office_building:
    if not same_area('construction_office_building'):
        scene black
        show construction_office with fade
        $ update_player_area('construction_office_building')  
    if renpy.music.get_playing() != audio.construction_office:
        play music construction_office loop  

    menu(monster_interaction=True):      
        "Go inside.":
            if office_job.check_shop_hours():
                $ travel('construction_office')
            else:
                $ job_closed(office_job)
                $ jump_player_location()

        "Go into town.":
            $ travel('town')

        "Go to the park.":
            $ travel('park')

        "Go home.":
            $ travel('entryway')   

label construction_office:
    if not same_area('construction_office'):
        scene receptionist
        with fade
        $ update_player_area('construction_office')
    if renpy.music.get_playing() != audio.receptionist:
        play music receptionist loop  

    menu(monster_interaction=True):
        "Talk":
            call office_worker_dialogue from _call_office_worker_dialogue
        
        "Order a construction project.":
            jump upgrade_house

        "Work.":
            $ work_active_job('construction_office')

        "Leave.":
            $ travel('construction_office_building')

label town:
    if not same_area('town'):
        scene town with fade
        $ update_player_area('town')
    if renpy.music.get_playing() != audio.town_ambience:
        play music town_ambience loop

    call spawn_sprites from _call_spawn_sprites_16

    if tio.location == player_area:
        menu:
            "Talk to Tionishia.":
                call tio_dialogue from _call_tio_dialogue
            "Walk somewhere.":
                jump town_nav
    else:
        jump town_nav

label town_nav:
    menu(monster_interaction=True):      
        "Go to the hardware store." if 'hardware_store' not in player_area: 
            $ travel('hardware_store')

        "Go to the pet shop." if 'pet_shop' not in player_area:
            if pet_shop_job.check_shop_hours():
                $ travel('pet_shop')
            else:
                $ job_closed(pet_shop_job)
                $ jump_player_location() 

        "Go to the bike shop." if 'bike_shop' not in player_area:
            $ travel('bike_shop')

        "Go to the eroge shop." if 'eroge_shop' not in player_area:
            if eroge_shop_job.check_shop_hours():
                $ travel('eroge_shop')
            else:
                $ job_closed(eroge_shop_job)
                $ jump_player_location()

        "Go to the maid café." if 'maid_cafe' not in player_area:
            if maid_cafe_job.check_shop_hours():
                $ travel('maid_cafe')
            else:
                $ job_closed(maid_cafe_job)
                $ jump_player_location()

        "Leave town.":
            menu:                
                "Go home.":
                    $ travel('entryway')
                
                "Go to the park.":
                    $ travel('park')

                "Go to the construction office.":
                    $ travel('construction_office_building')

                "Back.":
                    jump town_nav

        "Back.":
            $ jump_player_location()

label hardware_store:
    if not same_area('hardware_store'):
        scene hardware_store with fade
        $ update_player_area('hardware_store')
    if renpy.music.get_playing() != audio.town_ambience:
        play music town_ambience loop

    call spawn_sprites from _call_spawn_sprites_17

    if hardware_store_job.check_shop_hours() and hayden.location == 'hardware_store':
        menu(monster_interaction=True):  
            "Talk to Hayden.":
                call hayden_dialogue from _call_hayden_dialogue
            
            "Purchase hardware.":
                jump buy_hardware   
        
            "Work." if hardware_store_job.active_unlocked:
                $ work_active_job('hardware_store')

            "Work." if not hardware_store_job.active_unlocked:
                $ start_scene()
                h "Get lost, punk."
                $ end_scene()
                $ jump_player_location()

            "Leave.":
                jump town_nav
    else:
        $ job_closed(hardware_store_job)
        menu(monster_interaction=True):  
            "It's closed.":
                jump town_nav  

label pet_shop:
    if not same_area('pet_shop'):
        scene pet_shop
        with fade
        $ update_player_area('pet_shop')
    if renpy.music.get_playing() != audio.pet_shop:
        play music pet_shop loop

    call spawn_sprites from _call_spawn_sprites_18

    menu(monster_interaction=True):    
        "Talk to Alice.":
                call alice_dialogue from _call_alice_dialogue
        
        "Purchase pet supplies.":
            if pet_shop_trading:
                jump buy_pet_supplies
            else:
                $ renpy.notify("Talk to Alice to unlock her vendor inventory.")
                $ jump_player_location()

        "Work.":
            $ work_active_job('pet_shop')
        
        "Leave.":
            jump town_nav   

label bike_shop:
    if not same_area('bike_shop'):
        scene bike_shop
        with fade
        $ update_player_area('bike_shop')
       
    if bike_shop_job.check_shop_hours():
        menu(monster_interaction=True):  
            "Purchase a bike.":
                jump buy_bike

            "Leave.":
                jump town_nav
    else:
        menu(monster_interaction=True):  
            "It's closed.":
                jump town_nav   

label eroge_shop:
    if not same_area('eroge_shop'):
        scene eroge_shop with fade
        $ update_player_area('eroge_shop')    
    if renpy.music.get_playing() != audio.eroge_shop:
        play music eroge_shop loop  

    menu(monster_interaction=True):       
        "Purchase erotica.":
            jump buy_eroge

        "Work.":
            $ work_active_job('eroge_shop')

        "Leave.":
            jump town_nav   

label maid_cafe:
    if not same_area('maid_cafe'):
        scene maid_cafe with fade
        voice ohayo
        $ update_player_area('maid_cafe')
    if renpy.music.get_playing() != audio.maid_cafe:
        play music maid_cafe loop  

        "Welcome, master!!"

    menu(monster_interaction=True):         
        "Place an order." if aethel.dialogue_counter == 0:
            call aethel_dialogue from _call_aethel_dialogue

        "Work.":
            $ work_active_job('maid_cafe')

        "Leave.":
            jump town_nav

# Locked Areas

label aquarium:
    if not same_area('aquarium'):
        scene aquarium
        with fade
        $ update_player_area('aquarium')

    "This is the aquarium."

    menu(monster_interaction=True):      
        "Leave." :
            jump fast_travel_menu

label love_hotel:
    if not same_area('love_hotel'):
        scene love_hotel
        with fade
        $ update_player_area('love_hotel')

    "This is the love hotel."

    menu(monster_interaction=True):      
        "Leave." :
            jump fast_travel_menu

label resturaunt:
    if not same_area('resturaunt'):
        scene resturaunt
        with fade
        $ update_player_area('resturaunt')
    
    "This is the resturaunt."

    menu(monster_interaction=True):      
        "Leave." :
            jump fast_travel_menu
            
label smith_house:
    if not same_area('smith_house'):
        scene smith_house
        with fade
        $ update_player_area('smith_house')

    "This is Smith's house."

    menu(monster_interaction=True):      
        "Leave." :
            jump fast_travel_menu