label stop_audio:    # stop audio in all channels
    stop music
    stop sound
    stop audio
    return  

label house_music():    # proper music plays inside house without interruption
    if renpy.music.get_playing() != audio.house_music:
        play music house_music
    return

init python:
    
    ## UX ##
    def toggle_item_description(item_key):    # show or hide a key item description in the inventory menu
        player_key_items[item_key] = not player_key_items[item_key]
    
    ## Game State ##
    def start_scene():
        global explore
        explore = False

    def start_quiet_scene():
        global explore
        explore = False
        renpy.call('stop_audio')

    def end_scene():    
        global explore
        explore = True

    def guest_room_empty():
        for monster in monsters_placed:
            if monster.location is 'guest_room':
                return False
        return True

    ## Time ##
    def update_clock():
        global meridian, hours_clock, minutes_clock_int, minutes_clock_str
        hours_clock = hours
        if hours_clock > 12:
            hours_clock -= 12
        minutes_clock_int = minutes
        minutes_clock_int = minutes % 60  
        if minutes_clock_int > 9:
            minutes_clock_str = str(minutes_clock_int)
        else:
            minutes_clock_str = "0" + str(minutes_clock_int)
        if hours > 11: 
            meridian = "PM" 
        else: 
            meridian = "AM"
        
    def update_week_day():    # updates the day of the week
        global day
        day_id = (day_count) % 7 
        day = Week[day_id]
    
    def check_weekend():
        day_id = (day_count) % 7 
        if day_id == 0 or day_id == 6:            
            return True
        else:
            return False

    def check_weekday():        
        day_id = (day_count) % 7 
        if day_id == 0 or day_id == 6:            
            return False
        else:
            return True
    
    def time_check(time_cost):
        time_check = time_cost + minutes    # theoretical time after action
        if time_check > CURFEW:    
            renpy.notify("Not enough time. Exceeds curfew.")
            return False
        else:    
            return True
    
    def time_action(time_minutes):    
        if time_check(time_minutes):    
            advance_time(time_minutes)
            return True           
        else:    
            end_scene()
            jump_player_location()

    def advance_time(time_minutes):    # advance time within the same day
        global minutes, hours
        hour_check = time_minutes + (minutes % 60 )                 
        if hour_check >= 60:
            hours += hour_check // 60
        minutes += time_minutes
        update_npc_locations()
        update_npc_emotional_state()

    def wait(time_minutes):
        waiting_time_hours = time_minutes // 60
        waiting_time_minutes = time_minutes % 60
        if time_action(time_minutes):
            renpy.notify(f"You waited, passing {waiting_time_hours} hour(s) and {waiting_time_minutes} minute(s) of time.")
            jump_player_location()
    
    def sleep():
        global loading_bool
        if not loading_bool:
            renpy.call('loading_screen', from_current = True)
        clear_spawn_blocker()
        check_monster_assignments()
        earn_passive_credits()
        earn_skill_xp()
        next_day()
        check_work_blocker()
        check_monster_assignments()
        clear_financial_stacks()
        clear_job_stats()
        clear_random_timers()
        loading_bool = False
        renpy.jump('bedroom')        

    def clear_random_timers():
        for timer in random_location_timers:
            timer = 0
    
    def next_day():    # wake up at 8 AM
        global day_count, hours, minutes 
        hours, minutes = 8, 8 * 60
        day_count += 1  

    def job_closed(job):
        hours_left = job.hours() - hours
        if hours_left < 0:
            hours_left += 24
        renpy.notify(f"The {job.location_name} opens in {hours_left} hours. ")

    def random_pause():
        return renpy.random.randint(1,5)
    
    ## Space ##
    def update_player_area(current_area_string_name):    # track player location
        global player_area
        player_area = current_area_string_name
    
    def same_area(area_name):
        if area_name == player_area:
            return True
        else:
            return False

    def jump_player_location():    # use to exit menus
        renpy.restart_interaction()
        renpy.jump(player_area)
   
    def travel(location_key):
        target_location = game_locations[location_key]
        player_location = game_locations[player_area]
        travel_distance = [abs(player_location.x_coordinate - target_location.x_coordinate), abs(player_location.y_coordinate - target_location.y_coordinate), abs(player_location.z_coordinate - target_location.z_coordinate)]    # calculate distance between locatons
        walking_distance = sum(travel_distance) 
        ##convert a riding_distance if bike
        if location_key == 'bedroom':    # bedroom is always a valid travel target, especially using the quick menu button
            advance_time(walking_distance)
            renpy.jump('bedroom')
            return
        elif not time_action(walking_distance):    # target is not the bedroom & failed time check, so go to bed then
            renpy.notify("It is getting late. Go to sleep.")
            travel('bedroom')
        else:    # passed time check. time passes because time_action() was True
            renpy.jump(location_key)


    def update_npc_locations():
        global miia_random_location_timer, papi_random_location_timer

        if minutes < 9 * 60 or minutes >= 17 * 60:
            if miia_room.exists:
                miia.location = 'miia_room'
                miia.outfit = 'daytime'
            else:
                miia.location = 'guest_room'
                miia.outfit = 'daytime'
        elif minutes < 10 * 60:
            miia.location = 'kitchen'
            miia.outfit = 'apron'
        elif minutes - miia_random_location_timer >= 60:
            miia_random_location_timer = minutes
            miia.location = random.choice(tuple(player_rooms))

        if minutes < 9 * 60 or minutes >= 17 * 60:
            if papi_room.exists:
                papi.location = 'papi_room'
            else:
                papi.location = 'guest_room'
        elif minutes - papi_random_location_timer >= 60:
            papi_random_location_timer = minutes
            proc = random.randint(1,2)
            if proc == 1:
                papi.location = 'living_room'
            else:
                papi.location = random.choice(tuple(player_rooms))

        # Update Smith location

        if not aethel.block_spawn:
            if maid_cafe_job.check_shop_hours():
                aethel.set_location('maid_cafe')
            else:
                aethel.set_location('aethel_house')
        else:
            aethel.set_location('aethel_house')

        if not hayden.block_spawn:        
            if maid_cafe_job.check_shop_hours() and hayden.location == 'maid_cafe':
                pass
            elif hardware_store_job.check_shop_hours():
                hayden.set_location('hardware_store')
            else:
                hayden.set_location('hayden_house')
        else:
            hayden.set_location('hayden_house')

        if not alice.block_spawn:        
            if pet_shop_job.check_shop_hours():
                alice.set_location('pet_shop')
            else:
                alice.set_location('alice_house')
        else:
            alice.set_location('alice_house')

        if not calli.block_spawn:
            if hours>= 7 or hours <= 16:
                calli.set_location('outside')
            else:
                calli.set_location('calli_house')
        else:
            calli.set_location('calli_house')    

        if not jig.block_spawn:
            if jig.dialogue_counter > 1 and jig.location != 'forest':
                jig.set_location('forest')
            elif jig_day_flag != day_count:
                jig.set_location('park')
        else:
            jig.set_location('park')

        if not tio.block_spawn:
            if maid_cafe_job.check_shop_hours() and hayden.location == 'maid_cafe':
                pass
            elif hours > 9 and hours < 16 and tio.dialogue_counter < 3:
                tio.set_location('town')
            elif tio.dialogue_counter == 3:
                tio.set_location('entryway')
            else:
                tio.set_location('smith_house')
        else:
            tio.set_location('smith_house')

    def clear_spawn_blocker():
        for npc in game_npcs:
            npc.block_spawn = False
    
    def update_npc_emotional_state():
        if day_count > alice_dialogue_day_count_1 and not alice_dialogue_3:
            alice.emotional_state = 'concerned'

    
    ## Core Mechanics ##
    def work_active_job(job_key):
        job = jobs[job_key]
        if not job.is_active_work:
            renpy.notify(f"The {job.location_name} doesn't accept random street workers.")
            jump_player_location()
        if not job.active_unlocked:
            renpy.notify(f"The {job.location_name} work is locked.")
            jump_player_location()
        if job not in income['active_jobs']:
            income['active_jobs'].append(job)
            renpy.jump('work_menu')    
        else:
            one_shift()    # player has already worked the job today
            jump_player_location()
    
    def earn_active_income(time_hours):
        global money, active_work_tutorial_complete
        if not active_work_tutorial_complete:
            active_work_tutorial_complete = True
            renpy.notify("Tutorial Complete: Active Work")
        job = income['active_jobs'][-1]    # top of the stack
        job.earn_active_wages(time_hours)
        money += income['active_wages'][-1]    # pay out money
        renpy.notify(f"You worked {time_hours} hour(s) at {job.location_name} and earned {income['active_wages'][-1]} credits.")
    
    def check_monster_assignments():
        global happiness_tutorial_unlocked
        for monster in monsters_placed:
            if monster.job_stats['is_working'] or monster.level_stats['is_training']:
                if monster.emotions['happiness'] < monster.work_threshold():
                    renpy.notify(f"{monster.name}'s motivation is too low to continue her assignment.")
                    monster.set_not_working()
                    monster.set_not_training()
                    monster.block_assignment()
                    if not happiness_tutorial_unlocked:
                        happiness_tutorial_unlocked = True
    
    def assign_monster(monster_key, job_key):    # assign a monster to a job and assign a job to a monster
        job, monster = jobs['job_key'], monsters['monster_key']
        if not job.is_passive_work:
            renpy.notify(f"The {job.location_name} doesn't accept monster assignments.")
            return
        if not job.passive_unlocked:
            renpy.notify(f"The {job.location_name} work is locked for monsters.")
            return
        if monster.assign_job(job_key):
            renpy.notify(f"{monster.name}'s work assignment: {job.location_name}.")
    
    def unassign_monster(monster_key):    # accessed from monster_menu
        monster, job = monsters['monster_key'], jobs[monster.job_stats['assigned_job']]
        job.unassign_worker(monster_key)
        monster.set_not_working()
        renpy.notify(f"{monster.name}'s work assignment has been cleared.")   
    
    ##needs an emotion check
    '''
    def train_monster(monster_key):
        monster = monsters['monster_key']
        if not training_check(monster_key):    # specific notificaitons in training_check()
            return            
        if not self.job_stats['can_work']:
            renpy.notify(f"{monster.name} cannot train. She requires caretaking.")
            return
        if reqs met:
            monster.set_not_working()
            monster.set_training()
            renpy.notify(f"{monster.name} has agreed to practice her skills.")
            '''

    ##WIP specific items, emotions or game states required after level 1?
    def training_check(monster_key):
        monster = monsters['monster_key']
        if not monster.in_room:
            renpy.notify("Monsters are not comfortable training in the guest room.")
            return False
        if monster.level_stats['skill_level'] >= 1:
            renpy.notify("Note: Skills levels beyond level 1 not yet implemented.")
            return False
        return True

    def earn_skill_xp():
        for monster in monsters_placed:
            if monster.level_stats['skill_level'] < 0:
                renpy.notify(f"Error: {monster.name}'s skill level is negative.")
                return
            if monster.level_stats['is_training']:
                monster.degrade_happiness()
                if monster.level_stats['skill_level'] == 0:
                    monster.skill_xp(3)
                elif monster.level_stats['skill_level'] < 3:
                    monster.skill_xp(2)
                else:
                    monster.skill_xp(1)

    def check_work_blocker():
        for monster in monsters_placed:
            if len(monster.caretaking_days) == 0:
                renpy.notify(f"check_work_blocker function error: {monster.key}.caretaking_days has a list length of zero.")
            elif not monster.needs_caretaking and day_count == monster.caretaking_days[-1]:
                monster.set_needs_caretaking()
            if not monster.needs_caretaking and day_count % 30 == 0:
                monster.set_in_heat()

    def caretaking(monster):
        global find_miia_molt, miia_molt_rejection
        if not monster.needs_caretaking:
            renpy.notify(f"{monster.name} does not currently require caretaking.")
            return
        if monster.key == 'miia':
            if 'scale_oil' not in player_key_items:
                renpy.notify(f"You don't have the scale oil required to properly care for {monster.name}. Scale oil may be purchased at the pet shop.")
                if not miia_molt_rejection:
                    miia_molt_rejection = True
                    renpy.jump('miia_molt_event')
            else:
                if not miia_molt_rejection:
                    miia_molt_rejection = True
                    renpy.jump('miia_molt_event')
                if time_action(90):
                    monster.needs_caretaking = False
                    monster.caretaking_days.append(day_count + 20)
                    monster.unblock_assignment()
                    monster.happiness_up(25)
                    monster.intimacy_xp(4)
                    if not find_miia_molt:
                        find_miia_molt = True
                        renpy.jump('miia_molt_pass')
                    else:
                        ## only background image. renpy.show()?
                        renpy.notify("You oiled Miia's scales, deepening your bond and concluding her molt.")
        elif monster.key == 'papi':
            if time_action(120):    # no item requirement for pruning harpy feathers
                monster.needs_caretaking = False
                monster.caretaking_days.append(day_count + 15)
                monster.unblock_assignment()
                monster.happiness_up(25)
                monster.intimacy_xp(4)
                if not find_papi_molt:
                    find_papi_molt = True
                    renpy.say(None, "Molting scene goes here.")
                    ## renpy.jump(). full cut scene
                    monster.intimacy_xp(5)
                    renpy.notify("You bathed Papi and pruned her feathers, deepening your bond.")
                else:
                    ## only background image. renpy.show()?
                    renpy.notify(f"You bathed {monster.name}'s scales, cleaning her molting feathers.")
        elif monster.key == 'centorea':
            pass
        elif monster.key == 'suu':
            pass
        elif monster.key == 'mero':
            pass
        elif monster.key == 'rachnera':
            pass
        elif monster.key == 'lala':
            pass
        else:
            renpy.notify(f"Error: The monster key [{monster_key}] does not match existing monsters.")
        jump_player_location()

    def increment_monster_emotions():
        for monster in monsters_placed:
            monster.increment_emotions()

    def new_placement(monster_key):
        new_monster = monsters['monster_key']
        for monster in monsters_placed:    # verify guest room is unocupied 
            if not monster.in_room:
                renpy.notify(f"{monster.name} is living in the guest room, making it unavailable for {new_monster.name}")
                return
        new_monster.place_monster()    # guest room by default. monster.in_room == False
        if new_monster not in monsters_placed:
            monsters_placed.append(new_monster)    # add her to list of placed monsters
    
    ## Money ##
    def earn_passive_credits():    # add or subtract credits at the end of each day
        global money
        for monster in monsters_placed:    # monster actually works at this time
            if monster.job_stats['is_working'] and monster.job_stats['assigned_job'] is not None and monster.job_stats['passive_income'] > 0:
                monster.works()
        update_budget()    # update income and expense
        ## do NOT clear credits from yesterday ##
        passive_expense = expense['total'] - expense['spending']    # active income and spending are already accounted for
        money = round(money + income['passive'] - passive_expense, 2)
        if money < 0:    # check for bankruptcy
            renpy.notify("You don't have enough credits remaining to pay your bills.")
            renpy.jump('bankrupt')
        else:
            renpy.notify(f"While sleeping, you earned {income['passive']} passive credits and paid {passive_expense} credits in upkeep costs.")

    def update_budget():
        update_income()
        update_expense()
    
    def update_income():
        global income
        update_active_income()
        update_passive_income()
        income['total'] = income['active'] + income['passive']
    
    def update_active_income():
        global income
        income['active'], i = 0, 0
        for job in income['active_jobs']:
            income['active'] += income['active_wages'][i]
            i += 1

    def update_passive_income():
        global income
        update_stipend()
        update_monster_income()
        income['passive'] = income['stipend'] + income['monster']

    def update_stipend():
        global income
        income['stipend'] = STIPEND * len(monsters_placed)
    
    def update_monster_income():
        global income
        income['monster'] = 0
        for monster in monsters_placed:
            if monster.job_stats['is_working']:
                monster.update_monster_income()
                income['monster'] += monster.job_stats['passive_income']

    def update_expense():
        global expense
        update_player_expense()
        update_monster_expense()
        expense['total'] = expense['player'] + expense['monster']
    
    def update_player_expense():
        global expense
        update_spending()
        update_property_tax()
        expense['player'] = expense['spending'] + expense['food_use'] + expense['power_use'] + expense['water_use'] + expense['property_tax']
     
    def update_spending():
        global expense
        expense['spending'], i = 0, 0
        for receipt in expense['spending_receipts']:
            expense['spending'] += expense['spending_receipts'][i]
            i += 1

    def update_property_tax():
        global expense
        expense['property_tax'] = 50 + 10 * (len(player_rooms) - 7)
    
    def update_monster_expense():
        global expense
        expense['monster'] = 0
        for monster in monsters_placed:
            expense['monster'] += monster.upkeep_stats['food_use']
            expense['monster'] += monster.upkeep_stats['power_use']
            expense['monster'] += monster.upkeep_stats['water_use']

    def clear_financial_stacks():
        income['active_jobs'].clear()
        income['active_wages'].clear()
        income['monster_working'].clear()
        income['monster_jobs'].clear()
        income['monster_wages'].clear()
        expense['spending_items'].clear()
        expense['spending_item_quantities'].clear()
        expense['spending_receipts'].clear()
    
    def clear_job_stats():
        for monster in monsters_placed:
            monster.clear_monster_income()

    ## Items ##
    def buy_item(item, shop_label):
        global money
        if item.key_item:
            if item.key in player_key_items.keys():
                renpy.notify("You already own that.")
                return
            if item.price > money:
                renpy.notify("You can't afford that.")
                return
            else:
                expense['spending_items'].append(item)
                expense['spending_item_quantities'].append(1)
                expense['spending_receipts'].append(item.price)
                money -= item.price
                item.get()
                renpy.notify(f'You purchased the {item.name} for {item.price} credits.')
        else:
            quantity = renpy.input(f"How many {item.name} to buy for {item.price} credits each?", default = 0, length=3)
            try: 
                int(quantity)
            except:                    
                renpy.notify("You must enter numbers.")
                renpy.jump(shop_label)  
            quantity = int(quantity) 
            price = quantity * item.price
            if price > money:
                renpy.notify("You can't afford that.")
                renpy.jump(shop_label)
            else:
                if quantity > 0:
                    expense['spending_items'].append(item)
                    expense['spending_item_quantities'].append(quantity)
                    expense['spending_receipts'].append(price)
                    money -= price
                    item.get(get_quantity = quantity)
                    renpy.notify(f'You purchased {quantity} {item.name} for {price} credits.')
    
    ## Script Functions

    def set_outfit_tag(character):
        attribute_string = character.key + " " + character.outfit
        renpy.set_tag_attributes(attribute_string)

    ##finish writing
    def use_item(self, use_quantity, monster_target):
        if self.effect == "happiness_boost" and monster_target.happiness < monster_target.MAX_HAPPINESS:
            monster_target.happiness_up(20 * use_quantity)
            self.remove(use_quantity)
            renpy.notify(f"Used {self.name} on {monster_target.name}. Happiness: {monster_target.happiness}")
        else:
            renpy.notify(f"Cannot use {self.name} on {monster_target.name}.")

```
        if gym_job.check_shop_hours():
            polt.set_location('gym')
        elif minutes < 17 * 60:
            polt.set_location('park')
        else:
            polt.set_location('polt_house')
```