# begin the game with miia

default miia = Monster(
    key = 'miia',
    name  = 'Miia', 
    outfit = 'daytime',
    is_placed = True,
    location = 'guest_room',
    caretaking_days = [5],
    level_stats = {
        'intimacy_scene': 1,
        'intimacy_level': 0, 
        'intimacy_xp': 20,
        'MAX_INTIMACY': 10, 
        'skill_xp': 0,
        'skill_level': 0, 
        'MAX_SKILL_XP': 5,
        'max_skill_level': 5,
        'is_training': False,
        }, 
    upkeep_stats = {
        'food_use': 10,
        'power_use': 10,
        'water_use': 10,
        },
    personality = {
        'INTROVERSION': 15, 
        'AGREEABLENESS': 70, 
        'NEUROTICISM': 60, 
        'CONSCIENTIOUSNESS': 40, 
        'OPENNESS': 90,
        'POSSESSIVENESS': 100,
        },
    emotions = {
        'happiness': 40,    # 100 - NEUROTICISM
        'max_happiness': 50,
        'motivation': 40,    # CONSCIENTIOUSNESS
        'max_motivation': 50,
        'lust': 0,    
        'max_lust': 10,
        'jealousy': 0,
        'max_jealousy': 10,
        'anger': 0,
        'max_anger': 10,
        },
    )
default papi = Monster(
    key = 'papi',
    name = 'Papi', 
    outfit = 'daytime',
    upkeep_stats = {
        'food_use': 5,
        'power_use': 10,
        'water_use': 20,
        },
    personality = {
        'INTROVERSION': 0, 
        'AGREEABLENESS': 90, 
        'NEUROTICISM': 0, 
        'CONSCIENTIOUSNESS': 5, 
        'OPENNESS': 100,
        'POSSESSIVENESS': 0,
        },
    emotions = {
        'happiness': 100,    # 100 - NEUROTICISM
        'max_happiness': 100,
        'motivation': 5,    # CONSCIENTIOUSNESS
        'max_motivation': 50,
        'lust': 0,    
        'max_lust': 10,
        'jealousy': 0,
        'max_jealousy': 10,
        'anger': 0,
        'max_anger': 10,
        },
    )
default centorea = Monster(
    key = 'centorea',
    name = 'Centorea', 
    outfit = 'daytime',
    upkeep_stats = {
        'food_use': 15,
        'power_use': 10,
        'water_use': 20,
        },
    personality = {
        'INTROVERSION': 70, 
        'AGREEABLENESS': 80, 
        'NEUROTICISM': 30, 
        'CONSCIENTIOUSNESS': 100, 
        'OPENNESS': 25,
        'POSSESSIVENESS': 70,
        },
    emotions = {
        'happiness': 70,    # 100 - NEUROTICISM
        'max_happiness': 70,
        'motivation': 100,    # CONSCIENTIOUSNESS
        'max_motivation': 100,
        'lust': 0,    
        'max_lust': 10,
        'jealousy': 0,
        'max_jealousy': 10,
        'anger': 0,
        'max_anger': 10,
        },
    )
default suu = Monster(
    key = 'suu',
    name = 'Suu', 
    outfit = 'daytime',
    upkeep_stats = {
        'food_use': 0,
        'power_use': 0,
        'water_use': 40,
        },
    personality = {
        'INTROVERSION': 95, 
        'AGREEABLENESS': 90, 
        'NEUROTICISM': 10, 
        'CONSCIENTIOUSNESS': 25, 
        'OPENNESS': 90,
        'POSSESSIVENESS': 0,
        },
    emotions = {
        'happiness': 90,    # 100 - NEUROTICISM
        'max_happiness': 90,
        'motivation': 25,    # CONSCIENTIOUSNESS
        'max_motivation': 50,
        'lust': 0,    
        'max_lust': 10,
        'jealousy': 0,
        'max_jealousy': 10,
        'anger': 0,
        'max_anger': 10,
        },
    )
default mero = Monster(
    key = 'mero',
    name = 'Mero',
    outfit = 'daytime',
    upkeep_stats = {
        'food_use': 10,
        'power_use': 20,
        'water_use': 100,
        },
    personality = {
        'INTROVERSION': 75, 
        'AGREEABLENESS': 70, 
        'NEUROTICISM': 15, 
        'CONSCIENTIOUSNESS': 75, 
        'OPENNESS': 40,
        'POSSESSIVENESS': -50,
        },
    emotions = {
        'happiness': 85,    # 100 - NEUROTICISM
        'max_happiness': 85,
        'motivation': 75,    # CONSCIENTIOUSNESS
        'max_motivation': 75,
        'lust': 0,    
        'max_lust': 10,
        'jealousy': 0,
        'max_jealousy': 10,
        'anger': 0,
        'max_anger': 10,
        },
    )
default rachnera = Monster(
    key = 'rachnera',
    name = 'Rachnera',
    outfit = 'daytime',
    personality = {
        'INTROVERSION': 85, 
        'AGREEABLENESS': 10, 
        'NEUROTICISM': 70, 
        'CONSCIENTIOUSNESS': 90, 
        'OPENNESS': 30,
        'POSSESSIVENESS': 0,
        },
    emotions = {
        'happiness': 30,    # 100 - NEUROTICISM
        'max_happiness': 50,
        'motivation': 90,    # CONSCIENTIOUSNESS
        'max_motivation': 90,
        'lust': 0,    
        'max_lust': 10,
        'jealousy': 0,
        'max_jealousy': 10,
        'anger': 0,
        'max_anger': 10,
        },
    )
default lala = Monster(
    key = 'lala',
    name = 'Lala', 
    outfit = 'daytime',
    personality = {
        'INTROVERSION': 50, 
        'AGREEABLENESS': 50, 
        'NEUROTICISM': 60, 
        'CONSCIENTIOUSNESS': 40, 
        'OPENNESS': 40,
        'POSSESSIVENESS': 80,
        },
    emotions = {
        'happiness': 40,    # 100 - NEUROTICISM
        'max_happiness': 50,
        'motivation': 40,    # CONSCIENTIOUSNESS
        'max_motivation': 50,
        'lust': 0,    
        'max_lust': 10,
        'jealousy': 0,
        'max_jealousy': 10,
        'anger': 0,
        'max_anger': 10,
        },
    )

# reference dict
default monsters = {
    'miia': miia,
    'papi': papi,
    'centorea': centorea,
    'suu': suu,
    'mero': mero,
    'rachnera': rachnera,
    'lala': lala,
}

default monsters_placed = [miia]

init python:
    ## Monster Girls ##
    class Monster:
        def __init__(self, key, name, outfit, caretaking_days = [], location = None, job_stats = None, level_stats = None, upkeep_stats = None, emotions = None, personality = None, is_placed = False, in_room = False):
            self.key = key
            self.name = name
            self.outfit = outfit
            self.is_placed = is_placed    # True when placement occurs
            self.in_room = in_room    # assigned to monster's unique room
            self.location = location
            self.needs_caretaking = False
            self.caretaking_days = caretaking_days
            self.in_heat = False
            self.heat_days = []
            self.dialogue_counter = 0
            self.job_stats = job_stats or {
                'can_work': True,
                'is_working': False,
                'assigned_job': None,    # contains Job class objects
                'working_hours': 0,
                'passive_income': 0,
                'has_worked': False,
            }
            self.level_stats = level_stats or {
                'intimacy_scene': 1,
                'intimacy_level': 0,    # intimacy levels unlock a deeper relationship
                'intimacy_xp': 0,    # 10 xp per level
                'MAX_INTIMACY': 10,
                'skill_level': 0,    # skill level unlocks higher wages or new jobs
                'skill_xp': 0,     
                'MAX_SKILL_XP': 5,
                'max_skill_level': 5,
                'is_training': False,
            }
            self.upkeep_stats = upkeep_stats or {
                'food_use': 0,    # increases while pregnant
                'power_use': 0,    # affected by caretaking items
                'water_use': 0,    # affected by caretaking items
            }
            self.emotions = emotions or {
                'happiness': 50,    # happiness is emotional HP. low happiness affects other emotions and willingness to work.
                'max_happiness': 50,
                'motivation': 50,    # working hours modifier
                'max_motivation': 50,
                'lust': 0,    # lust causes distraction from work, reducing motivation
                'max_lust': 10,
                'jealousy': 0,    # jealousy increases lust if greater than, decreases max_happiness when lust is maxed and eventually increases anger when happiness is at zero
                'max_jealousy': 10,
                'anger': 0,    # lowers/increases max_motivation as anger increases/decreases
                'max_anger': 10,
            }          
            self.personality = personality or {
                'INTROVERSION': 0,    # ability to keep emotions contained. larger value = less likely to explain emotions, dampens happiness degradation caused by lack of caretaking
                'AGREEABLENESS': 0,    # willingness check
                'NEUROTICISM': 0,    # amplifies jealousy, & anger. dampens happiness recovery
                'CONSCIENTIOUSNESS': 0,    # conscientiousness: willingness to work and learn skills. dampens happiness drain and amplifies skill xp
                'OPENNESS': 0,    # openness to experience: amplifies/dampens intimacy xp
                'POSSESSIVENESS': 0,    # amplifies jealousy
            }     
        
        def place_monster(self):    # acquire a new monster
            self.is_placed = True
            # adds placed monster to a list   
            monsters_placed.append(self)
            if self.key == 'papi':
                papi.caretaking_days.append(day_count + 7)
            self.location = 'guest_room'
            renpy.notify(f"{self.name} has been placed in your care.") 

        def intimacy_scene(self):
            self.level_stats['intimacy_scene'] += 1
        
        def set_location(self, location_key):
            self.location = location_key
            if location_key is not 'none':
                game_locations[location_key].assign_npc(self.key)

        def set_needs_caretaking(self):
            self.needs_caretaking = True
            if self.key == 'miia':
                renpy.notify(f"Miia is molting.")
            elif self.key == 'papi':
                renpy.notify(f"Papi is molting.")
            renpy.notify(f"{self.name} requires caretaking.")
            self.block_assignment()

        def count_dialogue(self):
            self.dialogue_counter += 1
        
        def set_in_heat(self):
            self.in_heat = True
            renpy.notify(f"{self.name} is in heat.")
            self.block_assignment()

        def send_bedroom(self):
            if self.key == 'rachnera':
                self.set_location('attic')
                return
            elif self.key == 'suu':
                self.set_location('closet')
                return
            if self.in_room:
                if self.key == 'miia':
                    self.set_location('miia_room')
                elif self.key == 'papi':
                    self.set_location('papi_room')
                elif self.key == 'centorea':
                    self.set_location('centorea_room')
                elif self.key == 'mero':
                    self.set_location('mero_room')
                elif self.key == 'lala':
                    self.set_location('lala_room')
            else:
                if guest_room.current_npcs == []:
                    self.set_location('guest_room')
                else:
                    renpy.notify(f"Error: {self.name} was sent to the guest bedroom, but it's already occupied by {guest_room.current_npcs}.")
                        
        def assign_monster_room(self):    # assign monster to her unique room
            global house_upgrade_tutorial_complete
            self.in_room = True
            self.emotions['max_happiness'], self.emotions['max_motivation'] = 100, 100
            if self.key == 'miia':
                self.location = 'miia_room'
            elif self.key == 'papi':
                self.location = 'papi_room'
            elif self.key == 'centorea':
                self.location = 'centorea_room'
            elif self.key == 'mero':
                self.location = 'mero_room'
            elif self.key == 'lala':
                self.location = 'lala_room'
            renpy.notify(f"{self.name} is now assigned to her very own room.")
            if house_upgrade_tutorial and not house_upgrade_tutorial_complete:
                house_upgrade_tutorial_complete = True
                renpy.notify("House Upgrade Quest: Complete")

        def talk(self):
            if not intimacy_tutorial:
                renpy.notify('Progress through the tutorial to unlock monster dialogue.')
                return
            if self.emotions['happiness'] < 25:
                renpy.notify(f"{self.name} doesn't want to talk right now.")
            else:
                label = self.key + "_dialogue"
                renpy.call(label)
        
        def give_gift(self):
            if self.emotions['anger'] >= 30:
                renpy.notify(f"{self.name} is too angry to accept a gift from you.")
                return
            for item_key in player_items.keys():
                item = items[item_key]
                if item.is_gift:
                    renpy.say(None, "Gift giving menu goes here.")
            renpy.notify("There are no gifts in your inventory.")
        
        def block_assignment(self):
            global happiness_tutorial_unlocked
            self.job_stats['can_work'] = False
            if self.job_stats['is_working']:
                self.set_not_working()
            if self.level_stats['is_training']:
                self.set_not_training()
            if not happiness_tutorial_unlocked:
                happiness_tutorial_unlocked = True

        def unblock_assignment(self):
            self.job_stats['can_work'] = True
            renpy.notify(f"{self.name} may now accept assignments.")

        def set_working(self):    # set monster as working
            if not self.job_stats['can_work']:
                renpy.notify(f"Error: {monster.name} cannot work. She requires caretaking.")
                return
            if not self.job_stats['is_working']:
                self.job_stats['is_working'] = True

        def set_not_working(self):    # set monster as not working
            if self.job_stats['is_working'] or self.job_stats['assigned_job'] != None or self.job_stats['passive_income'] != 0:
                jobs[self.job_stats['assigned_job']].unassign_worker(self.key)    # clear Monster data from Job object
                self.job_stats['is_working'] = False    # Job data from Monster object
                self.job_stats['assigned_job'] = None
                self.clear_monster_income()
                renpy.notify(f"{self.name} no longer has a work assignment.")

        def assign_job(self, job):    # assign a job to a monster, stores a Job class reference key
            if not self.job_stats['can_work']:
                renpy.notify(f"{monster.name} cannot work. She requires caretaking.")
                return False
            if self.emotions['happiness'] < self.work_threshold():
                renpy.notify(f"{monster.name} is too unhappy to work.")
                return False
            if job.assign_worker(self.key):
                self.set_not_training()
                self.set_working()
                self.job_stats['assigned_job'] = job.key
                self.update_monster_income()
                renpy.notify(f"{monster.name} has agreed to work as a {job.name}.")
                return True
            else:
                return False
        
        def set_monster_income(self, value):     # set passive income to a certain value
            self.job_stats['passive_income'] = value

        def update_monster_income(self):           
            job = jobs[self.job_stats['assigned_job']]
            work_hours = 8    # basic working hours
            modifier = 6 * (1 - (self.emotions['motivation'] / 100))    # degrades based on motivation
            work_hours -= modifier
            self.job_stats['working_hours'] = work_hours
            income_modifier = 1 + ( (self.level_stats['skill_level'] - job.required_skill_level) * 0.2)
            self.job_stats['passive_income'] = round(job.wage * work_hours * income_modifier, 2)
        
        def clear_monster_income(self):    # set a monster's passive income to zero
            if self.job_stats['passive_income'] != 0:
                self.set_monster_income(0)
        
        def works(self):    # push the income stacks
            global passive_work_tutorial_complete
            income['monster_working'].append(self.name)
            income['monster_jobs'].append(self.job_stats['assigned_job'])
            income['monster_wages'].append(self.job_stats['passive_income'])
            self.increment_emotions()
            if not self.job_stats['has_worked']:
                self.job_stats['has_worked'] = True
            if passive_work_tutorial and not passive_work_tutorial_complete:
                passive_work_tutorial_complete = True
                renpy.notify("Work Assignment Quest: Complete")

        def intimacy_xp(self, xp_gain):
            if xp_gain > 0:
                xp_gain_mod = round(xp_gain * (1 + ((self.personality['OPENNESS'] - 50) / 100)), 2)
                self.level_stats['intimacy_xp'] += xp_gain_mod
                renpy.notify(f"{self.name}'s intimacy xp increased by {xp_gain_mod}")
                self.intimacy_up()

        def intimacy_up(self, num_levels=0):
            global intimacy_tutorial_complete
            self.level_stats['intimacy_level'] += num_levels
            if self.level_stats['intimacy_xp'] // 10 > self.level_stats['intimacy_level']:
                self.level_stats['intimacy_level'] = int(self.level_stats['intimacy_xp'] // 10)
                renpy.notify(f"{self.name}'s intimacy increased to level {self.level_stats['intimacy_level']}!")
                if intimacy_tutorial and not intimacy_tutorial_complete:
                    intimacy_tutorial_complete = True
                    renpy.notify("Intimacy Quest: Complete")
            elif self.level_stats['intimacy_level'] * 10 > self.level_stats['intimacy_xp']:
                self.level_stats['intimacy_xp'] = self.level_stats['intimacy_level'] * 10
            if self.level_stats['intimacy_level'] >= self.level_stats['MAX_INTIMACY']:
                self.level_stats['intimacy_level'] = self.level_stats['MAX_INTIMACY']
                renpy.notify(f"{self.name}'s intimacy level is maxed out!") 

        def intimacy_check(self):
            if self.level_stats['intimacy_level'] < self.level_stats['intimacy_scene']:
                renpy.notify(f"Increase your intimacy with {monster.name} further to unlock this scene.")
                return False
            return True

        def skill_xp(self, xp_gain):
            global training_tutorial_complete
            xp_gain = round(xp_gain * (1 + self.personality['CONSCIENTIOUSNESS'] / 200), 2)
            if xp_gain > 0:
                self.level_stats['skill_xp'] += xp_gain
                renpy.notify(f"{self.name} gained {xp_gain} skill xp.")
                self.skill_up()
                if training_tutorial and not training_tutorial_complete:
                    training_tutorial_complete = True
                    renpy.notify("Training Quest: Complete.")

        def skill_up(self, num_levels=0):
            self.level_stats['skill_level'] += num_levels
            if self.level_stats['skill_xp'] // 5 > self.level_stats['skill_level']:
                self.level_stats['skill_level'] = self.level_stats['skill_xp'] // 5
                self.level_stats['skill_xp'] = self.level_stats['skill_level'] * 5
                renpy.notify(f"{self.name}'s skill increased to level {self.level_stats['skill_level']}!")
            elif self.level_stats['skill_level'] < self.level_stats['max_skill_level']:
                xp_remaining = round( ( (self.level_stats['skill_level'] + 1) * 5) - self.level_stats['skill_xp'], 2)
                renpy.notify(f"{xp_remaining} more xp required for skill level {self.level_stats['skill_level'] + 1}")
            else:
                self.level_stats['skill_level'] = self.level_stats['max_skill_level']
                renpy.notify(f"{self.name}'s skill level is maxed out!")

        def skill_check(self, required_level=5):
            if self.level_stats['skill_level'] < required_level:
                renpy.notification(f"{monster.name} is not skilled enough for that.")
                return False
            return True
        
        def set_training(self):
            if self.emotions['happiness'] < self.work_threshold():
                renpy.notify(f"{monster.name} is too unhappy to train.")
                return
            self.level_stats['is_training'] = True
            self.set_not_working()
            renpy.notify(f"{self.name} is now assigned to training.")

        def set_not_training(self):
            if self.level_stats['is_training']:
                self.level_stats['is_training'] = False
                renpy.notify(f"{self.name} is no longer training.")

        ##include all emotions and character traits
        def increment_emotions(self):
            threshold = self.work_threshold()
            happiness = self.emotions['happiness']
            self.degrade_happiness()    # natural degradation
            if happiness < threshold:    # if unhappy, use conditional values from the present rather than the future
                renpy.notify(f"{self.name} is depressed...")
                self.degrade_motivation()
        
        def happiness_up(self, happiness_change = 0): 
            happiness_change = round(happiness_change * (1 - (self.personality['NEUROTICISM'] / 200)), 2)
            self.emotions['happiness'] = round(self.emotions['happiness'] + happiness_change, 2)
            if self.emotions['happiness'] >= self.emotions['max_happiness']:
                self.emotions['happiness'] = self.emotions['max_happiness']
                renpy.notify(f"{self.name} is overwhelmed with joy!")
            if self.emotions['happiness'] < 0:
                self.emotions['happiness'] = 0
            renpy.notify(f"{self.name}'s happiness changed by {happiness_change}. Current Happiness: {self.emotions['happiness']}/{self.emotions['max_happiness']}")

        def motivation_up(self, motivation_change = 0):
            self.emotions['motivation'] += motivation_change
            renpy.notify(f"{self.name}'s motivaton decreased.")
            if self.emotions['motivation'] < 0:
                self.emotions['motivation'] = 0
                renpy.notify(f"{self.name} is severely depressed...")

        def lust_up(self, lust_change = 0):
            self.emotions['lust'] += lust_change
            if self.emotions['lust'] >= self.emotions['MAX_LUST']:
                self.emotions['lust'] = self.emotions['MAX_LUST']
                renpy.notify(f"{self.name} is in a lust-addled craze... She has lost control of her base desires.")
            if self.emotions['lust'] < 0:
                self.emotions['lust'] = 0

        def jealousy_up(self, jealousy_change = 0):
            jealousy_change = jealousy_change * (1 + (self.personality['NEUROTICISM'] / 200) + (self.personality['POSSESSIVENESS'] / 100))
            self.emotions['jealousy'] += jealousy_change
            if self.emotions['jealousy'] >= self.emotions['MAX_JEALOUSY']:
                self.emotions['jealousy'] = self.emotions['MAX_JEALOUSY']
                renpy.notify(f"{self.name} has completely succumb to jealousy. She is brimming with lust sadness, and anger...")
            if self.emotions['jealousy'] < 0:
                self.emotions['jealousy'] = 0

        def anger_up(self, anger_change = 0):
            anger_change = anger_change * (1 + (self.personality['NEUROTICISM'] / 100))
            self.emotions['anger'] += anger_change
            if self.emotions['anger'] >= self.emotions['MAX_ANGER']:
                self.emotions['anger'] = self.emotions['MAX_ANGER']
                renpy.notify(f"{self.name} is furious. She is unlikely to coperate with you in any way.")
            if self.emotions['anger'] < 0:
                self.emotions['anger'] = 0

        def work_threshold(self):
            happiness_threshold = self.emotions['max_happiness'] * (1 - (self.personality['AGREEABLENESS'] / 100) )
            return happiness_threshold

        def anger_threshold(self):
            anger_threshold = self.emotions['max_anger'] * ((self.personality['AGREEABLENESS'] / 100) - 0.1)
            if anger_threshold < 10:
                anger_threshold = 10
            return anger_threshold

        def willingness_check(self):
            if self.emotions['anger'] >= self.anger_threshold():
                renpy.notify(f"{self.name} is too angry to agree with your request.")
                return False
            if self.emotions['happiness'] <= self.work_threshold():
                renpy.notify(f"{self.name} is too sad to agree with your request.")
                return False
            else:
                return True

        def introversion_threshold(self):
            introversion_threshold = self.emotions['max_happiness'] * (self.personality['INTROVERSION'] / 125)
            return introversion_threshold
        
        def confidant_check(self):
            if self.emotions['happiness'] > self.introversion_threshold():
                return True
            return False

        ##decrease happiness based on game conditions
        def degrade_happiness(self):
            if self.job_stats['is_working']:
                ##calculate happiness change
                change = round(-10 * (1 - self.personality['CONSCIENTIOUSNESS'] / 200), 2)
                self.happiness_up(happiness_change = change)
            if self.level_stats['is_training']:
                ##calculate happiness change
                change = round(-5 * (1 - self.personality['CONSCIENTIOUSNESS'] / 200), 2)
                self.happiness_up(happiness_change = change)
            ##if jealous
            ##if angry

        def degrade_motivation(self):    # motivation degrades each day happiness is below the threshold. scales with neuroticism
            change = 10 * (self.personality['NEUROTICISM'] / 100)
            self.motivation_up(motivation_change = change)

        def update_monster_upkeep(self):
            global monster_upkeep
            monster_upkeep = 0
            for monster in monsters_placed:
                if monster.is_placed:
                    monster_upkeep += (monster.upkeep_stats['food_use'] + monster.upkeep_stats['power_use'] + monster.upkeep_stats['water_use'])