
default unseen_screens = []
default player_key_items = {}    # key item inventory dict. bool value is an item description toggle for the inventory menu
default player_items = {}    # item inventory dict. contains string reference keys for name and int values for quantity    
default player_rooms = {'bedroom', 'attic', 'living_room', 'kitchen', 'bathroom', 'guest_room', 'entryway'}    # set, not dict
default income = {    # active stacks populate the instant the job is worked    # monster stacks populate while sleeping 
    'active_jobs': [],    # stack of Job objects
    'active_wages': [],    # stack
    'active': 0,    # sum of active_wages
    'stipend': 50,
    'monster_working': [],    # stack of Monster object keys
    'monster_jobs': [],    # stack of Job object keys
    'monster_wages': [],    # stack
    'monster': 0,    # sum of monster_wages
    'passive': 50,    # sum of stipend and monster
    'total': 50,    # sum of active and passive
}
default expense ={    # spending stacks populate the instant of the purchase
    'spending_items': [],    # stack of Item objects
    'spending_item_quantities': [],    # stack
    'spending_receipts': [],    # stack
    'spending': 0,    # sum of spending receipts
    'food_use': 5,
    'power_use': 15,
    'water_use': 10,
    'property_tax': 50,
    'player': 80,    # sum of spending through property_tax
    'monster': 30,    # sum of placed Monster upkeep_stats
    'total': 110,    # sum of player and monster
}

default hardware_store_job = Job('hardware_store', 'hardware clerk', 'Hardware Store', 10, 0, True, False, True, False, 1, (11, 20), (0, 0), set())
default bike_shop_job = Job('bike_shop', 'bike shop attendant', 'Bike Shop', 0, 0, False, False, False, False, 1, (0, 0), (12, 18), set()) 
default pet_shop_job = Job('pet_shop', 'pet store attendant', 'Pet Shop', 12, 0, True, False, True, False, 1, (10, 20), (0, 0), set())
default eroge_shop_job = Job('eroge_shop', 'eroge clerk', 'Eroge Shop', 15, 0, True, False, True, False, 2, (10, 18), (12, 4), set())
default maid_cafe_job = Job('maid_cafe', 'maid café server', 'Maid Café', 20, 1, True, False, True, False, 5, (12, 18), (12, 18), set())
default office_job = Job('construction_office', 'office job', 'Construction Office', 25, 2, True, False, False, False, 1, (9, 17), (6, 18), set())
default gym_job = Job('gym', 'gym worker', 'Gym', 18, 1, True, False, True, False, 3, (6, 14), (10, 18), set())

default jobs = {
    'hardware_store': hardware_store_job,
    'bike_shop': bike_shop_job,
    'pet_shop': pet_shop_job,
    'eroge_shop': eroge_shop_job,
    'maid_cafe': maid_cafe_job,
    'construction_office': office_job,
    'gym_job': gym_job,
}   

default bedroom = Location('bedroom', 'Bedroom', True, 0, 0, 5, True, [], True, True)
default attic = Location('attic', 'Attic', True, 0, 0, 10, True, [], True, True)
default guest_room = Location('guest_room', 'Guest Room', True, 0, 5, 5, True, [], True, True)
default entryway = Location('entryway', 'Entryway', True, 0, 0, 0, True, [], True, True)
default living_room = Location('living_room', 'Living Room', True, 0, 5, 0, True, [], True, True)
default kitchen = Location('kitchen', 'Kitchen', True, 0, 10, 0, True, [], True, True)
default bathroom = Location('bathroom', 'Bathroom', True, 5, 10, 0, True, [], True, True)
default miia_room = Location('miia_room', "Miia's Room", True, 0, 10, 5, True, [], True, False)
default papi_room = Location('papi_room', "Papi's Room", True, 0, 15, 5, True, [], True, False)
default centorea_room = Location('centorea_room', "Centorea's Room", True, 0, 20, 5, True, [], True, False)
default mero_room = Location('mero_room', "Mero's Room", True, 0, 25, 5, True, [], True, False)
default lala_room = Location('lala_room', "Lala's Room", True, 0, 30, 5, True, [], True, False)
default outside = Location('outside', 'Outside', False, 5, 0, 0, True, [], True, True)
default town = Location('town', 'Town Square', False, 25, 0, 0, True, [], True, True)
default hardware_store = Location('hardware_store', 'Hardware Store', False, 25, 5, 0, False, [], True, True)
default pet_shop = Location('pet_shop', 'Pet Shop', False, 25, 10, 0, False, [], True, True)
default bike_shop = Location('bike_shop', 'Bike Shop', False, 25, 15, 0, False, [], True, True)
default eroge_shop = Location('eroge_shop', 'Eroge Shop', False, 25, 20, 0, False, [], True, True)
default maid_cafe = Location('maid_cafe', 'Maid Café', False, 25, 25, 0, False, [], True, True)
default park = Location('park', 'Park', False, 35, 35, 0, False, [], True, True)
default pond = Location('pond', 'Pond', False, 35, 45, 0, False, [], True, True)
default forest = Location('forest', 'Forest', False, 45, 60, 0, False, [], True, True)
default construction_office = Location('construction_office_building', 'Construction Building', False, 40, 15, 0, True, [], True, True)
default reception = Location('construction_office', 'Construction Office', False, 40, 20, 0, False, [], True, True)
default love_hotel = Location('love_hotel', 'Love Hotel', False, 25, 5, 0, False, [], False, False)
default resturaunt = Location('resturaunt', 'Resturaunt', False, 25, 5, 0, False, [], False, False)
default aquarium = Location('aquarium', 'Aquarium', False, 25, 5, 0, False, [], False, False)
default gym = Location('gym', 'Gym', False, 45, 25, 0, False, [], False, False)

default smith_house = Location('smith_house', "Smith's House", False, 25, 5, 0, False, [], False, False)
default hayden_house = Location('hayden_house', "Hayden's House", False, 30, 45, 0, False, [], False, False)
default alice_house = Location('alice_house', "Alice's House", False, 15, 75, 0, False, [], False, False)
default polt_house = Location('polt_house', "Polt's House", False, 30, 55, 0, False, [], False, False)
default calli_house = Location('calli_house', "Calli's House", False, 60, 45, 0, False, [], False, False)
default aethel_house = Location('aethel_house', "Aethel's House", False, 75, 50, 0, False, [], False, False)

default game_locations = {
    'bedroom': bedroom,
    'attic': attic,
    'guest_room': guest_room,
    'entryway': entryway,
    'living_room': living_room,
    'kitchen': kitchen,
    'bathroom': bathroom,
    'miia_room': miia_room,
    'papi_room': papi_room,
    'centorea-room': centorea_room,
    'mero_room': mero_room,
    'lala_room': lala_room,
    'outside': outside,
    'town': town,
    'hardware_store': hardware_store,
    'pet_shop': pet_shop,
    'bike_shop': bike_shop,
    'eroge_shop': eroge_shop,
    'maid_cafe': maid_cafe,
    'park': park,
    'pond': pond,
    'forest': forest,
    'construction_office_building': construction_office,
    'construction_office': reception,
    'love_hotel': love_hotel,
    'resturaunt': resturaunt,
    'aquarium': aquarium,
    'gym': gym,
    'smith_house': smith_house,
    'alice_house': alice_house,
    'hayden_house': hayden_house,
    'polt_house': polt_house,
    'calli_house': calli_house,
    'aethel_house': aethel_house,
}

default day_count = 1
default hours = 8
default minutes = 8 * 60
default hours_clock = 8
default meridian = "AM"    # spawn on Sunday with a clock at 8 AM
default minutes_clock_int = minutes % 60 
default CURFEW = 22 * 60    # Curfew is 10 PM in minutes
default STIPEND = 50

default explore = False
default loading_bool = False
default act_one = False
default act_two = False
default act_three = False
default act_four = False

default intimacy_tutorial = False
default active_work_tutorial = False
default passive_work_tutorial = False
default happiness_tutorial = False
default training_tutorial = False
default caretaking_tutorial = False
default house_upgrade_tutorial = False
default room_upgrade_tutorial = False
default intimacy_tutorial_complete = False
default active_work_tutorial_complete = False
default passive_work_tutorial_complete = False
default happines_tutorial_complete = False
default training_tutorial_complete = False
default caretaking_tutorial_complete = False
default house_upgrade_tutorial_complete = False
default room_upgrade_tutorial_complete = False
default happiness_tutorial_unlocked = False

default find_miia_molt = False
default miia_molt_rejection = False
default find_papi_molt = False
default miia_dialogue_1 = False
default find_outside = False
default pet_shop_trading = False

default smith_random_location_timer = 0
default alice_random_location_timer = 0
default hayden_random_location_timer = 0
default polt_random_location_timer = 0

default miia_random_location_timer = 0
default papi_random_location_timer = 0
default centorea_random_location_timer = 0
default suu_random_location_timer = 0
default mero_random_location_timer = 0
default rachnera_random_location_timer = 0
default lala_random_location_timer = 0

default alice_dialogue_day_count_1 = 1000
default alice_dialogue_3 = False

default aethel_dialogue_counter = 0

default jig_day_flag = 0

default random_location_timers = [miia_random_location_timer, papi_random_location_timer, centorea_random_location_timer, suu_random_location_timer, mero_random_location_timer, rachnera_random_location_timer, lala_random_location_timer, smith_random_location_timer, alice_random_location_timer, hayden_random_location_timer, polt_random_location_timer]

default money = 500   # starting money
default player_area = 'bedroom'

init python:

    Week = ('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday')

    TIME_COST = {    # minutes_walking
        'reddit': 5,
        'fourchan': 5,
        'porn': 30,
        'online shopping': 15,
        'email': 10,
        'budget': 20,
        'check drawers': 5,
        'daydream': 10,
        'masturbate': 25,
    }
    
    ## Inventory & Items ##
    class Item:
        def __init__(self, key, name, key_item, price, description, targets, effect, is_gift):
            self.key = key
            self.name = name
            self.key_item = key_item    # True if key item
            self.price = price    # default vendor sales price
            self.description = description
            self.targets = targets    # allowable targets for using item effect
            self.effect = effect    ##maybe this will be a key to pass into a dict?
            self.is_gift = is_gift

        def get(self, get_quantity = 1):    # does not require spending
            if self.key_item:
                if self.key not in player_key_items:
                    player_key_items[self.key] = False
                    renpy.notify(f"{self.name} has been acquired!")
            else:
                if self.key not in player_items:
                    player_items[self.key] = get_quantity
                else:
                    player_items[self.key] += get_quantity
                renpy.notify(f"{self.name} quantity is now: {player_items[self.key]}.")
 
        def remove(self, remove_quantity = 1):
            if self.key_item:    # verify item is consumable
                if self.key in player_key_items:
                    player_key_items.remove(self.key)
                    renpy.notify(f"{self.name} has been consumed.")
                    return True
                else:
                    renpy.notify(f"{self.name} cannot be consumed when not present in inventory.")
                    return False
            else:
                if remove_quantity > player_items[self.key]:    # check quantity against inventory
                    renpy.notify(f"Error: Inventory quantities cannot go negative.")
                    return False                   
                else:
                    player_items[self.key] -= remove_quantity
                    renpy.notify(f"{self.name} quantity is now: {player_items[self.key]}.")
                if player_items[self.key] == 0:    # remove item from inventory if quantity is zero
                    del player_items[self.key]

    items = {
        ## Key Items ##
        # Player Upgrades
        'bike': Item('bike', 'Bike', True, 250, 'A normal bike with a metal frame and two wheels. Speeds up travel time.', None, 'bike_speed', False),
        # Room Upgrades
        'humidifier': Item('humidifier', 'Humidifier', True, 150, 'Penetrates the air with its moisture. Increased lamia comfort, minor increased water usage.', 'miia', ['comfort_up','water_up_small'], False),
        'heat_lamp': Item('heat_lamp', 'Heat Lamp', True, 100, 'Converts electrical energy to thermal, illuminating whomever may bask within its radiant glow. Increased lamia comfort, increased power usage.', 'miia', ['comfort_up', 'power_up'], False),
        'perch': Item('perch', 'Perch', True, 75, 'A suspended, wooden rod. Thick enough to endure the sharpest of talons. Increased harpy comfort.', 'papi', 'comfort_up', False),
        'mineral_block': Item('mineral_block', 'Mineral Block', True, 250, 'Fortified nutrition strengthens centaur motivation.', 'centorea', 'motivation_up', False),
        'chemistry_kit': Item('chemistry_kit', 'Chemistry Kit', True, 400, "Test and modify poolwater chemistry. Increased mermaid comfort.", 'mero', 'comfort_up', False),
        # Caretaking Items
        'scale_oil': Item('scale_oil', 'Scale Oil', True, 120, 'Premium moisturizer for the molting living among us.', 'miia', 'can_work', False),
        'horse_brush': Item('horse_brush', 'Horse Brush', True, 250, "Mares recognize their owner's affection through regular, meticulous grooming. Brushes with fine, sturdy bristles make for silky coats and luscious manes.", 'centorea', 'comfort_up', False),
        'hoof_trimmer': Item('hoof_trimmer', 'Hoof Trimmer', True, 125, "Horses were never meant to live indoors. The least you can do in return is keep their hooves healthy.", 'centorea', 'can_work', False),
        # Event Items
        'plushies': Item('plushies', 'Plushies', True, 75, "An assortment of cute, fluffy plush monsters. Extra soft and cuddly. Comforts girls who might have trouble sleeping.", 'papi', 'comfort_up', False),
        #'rain_jacket': Item('rain_jacket', 'Rain Jacket', 275, True, "Wicks away any wet fluids.", 'suu', '', False),
        #'wheelchair': Item('wheelchair', 'Wheelchair', 350, True, "", 'mero', 'can_work', False),
        ## Consumables ##    # target: construction means the consumable is payment for a house upgrade
        'wooden_boards': Item('wooden_boards', 'Wooden Boards', False, 10, "Beams made of wood. Useful for building things.", 'construction', None, False),
        'nails': Item('nails', 'Nails', False, 2, "Metal nails. Useful for building things.", 'construction', None, False),
        'toys': Item('toys', 'Toys', False, 25, "Toys selected specifically for hyperactive, distractable harpy girls. It's only a matter of time before it winds up broken...", 'papi', 'happiness_up', True),
        'water_filters': Item('water_filters', 'Water Filters', False, 25, "Filters removes debris and accumulated grime from poolwater.", 'mero', 'can_work', False),
        'parfaits': Item('parfaits', 'Parfaits', False, 12, "A sweet treat from the café.", 'monsters', 'try_happiness_up', True),
        # Romance Items
        #'outfits': Item('outfits', 'Outfits', False, 50, ".", 'monsters', 'try_affection_up', True),
        #'flowers': Item('flowers', 'Flowers', False, 50, ".", 'monsters', 'try_affection_up', True),
        #'jewelry': Item('jewelry', 'Jewelry', False, 50, ".", 'monsters', 'try_affection_up', True),
        #'chocolates': Item('chocolates', 'Chocolates', False, 50, ".", 'monsters', 'try_affection_up', True),
    }    
    ## Vendor Inventories ##
    hardware_store_items = [items['wooden_boards'], items['nails'], items['humidifier'], items['water_filters'], items['chemistry_kit']]
    pet_shop_items = [items['heat_lamp'], items['scale_oil'], items['perch'], items['toys'], items['horse_brush'], items['hoof_trimmer'], items['mineral_block']]
    eroge_shop_items = [items['plushies']]
    maid_cafe_items = [items['parfaits']]
    bike_shop_items = [items['bike']]

    class Job:
        def __init__(self, key, name, location_name, wage, required_skill_level, is_active_work, active_unlocked, is_passive_work, passive_unlocked, worker_slots, weekday_hours, weekend_hours, assigned_workers):
            self.key = key
            self.name = name
            self.location_name = location_name
            self.wage = wage
            self.required_skill_level = required_skill_level
            self.is_active_work = is_active_work
            self.active_unlocked = active_unlocked
            self.is_passive_work = is_passive_work
            self.passive_unlocked = passive_unlocked
            self.worker_slots = worker_slots
            self.weekday_hours = weekday_hours    # tuple: opening and closing hours as integers
            self.weekend_hours = weekend_hours    # tuple: opening and closing hours as integers
            self.assigned_workers = assigned_workers    # list

        def check_shop_hours(self):    # check if time is after opening hours and before closing hours
            job_key = self.key
            if check_weekday():
                if hours >= self.weekday_hours[0] and hours < self.weekday_hours[1]:
                    game_locations[job_key].set_open()
                    return True
                else:
                    game_locations[job_key].set_closed()
                    return False
            else:
                if hours >= self.weekend_hours[0] and hours < self.weekend_hours[1]:
                    game_locations[job_key].set_open()
                    return True
                else:
                    game_locations[job_key].set_closed()
                    return False

        def hours(self):
            if check_weekday():
                return self.weekday_hours[0]
            else:
                return self.weekend_hours[0]

        def check_shift_hours(self, shift_length_hours):    # check if shift end time exceeds closing hours
            if not time_check(shift_length_hours * 60):
                return False
            shift_end_hours = (minutes / 60) + shift_length_hours    
            if check_weekday():
                if shift_end_hours <= self.weekday_hours[1]:
                    return True
                else:
                    return False
            else:
                if shift_end_hours <= self.weekend_hours[1]:
                    return True
                else:
                    return False

        def earn_active_wages(self, time_hours):
            time_action(time_hours * 60)
            wages = time_hours * self.wage
            income['active_wages'].append(wages)    # push to income stack

        def assign_worker(self, monster_key):    # assigns passive worker to a particular job
            monster = monsters[monster_key]
            if len(self.assigned_workers) >= self.worker_slots:
                renpy.notify(f"There are no job openings left at the {self.location_name}.")
                return False                
            if monster.level_stats['skill_level'] < self.required_skill_level:
                renpy.notify(f"{monster.name}'s skill level ({monster.level_stats['skill_level']}) isn't high enough for the {self.location_name} assignment. Required Level: {self.required_skill_level}.")
                return False   
            for job in jobs.values():    # clear existing assignment if already assigned
                if monster_key in job.assigned_workers and job != self:
                    monster.set_not_working()      
            self.assigned_workers.add(monster_key)
            return True

        def unassign_worker(self, monster_key):    # unassign passive worker by name
            self.assigned_workers.remove(monster_key)

    class Location:
        def __init__(self, key, name, in_player_house, x_coordinate, y_coordinate, z_coordinate, is_open, current_npcs, unlocked, exists):
            self.key = key
            self.name = name
            self.in_player_house = in_player_house
            self.x_coordinate = x_coordinate
            self.y_coordinate = y_coordinate
            self.z_coordinate = z_coordinate
            self.is_open = is_open
            self.current_npcs = current_npcs
            self.unlocked = unlocked
            self.exists = exists

        def set_open(self):
            self.is_open = True

        def set_closed(self):
            self.is_open = False

        def assign_npc(self, npc_key):
            self.current_npcs.append(npc_key)

        def clear_npcs(self):
            self.current_npcs = []

    # implement existing checks
    # implement is_open checks for travel and fast_travel
    # implement unlocked checks
    # push current_npcs in handler

label after_load:
    if game_npcs != [smith, tio, alice, aethel, aurora, calli, hayden, jig]:
        $ game_npcs = [smith, tio, alice, aethel, aurora, calli, hayden, jig]
    return