package com.mcd.restaurant.component;

import com.mcd.restaurant.common.MapperUtils;
import com.mcd.restaurant.component.controller.view.request.DeviceDetailRequestDTO;
import com.mcd.restaurant.component.controller.view.request.DevicePropsRequestDTO;
import com.mcd.restaurant.component.controller.view.response.DeviceDetailResponseDTO;
import com.mcd.restaurant.component.error.ComponentBadRequestException;
import com.mcd.restaurant.component.service.ComponentService;
import com.mcd.restaurant.component.service.ComponentUtils;
import com.mcd.restaurant.component.service.DeviceComponentPropType;
import com.mcd.restaurant.component.service.DeviceStatusType;
import com.mcd.restaurant.deployment.service.DeployService;
import com.mcd.restaurant.deployment.service.DeploymentUtils;
import com.mcd.restaurant.deployment.testUtils.DeploymentTestUtility;
import com.mcd.restaurant.model.ComponentType;
import com.mcd.restaurant.model.Market;
import com.mcd.restaurant.model.Restaurant;
import com.mcd.restaurant.model.Vendor;
import com.mcd.restaurant.repository.*;
import com.mcd.restaurant.repository.bulk.ComponentBulkCRUDRepository;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.test.util.ReflectionTestUtils;

import java.util.ArrayList;
import java.util.List;

import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.mockito.Mockito.when;
class ComponentServiceTest {

    @Mock
    private DeploymentGroupRepository deploymentGroupRepositoryMock;
    @Mock
    private DeploymentHistoryRepository deploymentHistoryRepositoryMock;
    @Mock
    private ComponentBulkCRUDRepository componentBulkCRUDRepository;
    @Mock
    private RestaurantRepository restaurantRepository;
    @Mock
    private ComponentRepository componentRepository;
    @Mock
    private DeploymentTagRepository deploymentTagRepository;
    @InjectMocks
    private DeployService deployService;
    @InjectMocks
    private DeploymentUtils deploymentUtils;
    @Mock
    private DeploymentUtils deploymentUtilsMock;
    @Mock
    private MapperUtils mapperUtilsMock;
    @InjectMocks
    private MapperUtils mapperUtils;
    @InjectMocks
    private DeploymentTestUtility deploymentUtilityTest;
    @Mock
    private MarketRepository marketRepository;
    @Mock
    private ComponentTypeRepository componentTypeRepositoryMock;

    @InjectMocks
    private ComponentService componentService;

    @InjectMocks
    private ComponentUtils componentUtils;

    @Mock
    private VendorRepository vendorRepository;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    void insertComponentDataSuccess()
    {
        List<DeviceDetailRequestDTO> componentDTOS = new ArrayList<>();
        DeviceDetailRequestDTO componentDTO = new DeviceDetailRequestDTO();
        List<DevicePropsRequestDTO> requestDTO= new ArrayList<>();

        DevicePropsRequestDTO deviceProp = new DevicePropsRequestDTO();
        deviceProp.setPropertyName("ipAddress");
        deviceProp.setPropertyValue("123.32.12.36");
        requestDTO.add(deviceProp);
        deviceProp = new DevicePropsRequestDTO();
        deviceProp.setPropertyName("laneNumber");
        deviceProp.setPropertyValue("1");
        requestDTO.add(deviceProp);

        componentDTO.setMarketName("Us");
        componentDTO.setRestaurantName("9918");
        componentDTO.setModelNumber("41");
        componentDTO.setReportedVersion("6.50.5.1");
        componentDTO.setSerialNumber("123345634");
        componentDTO.setHardwareVersion("2");
        componentDTO.setDeviceProps(requestDTO);
        componentDTOS.add(componentDTO);
        ReflectionTestUtils.setField(componentUtils, "marketRepository", marketRepository);
        ReflectionTestUtils.setField(componentUtils, "restaurantRepository", restaurantRepository);
        ReflectionTestUtils.setField(componentService, "componentUtils", componentUtils);
        ReflectionTestUtils.setField(componentUtils, "componentRepository", componentRepository);
        ReflectionTestUtils.setField(componentUtils, "vendorRepository", vendorRepository);
        Mockito.when(marketRepository.findAll(Mockito.any(QuerySpec.class))).thenReturn(getMockMarket());
        Mockito.when(marketRepository.prepareQuerySpecFilterForFilteringMarketByName(Mockito.anyString())).thenCallRealMethod();
        Mockito.when(restaurantRepository.findAll(Mockito.any(QuerySpec.class))).thenReturn(getMockRestaurant());
        Mockito.when(restaurantRepository.prepareQuerySpecFilterForRestaurantByRestaurantNumbersAndMarketId(Mockito.anyList(), Mockito.anyInt())).thenCallRealMethod();
        when(componentTypeRepositoryMock.getComponentTypeByName(Mockito.anyString())).thenReturn(mockComponentTypeList());
        when(vendorRepository.getVendorByName(Mockito.anyString())).thenReturn(mockVendorNameList());
        Mockito.when(restaurantRepository.findAll(Mockito.any(QuerySpec.class))).thenReturn(getMockRestaurant());
        Mockito.when(restaurantRepository.prepareQuerySpecFilterForRestaurantByName(Mockito.anyString())).thenCallRealMethod();
        Mockito.when(componentRepository.getAllComponentByRestaurantId(Mockito.anyInt())).thenCallRealMethod();
        Mockito.when(componentRepository.save(Mockito.any())).thenAnswer(i -> i.getArguments()[0]);
        DeviceDetailResponseDTO responseDDTO=componentService.deviceDetails(componentDTOS);
        Assertions.assertEquals(componentDTOS.size(),responseDDTO.getComponent().size());
    }

    @Test
    void insertComponentDataFailure()
    {
        List<DeviceDetailRequestDTO> componentDTOS = new ArrayList<>();
        DeviceDetailRequestDTO componentDTO = new DeviceDetailRequestDTO();
        List<DevicePropsRequestDTO> requestDTO= new ArrayList<>();

        DevicePropsRequestDTO deviceProp = new DevicePropsRequestDTO();
        deviceProp.setPropertyName("ipAddress");
        deviceProp.setPropertyValue("123.32.12.36");
        requestDTO.add(deviceProp);
        deviceProp = new DevicePropsRequestDTO();
        deviceProp.setPropertyName("laneNumber");
        deviceProp.setPropertyValue("1");
        requestDTO.add(deviceProp);

        componentDTO.setMarketName("Us");
        componentDTO.setRestaurantName("9918");
        componentDTO.setModelNumber("41");
        componentDTO.setReportedVersion("6.50.5.1");
        componentDTO.setSerialNumber("123345634");
        componentDTO.setHardwareVersion("2");
        componentDTO.setDeviceProps(requestDTO);
        componentDTOS.add(componentDTO);
        ReflectionTestUtils.setField(componentUtils, "marketRepository", marketRepository);
        ReflectionTestUtils.setField(componentUtils, "restaurantRepository", restaurantRepository);
        ReflectionTestUtils.setField(componentService, "componentUtils", componentUtils);
        ReflectionTestUtils.setField(componentUtils, "componentRepository", componentRepository);
        ReflectionTestUtils.setField(componentUtils, "vendorRepository", vendorRepository);
        Mockito.when(marketRepository.findAll(Mockito.any(QuerySpec.class))).thenReturn(getMockMarket());
        Mockito.when(marketRepository.prepareQuerySpecFilterForFilteringMarketByName(Mockito.anyString())).thenCallRealMethod();
        Mockito.when(restaurantRepository.findAll(Mockito.any(QuerySpec.class))).thenReturn(getMockRestaurant());
        Mockito.when(restaurantRepository.prepareQuerySpecFilterForRestaurantByRestaurantNumbersAndMarketId(Mockito.anyList(), Mockito.anyInt())).thenCallRealMethod();
        when(componentTypeRepositoryMock.getComponentTypeByName(Mockito.anyString())).thenReturn(mockComponentTypeList());
        when(vendorRepository.getVendorByName(Mockito.anyString())).thenReturn(mockVendorNameList());
        Mockito.when(componentRepository.save(Mockito.any())).thenAnswer(i -> i.getArguments()[0]);
        assertThrows(ComponentBadRequestException.class, () -> componentService.deviceDetails(componentDTOS));
    }

    @Test
    void insertComponentDataEmptyDTOFailure()
    {
        List<DeviceDetailRequestDTO> componentDTOS = null;
        assertThrows(ComponentBadRequestException.class, () -> componentService.deviceDetails(componentDTOS));
    }

    @Test
    void insertComponentDataEmptyDevicePromFailure()
    {
        List<DeviceDetailRequestDTO> componentDTOS = new ArrayList<>();
        DeviceDetailRequestDTO componentDTO = new DeviceDetailRequestDTO();
        List<DevicePropsRequestDTO> requestDTO= new ArrayList<>();
        componentDTO.setMarketName("Us");
        componentDTO.setRestaurantName("9918");
        componentDTO.setModelNumber("41");
        componentDTO.setReportedVersion("6.50.5.1");
        componentDTO.setSerialNumber("123345634");
        componentDTO.setHardwareVersion("2");
        componentDTO.setDeviceProps(requestDTO);
        componentDTOS.add(componentDTO);
        assertThrows(ComponentBadRequestException.class, () -> componentService.deviceDetails(componentDTOS));
    }

    @Test
    void insertComponentDataWithoutDevicePropValueSuccess()
    {
        List<DeviceDetailRequestDTO> componentDTOS = new ArrayList<>();
        DeviceDetailRequestDTO componentDTO = new DeviceDetailRequestDTO();
        List<DevicePropsRequestDTO> requestDTO= new ArrayList<>();

        DevicePropsRequestDTO deviceProp = new DevicePropsRequestDTO();
        deviceProp.setPropertyName("ipAddress");
        deviceProp.setPropertyValue("123.32.12.36");
        requestDTO.add(deviceProp);
        deviceProp = new DevicePropsRequestDTO();
        deviceProp.setPropertyName("laneNumber");
        deviceProp.setPropertyValue("");
        requestDTO.add(deviceProp);

        componentDTO.setMarketName("Us");
        componentDTO.setRestaurantName("9918");
        componentDTO.setModelNumber("41");
        componentDTO.setReportedVersion("6.50.5.1");
        componentDTO.setSerialNumber("123345634");
        componentDTO.setHardwareVersion("2");
        componentDTO.setDeviceProps(requestDTO);
        componentDTOS.add(componentDTO);
        assertThrows(ComponentBadRequestException.class, () -> componentService.deviceDetails(componentDTOS));
    }


    private DefaultResourceList<Market> getMockMarket() {
        Market market = new Market();
        market.setName("US");
        DefaultResourceList<Market> markets = new DefaultResourceList<>();
        markets.add(market);
        return markets;
    }

    private DefaultResourceList<Restaurant> getMockRestaurant() {
        Restaurant restaurant = new Restaurant();
        restaurant.setName("9918");
        DefaultResourceList<Restaurant> restaurants = new DefaultResourceList<>();
        restaurants.add(restaurant);
        return restaurants;
    }

    private ResourceList<ComponentType> mockComponentTypeList()
    {
        DefaultResourceList<ComponentType> types = new DefaultResourceList<>();
        types.add(mockComponentType());
        return types;
    }

    private ComponentType mockComponentType() {
        ComponentType type = new ComponentType();
        type.setId(5);
        return type;

    }

    private ResourceList<Vendor> mockVendorNameList()
    {
        DefaultResourceList<Vendor> vendorName = new DefaultResourceList<>();
        vendorName.add(mockVendorName());
        return vendorName;
    }

    private Vendor mockVendorName() {
        Vendor name = new Vendor();
        name.setId(5);
        return name;

    }

}
