-- Restaurant view
-- To fetch the restaurant along with its hierarchical information in a single hit
CREATE ALGORITHM=UNDEFINED DEFINER=`breadmin`@`%` SQL SECURITY DEFINER VIEW `breservicesdb`.`restaurant_view`
AS select `r`.`id` AS `id`,`r`.`created` AS `created`,`r`.`updated` AS `updated`,`bhn`.`id` AS `hierarchy_Node_Id`,
`sd`.`id` AS `store_Dashboard_Id`,`r`.`no_of_lanes` AS `no_of_lanes`,`r`.`store_status` AS `store_status`,
`bhn`.`restaurant_no` AS `restaurant_no`,`bhn`.`ip_address` AS `ip_address`,`bhn`.`node_name` AS `node_name`,
`sd`.`latitude` AS `latitude`,`sd`.`longitude` AS `longitude`,`sd`.`city` AS `city`,`sd`.`store_address` AS `store_address`,
`sd`.`operational_hours` AS `operational_hours`,`sd`.`state` AS `state`,`sd`.`contact_number` AS `contact_number`,
`sd`.`country` AS `country`,`sd`.`zip_code` AS `zip_code`,`sd`.`owner_name` AS `owner_name`,`sd`.`owner_type` AS `owner_type`,
`bhm`.`node_name` AS `market_name`,`bhm`.`id` AS `market_node_id`,`bhc`.`node_name` AS `coop_name`,`bhc`.`id` AS `coop_node_id`,
`bhr`.`node_name` AS `region_name`,`bhr`.`id` AS `region_node_id`
from (((((`breservicesdb`.`restaurants` `r` join `breservicesdb`.`bre_hierarchy_nodes` `bhn`
on((`r`.`bre_hierarchy_node_id` = `bhn`.`id`))) left join `breservicesdb`.`bre_hierarchy_nodes` `bhm`
on((`bhn`.`parent_market_id` = `bhm`.`id`))) left join `breservicesdb`.`bre_hierarchy_nodes` `bhr`
on((`bhn`.`parent_region_id` = `bhr`.`id`))) left join `breservicesdb`.`bre_hierarchy_nodes` `bhc`
on((`bhn`.`parent_coop_id` = `bhc`.`id`))) left join `breservicesdb`.`store_demographics` `sd`
on((`sd`.`bre_hierarchy_node_id` = `bhn`.`id`)))

-- After insert trigger on deployment_history table
-- To update the status of deployment group based on the status of inserted entries in deployment history table
CREATE DEFINER=`breadmin`@`%` TRIGGER `deployment_history_AFTER_INSERT` AFTER INSERT ON `deployment_history` FOR EACH ROW BEGIN
DECLARE done INT DEFAULT FALSE;
    DECLARE InProgress varchar(20) DEFAULT 'In-Progress';
    DECLARE Completed varchar(20) DEFAULT 'Completed';
    DECLARE Failed varchar(20) DEFAULT 'Failed';
    DECLARE Scheduled varchar(20) DEFAULT 'Scheduled';
    DECLARE Cancelled varchar(20) DEFAULT 'Cancelled';
    DECLARE ImageCache varchar(80) DEFAULT 'imagecache';
    DECLARE Is_InProgress TINYINT DEFAULT 0;
    DECLARE Is_Completed TINYINT DEFAULT 0;
    DECLARE Is_Failed TINYINT DEFAULT 0;
    DECLARE Is_Scheduled TINYINT DEFAULT 0;
    DECLARE Is_Cancelled TINYINT DEFAULT 0;
    DECLARE Is_Imagecache TINYINT DEFAULT 1;
    DECLARE v_status varchar(20);
    DECLARE v_application varchar(100);
    DECLARE cur CURSOR FOR
        SELECT DISTINCT status FROM deployment_history WHERE deployment_group_id = NEW.deployment_group_id;
    DECLARE applicationCur CURSOR FOR
        SELECT DISTINCT application_name FROM deployment_history WHERE deployment_group_id = NEW.deployment_group_id;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
    OPEN applicationCur;
        cur_loop: LOOP
            FETCH applicationCur INTO v_application;
            IF done THEN
                LEAVE cur_loop;
            END IF;

            IF v_application != ImageCache THEN
                SET Is_Imagecache = FALSE;
            END IF;
        END LOOP;
    CLOSE applicationCur;
   SET done=FALSE;
if Is_Imagecache then
    SET Is_InProgress = TRUE;
else
    OPEN cur;
        cur_loop: LOOP
            FETCH cur INTO v_status;
            IF done THEN
                LEAVE cur_loop;
            END IF;

            IF v_status = Failed THEN
                SET Is_Failed = TRUE;
            ELSEIF v_status = InProgress THEN
                SET Is_InProgress = TRUE;
                 LEAVE cur_loop;
            ELSEIF v_status = Cancelled THEN
                SET Is_Cancelled = TRUE;
                 LEAVE cur_loop;
            ELSEIF v_status = Scheduled THEN
                SET Is_Scheduled = TRUE;
            ELSE
                SET Is_Completed = TRUE;
            END IF;

        END LOOP;
    CLOSE cur;
END IF;
    IF Is_Cancelled THEN
        UPDATE `breservicesdb`.`deployment_groups` SET `status` = Cancelled WHERE `id`= NEW.deployment_group_id;
    ELSEIF Is_InProgress THEN
        UPDATE `breservicesdb`.`deployment_groups` SET `status` = InProgress WHERE `id`= NEW.deployment_group_id;
    ELSEIF Is_Failed THEN
        UPDATE `breservicesdb`.`deployment_groups` SET `status` = Failed WHERE `id`= NEW.deployment_group_id;
    ELSEIF Is_Scheduled THEN
        UPDATE `breservicesdb`.`deployment_groups` SET `status` = Scheduled WHERE `id`= NEW.deployment_group_id;
    ELSE
        UPDATE `breservicesdb`.`deployment_groups` SET `status` = Completed WHERE `id`= NEW.deployment_group_id;
    END IF;
END

-- After update trigger in deployment_history
-- To update the status of deployment group based on the status of updated entries in deployment history table
CREATE DEFINER=`breadmin`@`%` TRIGGER `deployment_history_AFTER_UPDATE` AFTER UPDATE ON `deployment_history` FOR EACH ROW BEGIN
DECLARE done INT DEFAULT FALSE;
    DECLARE InProgress varchar(20) DEFAULT 'In-Progress';
    DECLARE Completed varchar(20) DEFAULT 'Completed';
    DECLARE Failed varchar(20) DEFAULT 'Failed';
    DECLARE Scheduled varchar(20) DEFAULT 'Scheduled';
    DECLARE Cancelled varchar(20) DEFAULT 'Cancelled';
    DECLARE Is_InProgress TINYINT DEFAULT 0;
    DECLARE Is_Completed TINYINT DEFAULT 0;
    DECLARE Is_Failed TINYINT DEFAULT 0;
    DECLARE Is_Scheduled TINYINT DEFAULT 0;
    DECLARE Is_Cancelled TINYINT DEFAULT 0;
    DECLARE v_status varchar(20);
    DECLARE cur CURSOR FOR
        SELECT DISTINCT status FROM deployment_history WHERE deployment_group_id = NEW.deployment_group_id;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

    OPEN cur;
        cur_loop: LOOP
            FETCH cur INTO v_status;
            IF done THEN
                LEAVE cur_loop;
            END IF;

            IF v_status = Failed THEN
				SET Is_Failed = TRUE;
			ELSEIF v_status = InProgress THEN
				SET Is_InProgress = TRUE;
                 LEAVE cur_loop;
			ELSEIF v_status = Cancelled THEN
				SET Is_Cancelled = TRUE;
				 LEAVE cur_loop;
			ELSEIF v_status = Scheduled THEN
				SET Is_Scheduled = TRUE;
            ELSE
				SET Is_Completed = TRUE;
            END IF;

        END LOOP;
    CLOSE cur;
    IF Is_Cancelled THEN
        UPDATE `breservicesdb`.`deployment_groups` SET `status` = Cancelled WHERE `id`= NEW.deployment_group_id;
   	ELSEIF Is_Failed THEN
        UPDATE `breservicesdb`.`deployment_groups` SET `status` = Failed WHERE `id`= NEW.deployment_group_id;
	ELSEIF Is_InProgress THEN
        UPDATE `breservicesdb`.`deployment_groups` SET `status` = InProgress WHERE `id`= NEW.deployment_group_id;
    ELSEIF Is_Scheduled THEN
        UPDATE `breservicesdb`.`deployment_groups` SET `status` = Scheduled WHERE `id`= NEW.deployment_group_id;
    ELSE
        UPDATE `breservicesdb`.`deployment_groups` SET `status` = Completed WHERE `id`= NEW.deployment_group_id;
	END IF;
END
