package com.mcd.restaurant.repository;

import com.mcd.restaurant.model.Vendor;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;

@Component
public class VendorRepository extends JpaEntityRepositoryBase<Vendor, Integer> {
    public VendorRepository() {
        super(Vendor.class);
    }

    public ResourceList<Vendor> getVendorByName(String name) {
        QuerySpec vendorSpecs = new QuerySpec(Vendor.class);
        vendorSpecs.addFilter(PathSpec.of("name").filter(FilterOperator.EQ, name));
        return this.findAll(vendorSpecs);
    }
}
