package com.mcd.restaurant.repository;

import com.mcd.restaurant.model.Market;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;

import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class MarketRepository extends JpaEntityRepositoryBase<Market, Integer> {
    public MarketRepository() {
        super(Market.class);
    }


    public QuerySpec prepareQuerySpecFilterForFilteringMarketByName(String marketName) {
        QuerySpec querySpec = new QuerySpec(Market.class);
        FilterSpec filterSpec = new FilterSpec(PathSpec.of("name"), FilterOperator.EQ, marketName);
        querySpec.setFilters(Stream.of(filterSpec).collect(Collectors.toList()));
        return querySpec;
    }
}
