package com.mcd.restaurant.repository;

import com.mcd.restaurant.dashboard.utils.StoreDashboardConstants;
import com.mcd.restaurant.model.HardwareDetail;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class HardwareDetailRepository extends JpaEntityRepositoryBase<HardwareDetail, Integer> {
    public HardwareDetailRepository() {
        super(HardwareDetail.class);
    }

    public QuerySpec prepareQuerySpecFilterForHardwareDetail(Integer restaurantId) {
        QuerySpec querySpec = new QuerySpec(HardwareDetail.class);
        FilterSpec filterSpec = new FilterSpec(PathSpec.of(StoreDashboardConstants.RESTAURANT_ID), FilterOperator.EQ, restaurantId);
        querySpec.addFilter(filterSpec);
        return querySpec;
    }

    public List<HardwareDetail> prepareQuerySpecFilterWithRestaurantIdAndNodeIdForHardwareDetail(Integer restaurantId, List<String> nodeId) {
        QuerySpec querySpec = new QuerySpec(HardwareDetail.class);
        FilterSpec filterSpecRestaurantId = new FilterSpec(PathSpec.of(StoreDashboardConstants.RESTAURANT_ID), FilterOperator.EQ, restaurantId);
        FilterSpec filterSpecNodeId = new FilterSpec(PathSpec.of("nodeId"), FilterOperator.EQ, nodeId);
        FilterSpec filterFinal = FilterSpec.and(Stream.of(filterSpecRestaurantId, filterSpecNodeId).collect(Collectors.toList()));
        querySpec.addFilter(filterFinal);
        return this.findAll(querySpec);
    }

    public List<HardwareDetail> findByRestaurantNumber(String restaurantNo) {
        QuerySpec querySpec = new QuerySpec(HardwareDetail.class);
        FilterSpec filterSpec = new FilterSpec(PathSpec.of("restaurant.name"), FilterOperator.EQ, restaurantNo);
        querySpec.addFilter(filterSpec);
        return this.findAll(querySpec);
    }

}
