package com.mcd.restaurant.repository;

import com.mcd.restaurant.bundledrelease.controller.view.request.DeployBundleReleaseAppCheckDTO;
import com.mcd.restaurant.bundledrelease.controller.view.request.MetaDataDetails;
import com.mcd.restaurant.bundledrelease.utils.BundleReleaseUtility;
import com.mcd.restaurant.common.MapperUtils;
import com.mcd.restaurant.model.BundleReleaseAppVersion;
import com.mcd.restaurant.model.Restaurant;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.exception.InternalServerErrorException;
import io.crnk.core.exception.MethodNotAllowedException;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepositoryBase;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class DeployBundleReleaseAppVersionResourceRepository extends ResourceRepositoryBase<DeployBundleReleaseAppCheckDTO, String> {
    @Autowired
    private ComponentRepository componentRepository;
    @Autowired
    private BundleReleaseAppVersionRepository bundleReleaseAppVersionRepository;
    @Autowired
    private BundleReleaseUtility bundleReleaseUtility;
    @Autowired
    private MapperUtils mapperUtils;
    @Autowired
    private AppRepository appRepository;

    private static final String ANY_VERSION = "any";

    public DeployBundleReleaseAppVersionResourceRepository() {
        super(DeployBundleReleaseAppCheckDTO.class);
    }

    @Override
    public DeployBundleReleaseAppCheckDTO findOne(String id, QuerySpec querySpec) {
        throw new MethodNotAllowedException("method not allowed");

    }

    /**
     *This method will find the list of stores that eligible for bundle deployment
     */
    @Override
    public ResourceList<DeployBundleReleaseAppCheckDTO> findAll(QuerySpec querySpec) {
        try {
            ResourceList<DeployBundleReleaseAppCheckDTO> dtoList = new DefaultResourceList<>();
            List<List<Restaurant>> restaurantMajorList = new ArrayList<>();
            FilterSpec sourceBundleFilterSpec = bundleReleaseUtility.getBundleReleaseFilter(querySpec, "sourceBundleId");
            FilterSpec targetBundleFilterSpec = bundleReleaseUtility.getBundleReleaseFilter(querySpec, "targetBundleId");

            Integer sourceBundleReleaseId = Integer.parseInt(sourceBundleFilterSpec.getValue());
            Integer targetBundleReleaseId = Integer.parseInt(targetBundleFilterSpec.getValue());

            List<BundleReleaseAppVersion> sourceBundleReleaseAppVersion = bundleReleaseUtility.findAppVersionsToBeUpdated(sourceBundleReleaseId);
            Map<String, String> sourceAppNameVersionMap = bundleReleaseUtility.prepareMapForSourceAppNameAndVersion(sourceBundleReleaseAppVersion);

            List<BundleReleaseAppVersion> targetBundleReleaseAppVersion = bundleReleaseUtility.findAppVersionsToBeUpdated(targetBundleReleaseId);
            Map<String, String> targetAppNameVersionMap = bundleReleaseUtility.prepareMapForSourceAppNameAndVersion(targetBundleReleaseAppVersion);

            Map<String, String> copySourceAppNameVersionMap = new HashMap<>(sourceAppNameVersionMap);

            validateForCommonAndNewApps(sourceAppNameVersionMap, targetAppNameVersionMap, copySourceAppNameVersionMap);
            //saving unwanted iterations for invalid apps
            copySourceAppNameVersionMap.clear();
            copySourceAppNameVersionMap.putAll(sourceAppNameVersionMap);

            if (!sourceAppNameVersionMap.isEmpty()) {
                sourceAppNameVersionMap.forEach(
                        (app, version) -> {
                            List<com.mcd.restaurant.model.Component> singleAppComponentList = componentRepository.findAll(prepareQuerySpecFilterForSingleVersionInBundleAppVersion(app, version));
                            restaurantMajorList.add(singleAppComponentList.stream().map(com.mcd.restaurant.model.Component::
                                    getRestaurant
                            ).distinct().collect(Collectors.toList()));
                        }
                );
                List<Restaurant> restaurantList = bundleReleaseUtility.identifyCommonRestaurant(restaurantMajorList);
                restaurantList.forEach(i -> {
                    DeployBundleReleaseAppCheckDTO dto = mapperUtils.map(i, DeployBundleReleaseAppCheckDTO.class);
                    dto.setBundleId(sourceBundleReleaseId);
                    dtoList.add(dto);
                });
            }
            return new DefaultResourceList<>(dtoList, MetaDataDetails.builder().metaDataCount(dtoList.size()).build(), null);
        } catch (BadRequestException e) {
            throw e;
        } catch (Exception e) {
            throw new InternalServerErrorException("Some Exception Ocurred. Cannot process the request");
        }

    }


    private void validateForCommonAndNewApps(Map<String, String> sourceAppNameVersionMap, Map<String, String> targetAppNameVersionMap, Map<String, String> copySourceAppNameVersionMap) {
        targetAppNameVersionMap.forEach((app, version) -> {
            //identifying common apps with same version and droping them from the list. point 5
            if (sourceAppNameVersionMap.containsKey(app) && sourceAppNameVersionMap.get(app).equals(version)) {
                sourceAppNameVersionMap.remove(app);
            }
            //apps in target that are not there in source will be dropped too as they must be deployed too and no change needed
        });
        copySourceAppNameVersionMap.forEach((app, version) -> {
            //identifying common apps with same version and droping them from the list. point 5
            if (!targetAppNameVersionMap.containsKey(app)) {
                sourceAppNameVersionMap.remove(app);
            }
            //apps in source that are not there in target will be dropped too as they must be deployed too and no change needed
        });
        //adding apps that are not there in aource with any version.
        targetAppNameVersionMap.forEach((app, version) -> {
            //identifying common apps with same version and droping them from the list. point 5
            if (!sourceAppNameVersionMap.containsKey(app)) {
                sourceAppNameVersionMap.put(app, ANY_VERSION);
            }

        });


    }


    public QuerySpec prepareQuerySpecFilterForSingleVersionInBundleAppVersion(String key, String value) {
        FilterSpec filterSpecFinal;
        FilterSpec filterSpecName = new FilterSpec(PathSpec.of("name"), FilterOperator.EQ, key);
        FilterSpec filterType = new FilterSpec(PathSpec.of("type.name"), FilterOperator.EQ, "docker");
        FilterSpec filterNull = new FilterSpec(PathSpec.of("restaurant.hierarchyNode"), FilterOperator.NEQ, null);
        if (!value.equalsIgnoreCase(ANY_VERSION)) {
            FilterSpec filterSpecVersion = new FilterSpec(PathSpec.of("reportedVersion"), FilterOperator.EQ, value);
            filterSpecFinal = FilterSpec.and(Stream.of(filterSpecName, filterSpecVersion, filterType, filterNull).collect(Collectors.toList()));
        } else {
            filterSpecFinal = FilterSpec.and(Stream.of(filterSpecName, filterType, filterNull).collect(Collectors.toList()));
        }
        QuerySpec querySpec = new QuerySpec(com.mcd.restaurant.model.Component.class);
        querySpec.setFilters(Stream.of(filterSpecFinal).collect(Collectors.toList()));
        return querySpec;
    }
}