package com.mcd.restaurant.repository;

import com.mcd.restaurant.model.ComponentType;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;

@Component
public class ComponentTypeRepository extends JpaEntityRepositoryBase<ComponentType, Integer> {
    public ComponentTypeRepository() {
        super(ComponentType.class);
    }

    public ResourceList<ComponentType> getComponentTypeByName(String name) {
        QuerySpec componentTypeSpecs = new QuerySpec(ComponentType.class);
        componentTypeSpecs.addFilter(PathSpec.of("name").filter(FilterOperator.EQ, name));
        return this.findAll(componentTypeSpecs);
    }
}